/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class WSISOStatus
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(null);
        ipmiOEMWebSettingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            byte[] status = ipmiOEMWebSettingCommand.getVMDeviceStatus();
            for (int i2 = 0; i2 < status.length; ++i2) {
                String statusLabel = "";
                switch (status[i2]) {
                    case 0: {
                        statusLabel = "IMA File";
                        break;
                    }
                    case 3: {
                        statusLabel = "Disk Device";
                        break;
                    }
                    case 4: {
                        statusLabel = "ISO file through Windows Sharing";
                        break;
                    }
                    case -1: {
                        statusLabel = "Empty device";
                        break;
                    }
                    default: {
                        statusLabel = "(" + ByteUtility.byteToHex(status[i2]) + ")";
                    }
                }
                this.statusCode = 0;
                MOut.G(this).println("Device " + (i2 + 1) + ":" + statusLabel);
            }
        }
        catch (IPMIException e2) {
            if (e2.getIPMIMessage() != null && e2.getIPMIMessage().completionCode == -43) {
                MOut.G(this).println("Please activate SFT-OOB-LIC or SFT-SUM-LIC node product key for this command");
                this.statusCode = 153;
            } else {
                MOut.G(this).println("This device doesn't support WSISO commands");
                this.statusCode = 153;
            }
            return;
        }
    }
}

