/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.deploy;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.text.deploy.DeployTarget;
import com.supermicro.ipmi.text.deploy.DeployTaskFactory;
import java.util.HashMap;

public class DeployManager {
    private static DeployManager instance = new DeployManager();
    HashMap<String, DeployTarget> deployTargets = new HashMap();

    private DeployManager() {
    }

    public static DeployManager getInstance() {
        return instance;
    }

    public HashMap getDeployTargets() {
        return this.deployTargets;
    }

    public DeployTarget createDeployTarget(IPMIInterfaceConfig config, String name) throws IPMIException {
        if (config.getIp().equals("0.0.0.0")) {
            throw new IPMIException("IP = 0.0.0.0");
        }
        if (config.getIp() == null) {
            throw new IPMIException("IP = null");
        }
        DeployTarget dTarget = new DeployTarget(config, name);
        DeployTaskFactory.createDeployTask(dTarget);
        this.deployTargets.put(config.getIp(), dTarget);
        return dTarget;
    }

    public String listStatus() {
        StringBuffer sb = new StringBuffer();
        for (String item : this.deployTargets.keySet()) {
            DeployTarget dTarget = this.deployTargets.get(item);
            try {
                sb.append(dTarget.getStatus());
            }
            catch (IPMIException ex) {
                sb.append("unknown");
                ex.printStackTrace();
            }
        }
        return sb.toString();
    }

    public void clear() {
        for (String item : this.deployTargets.keySet()) {
            DeployTarget dTarget = this.deployTargets.get(item);
            if (dTarget.getDeployTask() == null) continue;
            try {
                dTarget.getDeployTask().clear();
            }
            catch (IPMIException ex) {
                ex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.deployTargets.clear();
    }
}

