/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.summary;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.util.StringUtil;
import nn.pp.drvredir.ByteUtility;

public class CPUInfo {
    private IPMINM20Command ipmiCommand;
    private int curPstat = -1;
    private int numOfPstat = 0;
    private int curTstat = -1;
    private int numOfTstat = 0;
    private int curMaxAllowCores = -1;
    private int numOfCores = 0;
    private String splitLine = "+------------------------------------+";
    private String splitLineD = "+====================================+";
    private String format = "|%8s|%8s|%18s|\n";
    private String[] fields = new String[]{"P-State", "T-State", "Max Allowed Cores"};

    public CPUInfo(IPMINM20Command ipmiCommand) {
        this.ipmiCommand = ipmiCommand;
        this.getInfo();
    }

    private void getInfo() {
        this.getCPUState();
        this.getCPUCore();
    }

    private void getCPUState() {
        try {
            byte[] cpuState = this.ipmiCommand.getMaxAllowedCPU_P_T_State((byte)0);
            byte[] numOfState = this.ipmiCommand.getNumberOf_P_T_StateRequest((byte)0);
            this.curPstat = cpuState[0];
            this.curTstat = cpuState[1];
            this.numOfPstat = numOfState[0];
            this.numOfTstat = numOfState[1];
        }
        catch (IPMIException e2) {
            System.out.format("[Error] Get CPU State %s", e2.getMessage() == null ? "" : ":" + e2.getMessage());
        }
    }

    private void getCPUCore() {
        try {
            this.curMaxAllowCores = this.ipmiCommand.getMaxAllowedCPUCores((byte)0);
            this.numOfCores = ByteUtility.twoBytesToIntLSB(this.ipmiCommand.getNumberOfCPUCoresRequest((byte)0));
        }
        catch (IPMIException e2) {
            System.out.format("[Error] Get CPU Core %s", e2.getMessage() == null ? "" : ":" + e2.getMessage());
        }
    }

    public void lineDisplay() {
        StringBuilder sb = new StringBuilder();
        sb.append("CPU Information (current/total):\n");
        sb.append("\tP-State: " + this.data(this.curPstat, this.numOfPstat));
        sb.append(",\tT-State: " + this.data(this.curTstat, this.numOfTstat));
        sb.append(",\tMax Allowed Cores: " + this.data(this.curMaxAllowCores, this.numOfCores));
        System.out.println(sb.toString());
    }

    public void display() {
        System.out.println(StringUtil.center("CPU Information", this.splitLine.length()));
        System.out.println(this.splitLine);
        System.out.format(this.format, this.fields);
        System.out.println(this.splitLineD);
        System.out.format(this.format, this.data(this.curPstat, this.numOfPstat), this.data(this.curTstat, this.numOfTstat), this.data(this.curMaxAllowCores, this.numOfCores));
        System.out.println(this.splitLine);
    }

    private String data(int cur, int total) {
        return String.format("%s/%s", cur, total);
    }
}

