/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.summary;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.text.nm.summary.CUPSPolicyDto;
import com.supermicro.ipmi.util.StringUtil;
import java.util.LinkedList;
import java.util.List;

public class CUPSPolicyInfo {
    private List<CUPSPolicyDto> cupsPolicies = new LinkedList<CUPSPolicyDto>();
    private IPMINM20Command ipmiCommand;
    private String splitLine = "+-------------------------------------------------+";
    private String splitLineD = "+=================================================+";
    private String format = "|%-10s|%-14s|%8s|%14s|\n";
    private String[] fields = new String[]{"Domain", "Target", "State", "Threshold (%)"};

    public CUPSPolicyInfo(IPMINM20Command ipmiCommand) {
        this.ipmiCommand = ipmiCommand;
        this.getInfo();
    }

    private void getInfo() {
        int[] domain;
        for (int d2 : domain = new int[]{1, 2, 4}) {
            try {
                this.getCUPSPolicy((byte)d2, (byte)0);
                this.getCUPSPolicy((byte)d2, (byte)1);
            }
            catch (IPMIException e2) {
                // empty catch block
            }
        }
    }

    private void getCUPSPolicy(byte domain, byte target) throws IPMIException {
        IPMINM20Command.CUPSPolicy policy = this.ipmiCommand.getCUPSPolicy(domain, target);
        if ((policy.cupsThreshold & 0xFF) != 0) {
            this.cupsPolicies.add(new CUPSPolicyDto(policy));
        }
    }

    public void display() {
        if (this.cupsPolicies.size() == 0) {
            System.out.println("CUPS Policy: Not set");
            return;
        }
        System.out.println(StringUtil.center("CUPS Policy", this.splitLine.length()));
        System.out.println(this.splitLine);
        System.out.format(this.format, this.fields);
        System.out.println(this.splitLineD);
        for (CUPSPolicyDto cp : this.cupsPolicies) {
            System.out.format(this.format, cp.domain, cp.target, cp.state, cp.threshold);
            System.out.println(this.splitLine);
        }
    }
}

