/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.summary;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.Common;
import com.supermicro.ipmi.nm.sensor.CUPSSensor;
import com.supermicro.ipmi.nm.sensor.SensorDefine;

public class NMCUPSUtil {
    private IPMINM20Command ipmiCommand;

    public NMCUPSUtil(IPMINM20Command ipmiCommand) {
        this.ipmiCommand = ipmiCommand;
    }

    public CUPS getCUPS() throws IPMIException {
        int core = -1;
        int io = -1;
        int mem = -1;
        try {
            core = this.getCUPSSensor(190);
        }
        catch (IPMIException e2) {
            System.out.println("[Error] Get CUPS Core failed\n");
        }
        try {
            io = this.getCUPSSensor(191);
        }
        catch (IPMIException e3) {
            System.out.println("[Error] Get CUPS IO failed\n");
        }
        try {
            mem = this.getCUPSSensor(192);
        }
        catch (IPMIException e4) {
            System.out.println("[Error] Get CUPS Memory failed\n");
        }
        if (core < 0 && io < 0 && mem < 0) {
            throw new IPMIException();
        }
        return new CUPS(core, mem, io);
    }

    private int getCUPSSensor(int sensorId) throws IPMIException {
        SensorDefine s = Common.SENSOR_DEFINES.get(sensorId);
        IPMIMessage resMessage = this.ipmiCommand.getSensorReadingCommand((byte)sensorId);
        if (resMessage != null && resMessage.completionCode == 0) {
            return new CUPSSensor(s, resMessage.data, null).getReading();
        }
        throw new IPMIException();
    }

    public class CUPS {
        public final int core;
        public final int mem;
        public final int io;

        public CUPS(int core, int mem, int io) {
            this.core = core;
            this.mem = mem;
            this.io = io;
        }
    }
}

