/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.summary;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.Common;
import com.supermicro.ipmi.util.StringUtil;
import java.util.LinkedHashMap;
import java.util.Map;

public class PowerBudgetInfo {
    private Map<String, Integer> pbInfo = new LinkedHashMap<String, Integer>();
    private IPMINM20Command ipmiCommand;
    private String splitLine = "+-----------------------------------+";
    private String splitLineD = "+===================================+";
    private String format = "|%-24s|%10s|\n";
    private String[] fields = new String[]{"Domain", "Limit (W)"};

    public PowerBudgetInfo(IPMINM20Command ipmiCommand) {
        this.ipmiCommand = ipmiCommand;
        this.getInfo(Common.Domain.ENTIRE);
        this.getInfo(Common.Domain.CPU);
        this.getInfo(Common.Domain.MEMORY);
        this.getInfo(Common.Domain.HPIO);
    }

    public void getInfo(Common.Domain d2) {
        try {
            int limit = this.ipmiCommand.getTotalPowerBudgetRequest((byte)d2.getValue());
            if (limit == 0) {
                return;
            }
            this.pbInfo.put(Common.Domain.getDesc(d2.getValue()), limit);
        }
        catch (IPMIException e2) {
            return;
        }
    }

    public void lineDisplay() {
        if (this.pbInfo.size() == 0) {
            System.out.println("Total Power Budget: Not set");
            return;
        }
        StringBuilder sb = new StringBuilder();
        String seperator = "";
        sb.append("Total Power Budget (W):\n\t");
        for (Map.Entry<String, Integer> pb : this.pbInfo.entrySet()) {
            sb.append(seperator);
            seperator = ", ";
            sb.append(String.format("%s: %s", pb.getKey(), pb.getValue()));
        }
        System.out.println(sb.toString());
    }

    public void display() {
        if (this.pbInfo.size() == 0) {
            System.out.println("Total Power Budget: Not set");
            return;
        }
        System.out.println(StringUtil.center("Total Power Budget", this.splitLine.length()));
        System.out.println(this.splitLine);
        System.out.format(this.format, this.fields);
        System.out.println(this.splitLineD);
        for (Map.Entry<String, Integer> pb : this.pbInfo.entrySet()) {
            System.out.format(this.format, pb.getKey(), pb.getValue());
            System.out.println(this.splitLine);
        }
    }
}

