/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.summary;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.Common;
import com.supermicro.ipmi.text.nm.summary.NMPowerUsage;
import com.supermicro.ipmi.util.StringUtil;

public class PowerUsageInfo {
    private NMPowerUsage.PowerUsage usage;
    private boolean exception = false;
    private String splitLine = "+------------------------------------+";
    private String splitLineD = "+====================================+";
    private String format = "|%-24s|%11s|\n";
    private String[] fields = new String[]{"Domain", "Usage (W)"};

    public PowerUsageInfo(IPMINM20Command ipmiCommand) {
        try {
            NMPowerUsage pu = new NMPowerUsage(ipmiCommand);
            this.usage = pu.getPowerUsage();
        }
        catch (IPMIException e2) {
            this.exception = true;
            System.out.format("[Error] Get Power Usage Information %s", e2.getMessage() == null ? "" : ":" + e2.getMessage());
        }
    }

    public void lineDisplay() {
        if (this.exception) {
            return;
        }
        System.out.format("Power Usage (W):\n\tSystem: %d, CPU: %d, Memory: %d\n", this.usage.sys, this.usage.cpu, this.usage.mem);
    }

    public void display() {
        System.out.println(StringUtil.center("Power Usage", this.splitLine.length()));
        System.out.println(this.splitLine);
        System.out.format(this.format, this.fields);
        System.out.println(this.splitLineD);
        System.out.format(this.format, Common.Domain.getDesc(Common.Domain.ENTIRE.getValue()), this.usage.sys);
        System.out.println(this.splitLine);
        System.out.format(this.format, Common.Domain.getDesc(Common.Domain.CPU.getValue()), this.usage.cpu);
        System.out.println(this.splitLine);
        System.out.format(this.format, Common.Domain.getDesc(Common.Domain.MEMORY.getValue()), this.usage.mem);
        System.out.println(this.splitLine);
    }
}

