/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.suspendperiod;

import com.supermicro.ipmi.text.NM20SetSuspendPeriodsCommand;
import com.supermicro.ipmi.text.nm.suspendperiod.AddPeriod;
import com.supermicro.ipmi.text.nm.suspendperiod.ClearPeriod;
import com.supermicro.ipmi.text.nm.suspendperiod.DeletePeriod;
import com.supermicro.ipmi.text.nm.suspendperiod.UpdatePeriod;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public abstract class AbstractSuspenPeriodCommand {
    protected String[] parameters;

    public static AbstractSuspenPeriodCommand getCommand(NM20SetSuspendPeriodsCommand.ACTION act, String[] parameters) {
        switch (act) {
            case ADD: {
                return new AddPeriod(parameters);
            }
            case UPDATE: {
                return new UpdatePeriod(parameters);
            }
            case DELETE: {
                return new DeletePeriod(parameters);
            }
            case CLEAR: {
                return new ClearPeriod(parameters);
            }
        }
        throw new IllegalArgumentException("Undefined command");
    }

    public AbstractSuspenPeriodCommand(String[] parameters) {
        this.parameters = parameters;
    }

    public static boolean checkForUnique(String str) {
        boolean containsUnique = false;
        for (char c2 : str.toCharArray()) {
            containsUnique = str.indexOf(c2) == str.lastIndexOf(c2);
        }
        return containsUnique;
    }

    public abstract byte[] getNewPeriod(byte[] var1);

    public abstract int getDomainId();

    public abstract int getPolicyId();

    public abstract void help();

    protected int[] getDays(String daysInString) {
        int len = daysInString.length();
        if (len > 7) {
            throw new IllegalArgumentException("Invalid value: <days> length to long");
        }
        int[] days = new int[len];
        for (char ch : daysInString.toCharArray()) {
            int idx = daysInString.indexOf(ch);
            if (!Character.isDigit(ch) || ch > '7' || ch < '0') {
                throw new IllegalArgumentException("Invalid value: <days> out of range or not digit");
            }
            if (idx != daysInString.lastIndexOf(ch)) {
                throw new IllegalArgumentException("Invalid value: <days> duplicate");
            }
            days[idx] = Integer.parseInt(String.valueOf(ch));
        }
        return days;
    }

    protected int getTimeInMinute(String time) throws ParseException {
        if ("24".equals(time.substring(0, 2))) {
            if ("00".equals(time.substring(2, 4))) {
                return 1440;
            }
            time = "00" + time.substring(2, 4);
        }
        SimpleDateFormat format = new SimpleDateFormat("HHmm");
        Calendar calendar = Calendar.getInstance();
        format.setLenient(false);
        calendar.setTime(format.parse(time));
        return calendar.get(11) * 60 + calendar.get(12);
    }

    protected byte getRecurrencePattern(int[] days) {
        if (days == null) {
            return -128;
        }
        byte pattern = 0;
        for (int i2 = 0; i2 < days.length; ++i2) {
            pattern = (byte)(1 << days[i2] - 1 | pattern & 0xFF);
        }
        return pattern;
    }
}

