/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.pmbusStatus;

import com.supermicro.ipmi.ByteUtility;
import java.util.Map;
import java.util.TreeMap;

public abstract class Status {
    public static final String STATUS_BYTE = "Status Byte";
    public static final String STATUS_WORD = "Status Word";
    public static final String STATUS_CML = "Status CML";
    public static final String STATUS_INPUT = "Status Input";
    public static final String STATUS_VOUT = "Status Vout";
    public static final String STATUS_IOUT = "Status Iout";
    public static final String STATUS_MFR = "Status MFR";
    public static final String STATUS_FAN_1_2 = "Status FAN_1_2";
    public static final String STATUS_FAN_3_4 = "Status FAN_3_4";
    public static final String STATUS_OTHER = "Status Other";
    public static final String STATUS_TEMPERTURE = "Status Temperture";
    public byte statusByte;

    public abstract byte getStatusCode();

    public abstract String getStatusMsgTittle();

    public abstract String getStatusDesc(int var1);

    public abstract String getSimpleStatusDesc(int var1);

    protected int[] toStatusBinArr(byte statusByte) {
        String statusByteStr = Integer.toBinaryString(statusByte);
        int[] statusByteBinArr = new int[8];
        int strLen = statusByteStr.length();
        int j2 = statusByteStr.length();
        for (int i2 = 0; i2 < statusByteBinArr.length; ++i2) {
            if (i2 > strLen - 1) continue;
            statusByteBinArr[i2] = statusByteStr.charAt(j2 - 1) - 48;
            --j2;
        }
        return statusByteBinArr;
    }

    public Map<Integer, String> getStatusDescription() {
        TreeMap<Integer, String> msgMap = new TreeMap<Integer, String>();
        int[] statusByteBinArr = this.toStatusBinArr(this.statusByte);
        for (int i2 = 0; i2 < statusByteBinArr.length; ++i2) {
            String msg;
            if (statusByteBinArr[i2] != 1 || (msg = this.getStatusDesc(i2)) == null) continue;
            msgMap.put(i2, msg);
        }
        return msgMap;
    }

    public Map<Integer, String> getSimpleStatusDescription() {
        TreeMap<Integer, String> msgMap = new TreeMap<Integer, String>();
        int[] statusByteBinArr = this.toStatusBinArr(this.statusByte);
        for (int i2 = 0; i2 < statusByteBinArr.length; ++i2) {
            String msg;
            if (statusByteBinArr[i2] != 1 || (msg = this.getSimpleStatusDesc(i2)) == null) continue;
            msgMap.put(i2, msg);
            break;
        }
        return msgMap;
    }

    public String toString() {
        return "Get status byte: [" + ByteUtility.byteToHex(this.statusByte) + "] by status code: [" + ByteUtility.byteToHex(this.getStatusCode()) + "][" + this.getStatusMsgTittle() + "]";
    }
}

