/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.trap;

import com.supermicro.ipmi.trap.AsnDecodingException;
import java.math.BigInteger;

public class BerDecoder {
    private static final byte LONG_LENGTH = -128;
    private static final byte HIGH_BIT = -128;
    private static final byte EXTENSION_ID = 31;
    private static final byte CONSTRUCTOR = 32;

    public Object[] ASNDecode(byte[] databuff, int[] startoffset) {
        Object[] rVar;
        int n = startoffset[0];
        startoffset[0] = n + 1;
        switch (databuff[n]) {
            case 2: {
                rVar = new Object[1];
                break;
            }
            default: {
                rVar = new Object[2];
            }
        }
        return rVar;
    }

    protected int byteToInt(byte b2) {
        return b2 < 0 ? 256 + b2 : b2;
    }

    protected long byteToLong(byte b2) {
        return b2 < 0 ? 256L + (long)b2 : (long)b2;
    }

    protected boolean isConstructor(byte b2) {
        return (b2 & 0x20) == 32;
    }

    protected boolean isExtensionId(byte b2) {
        return (b2 & 0x1F) == 31;
    }

    public Object[] parseLength(byte[] buf, int startOffset) throws AsnDecodingException {
        byte numBytes;
        if (buf.length - startOffset < 1) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        Object[] retVals = new Object[2];
        if (((numBytes = buf[startOffset++]) & 0xFFFFFF80) == 0) {
            numBytes = (byte)(numBytes & 0x7F);
            retVals[1] = new Integer(this.byteToInt(numBytes));
        } else if ((numBytes = (byte)(numBytes & 0x7F)) == 1) {
            if (buf.length - startOffset < 1) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            retVals[1] = new Integer(this.byteToInt(buf[startOffset++]));
        } else if (numBytes == 2) {
            if (buf.length - startOffset < 2) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            int val = this.byteToInt(buf[startOffset++]) << 8 | this.byteToInt(buf[startOffset++]);
            retVals[1] = new Integer(val);
        } else {
            throw new AsnDecodingException("Invalid ASN.1 length");
        }
        retVals[0] = new Integer(startOffset);
        return retVals;
    }

    public Object[] parseHeader(byte[] buf, int startOffset) throws AsnDecodingException {
        byte asnType;
        if (buf.length - startOffset < 1) {
            throw new AsnDecodingException("Insufficent buffer length");
        }
        if (this.isExtensionId(asnType = buf[startOffset++])) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        Object[] lenVals = this.parseLength(buf, startOffset);
        Object[] rVals = new Object[]{lenVals[0], new Byte(asnType), lenVals[1]};
        return rVals;
    }

    public Object[] parseInteger32(byte[] buf, int startOffset) throws AsnDecodingException {
        Object[] hdrVals = this.parseHeader(buf, startOffset);
        startOffset = (Integer)hdrVals[0];
        Byte asnType = (Byte)hdrVals[1];
        int asnLength = (Integer)hdrVals[2];
        if (buf.length - startOffset < asnLength) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        if (asnLength > 4) {
            throw new AsnDecodingException("Integer too large: cannot decode");
        }
        int asnValue = 0;
        if ((buf[startOffset] & 0xFFFFFF80) == -128) {
            asnValue = -1;
        }
        while (asnLength-- > 0) {
            asnValue = asnValue << 8 | this.byteToInt(buf[startOffset++]);
        }
        Object[] rVals = new Object[]{new Integer(startOffset), asnType, new Integer(asnValue)};
        return rVals;
    }

    public Object[] parseUInteger32(byte[] buf, int startOffset) throws AsnDecodingException {
        Object[] hdrVals = this.parseHeader(buf, startOffset);
        startOffset = (Integer)hdrVals[0];
        Byte asnType = (Byte)hdrVals[1];
        int asnLength = (Integer)hdrVals[2];
        if (buf.length - startOffset < asnLength) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        if (asnLength > 5) {
            throw new AsnDecodingException("Integer too large: cannot decode");
        }
        long asnValue = 0L;
        if ((buf[startOffset] & 0xFFFFFF80) == -128) {
            asnValue = -1L;
        }
        while (asnLength-- > 0) {
            asnValue = asnValue << 8 | this.byteToLong(buf[startOffset++]);
        }
        Object[] rVals = new Object[]{new Integer(startOffset), asnType, new Long(asnValue &= 0xFFFFFFFFL)};
        return rVals;
    }

    public Object[] parseUInteger64(byte[] buf, int startOffset) throws AsnDecodingException {
        Object[] hdrVals = this.parseHeader(buf, startOffset);
        startOffset = (Integer)hdrVals[0];
        Byte asnType = (Byte)hdrVals[1];
        int asnLength = (Integer)hdrVals[2];
        if (buf.length - startOffset < asnLength) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        if (asnLength > 9) {
            throw new AsnDecodingException("Integer too large: cannot decode");
        }
        byte[] asnBuf = new byte[asnLength];
        for (int i2 = 0; i2 < asnLength; ++i2) {
            asnBuf[i2] = buf[startOffset++];
        }
        BigInteger asnValue = new BigInteger(asnBuf);
        Object[] rVals = new Object[]{new Integer(startOffset), asnType, asnValue};
        return rVals;
    }

    public Object[] parseNull(byte[] buf, int startOffset) throws AsnDecodingException {
        Object[] hdrVals = this.parseHeader(buf, startOffset);
        if ((Integer)hdrVals[2] != 0) {
            throw new AsnDecodingException("Malformed ASN.1 Type");
        }
        Object[] rVals = new Object[]{hdrVals[0], hdrVals[1]};
        return rVals;
    }

    public Object[] parseString(byte[] buf, int startOffset) throws AsnDecodingException {
        Object[] hdrVals = this.parseHeader(buf, startOffset);
        startOffset = (Integer)hdrVals[0];
        Byte asnType = (Byte)hdrVals[1];
        int asnLength = (Integer)hdrVals[2];
        if (buf.length - startOffset < asnLength) {
            throw new AsnDecodingException("Insufficent buffer length");
        }
        byte[] opaque = new byte[asnLength];
        try {
            this.copy(buf, startOffset, opaque, 0, asnLength);
        }
        catch (ArrayIndexOutOfBoundsException err) {
            throw new AsnDecodingException("Buffer underflow exception");
        }
        Object[] rVals = new Object[]{new Integer(startOffset + asnLength), asnType, opaque};
        return rVals;
    }

    public Object[] parseObjectId(byte[] buf, int startOffset) throws AsnDecodingException {
        int[] retOids;
        Object[] hdrVals = this.parseHeader(buf, startOffset);
        startOffset = (Integer)hdrVals[0];
        Byte asnType = (Byte)hdrVals[1];
        int asnLength = (Integer)hdrVals[2];
        if (buf.length - startOffset < asnLength) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        if (asnLength == 0) {
            int[] ids = new int[2];
            ids[1] = 0;
            ids[0] = 0;
            Object[] rVals = new Object[]{new Integer(startOffset), asnType, ids};
            return rVals;
        }
        int idsOff = 0;
        int[] ids = new int[asnLength + 1];
        --asnLength;
        int oid = this.byteToInt(buf[startOffset++]);
        ids[idsOff++] = oid / 40;
        ids[idsOff++] = oid % 40;
        while (asnLength > 0) {
            oid = 0;
            boolean done = false;
            do {
                --asnLength;
                byte b2 = buf[startOffset++];
                oid = oid << 7 | b2 & 0x7F;
                if ((b2 & 0xFFFFFF80) != 0) continue;
                done = true;
            } while (!done);
            ids[idsOff++] = oid;
        }
        if (idsOff == ids.length) {
            retOids = ids;
        } else {
            retOids = new int[idsOff];
            this.copy(ids, 0, retOids, 0, idsOff);
        }
        Object[] rVals = new Object[]{new Integer(startOffset), asnType, retOids};
        return rVals;
    }

    protected void copy(byte[] src, int srcOff, byte[] dest, int destOff, int bytesToCopy) throws ArrayIndexOutOfBoundsException {
        if (dest.length - destOff < bytesToCopy || src.length - srcOff < bytesToCopy) {
            throw new ArrayIndexOutOfBoundsException("Destination or source buffer is insufficent");
        }
        for (int x = bytesToCopy - 1; x >= 0; --x) {
            dest[destOff + x] = src[srcOff + x];
        }
    }

    protected void copy(int[] src, int srcOff, int[] dest, int destOff, int intsToCopy) throws ArrayIndexOutOfBoundsException {
        if (dest.length - destOff < intsToCopy || src.length - srcOff < intsToCopy) {
            throw new ArrayIndexOutOfBoundsException("Destination or source buffer is insufficent");
        }
        for (int x = intsToCopy - 1; x >= 0; --x) {
            dest[destOff + x] = src[srcOff + x];
        }
    }
}

