/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.trap;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIPEFCommand;
import com.supermicro.ipmi.RMCP;
import com.supermicro.ipmi.trap.AsnDecodingException;
import com.supermicro.ipmi.trap.PETAcknowledge;
import com.supermicro.ipmi.trap.TrapCollector;
import com.supermicro.ipmi.trap.TrapReceiverListener;
import com.supermicro.ipmi.trap.parser.BaseParser;
import com.supermicro.ipmi.trap.parser.ParserFactory;
import com.supermicro.ipmi.trap.traps.BaseTrap;
import com.supermicro.ipmi.trap.traps.SNMPv1Trap;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class Receiver {
    public boolean isStart = false;
    ArrayList trapReceiverListeners;
    TrapCollector trapCollector;
    GlobalDefine gd = new GlobalDefine();
    private static Receiver instance = new Receiver();

    public static Receiver getInstance() {
        return instance;
    }

    public Receiver() {
        this.trapReceiverListeners = new ArrayList();
        this.trapCollector = new TrapCollector();
    }

    public void addTrapReceiverListener(TrapReceiverListener l) {
        this.trapReceiverListeners.add(l);
    }

    public void removeTrapReceiverListener(TrapReceiverListener l) {
        this.trapReceiverListeners.remove(l);
    }

    public TrapCollector getTrapCollector() {
        return this.trapCollector;
    }

    public ArrayList getTrapReceiverListeners() {
        return this.trapReceiverListeners;
    }

    public void setTrapCollector(TrapCollector trapCollector) {
        this.trapCollector = trapCollector;
    }

    public void setTrapReceiverListeners(ArrayList trapReceiverListeners) {
        this.trapReceiverListeners = trapReceiverListeners;
    }

    public boolean startReceiver() {
        try {
            TrapListener trapListener = new TrapListener();
            trapListener.setTrapCollector(this.trapCollector);
            trapListener.setTrapReceiverListeners(this.trapReceiverListeners);
            trapListener.start();
            this.isStart = true;
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public void stopReceiver() {
        byte[] buff = new byte[]{0};
        InetAddress ia = null;
        try {
            ia = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        DatagramPacket dp = new DatagramPacket(buff, 1, ia, 162);
        try {
            DatagramSocket socket = new DatagramSocket();
            socket.send(dp);
            this.isStart = false;
        }
        catch (SocketException socketException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendAcknowledge(String ip, PETAcknowledge petAck) throws Exception {
        IPMIInterfaceConfig rmcpConfig = new IPMIInterfaceConfig();
        rmcpConfig.setIp(ip);
        rmcpConfig.setTimeout(3);
        rmcpConfig.setRetry(3);
        RMCP rmcp = new RMCP();
        rmcp.initialize(rmcpConfig);
        IPMIPEFCommand ipmiPEFCommand = new IPMIPEFCommand(rmcp);
        ipmiPEFCommand.sendPETAcknowledge(petAck);
        rmcp.closeSocket();
    }

    private class TrapListener
    extends Thread {
        protected DatagramSocket socket = null;
        protected BufferedReader in = null;
        protected boolean KeepWaiting = true;
        ArrayList trapReceiverListeners = null;
        TrapCollector trapCollector = null;

        public TrapListener() throws IOException {
            InetAddress ip = InetAddress.getByName("0.0.0.0");
            this.socket = new DatagramSocket(162, ip);
            this.trapReceiverListeners = new ArrayList();
            this.trapCollector = new TrapCollector();
        }

        public void setTrapReceiverListeners(ArrayList trapReceiverListeners) {
            this.trapReceiverListeners = trapReceiverListeners;
        }

        public void setTrapCollector(TrapCollector trapCollector) {
            this.trapCollector = trapCollector;
        }

        @Override
        public void run() {
            byte[] bufin = new byte[1024];
            try {
                this.socket.setSoTimeout(5000);
            }
            catch (SocketException e2) {
                e2.printStackTrace();
            }
            while (this.KeepWaiting) {
                try {
                    BaseTrap baseTrap;
                    DatagramPacket packet = new DatagramPacket(bufin, bufin.length);
                    this.socket.receive(packet);
                    int dataLength = packet.getLength();
                    if (dataLength == 1 && bufin[0] == 0) break;
                    BaseParser parser = ParserFactory.getTrapParser(bufin);
                    if (parser == null || (baseTrap = parser.decode(bufin, dataLength)) == null) continue;
                    if (baseTrap.getTrapType() == 0) {
                        SNMPv1Trap trapV1 = (SNMPv1Trap)baseTrap;
                        if (trapV1.getPETAck() == null) continue;
                        Receiver.this.sendAcknowledge(trapV1.getIp(), trapV1.getPETAck());
                    }
                    this.trapCollector.put(packet, baseTrap);
                    for (TrapReceiverListener item : this.trapReceiverListeners) {
                        item.action(baseTrap);
                    }
                }
                catch (IOException parser) {
                }
                catch (AsnDecodingException ae) {
                }
                catch (Exception e3) {
                }
            }
            this.socket.close();
        }

        public void stopTR() {
            this.KeepWaiting = false;
        }
    }
}

