/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.trap;

import com.supermicro.ipmi.trap.traps.BaseTrap;
import com.supermicro.ipmi.trap.traps.SNMPv1Trap;
import com.supermicro.ipmi.trap.traps.SNMPv3Trap;
import com.supermicro.ipmi.trap.traps.TrapFactory;
import java.net.DatagramPacket;
import java.util.ArrayList;
import java.util.Observable;
import java.util.SortedMap;
import java.util.TreeMap;

public class TrapCollector
extends Observable {
    ArrayList<SNMPv1Trap> listSNMPv1Traps = new ArrayList();
    ArrayList<SNMPv3Trap> listSNMPv3Traps = new ArrayList();
    SortedMap sender = new TreeMap();
    SortedMap community = new TreeMap();
    SortedMap sensor = new TreeMap();

    public void put(DatagramPacket packet, BaseTrap baseTrap) {
        if (baseTrap.getTrapType() == 0) {
            SNMPv1Trap snmpV1Trap = TrapFactory.getSNMPv1Trap(baseTrap);
            this.listSNMPv1Traps.add(snmpV1Trap);
            this.classification(snmpV1Trap);
            baseTrap.setNum(this.listSNMPv1Traps.size());
        } else if (baseTrap.getTrapType() == 1) {
            SNMPv3Trap snmpV3Trap = TrapFactory.getSNMPv3Trap(baseTrap);
            snmpV3Trap.setTrapSourceIP(packet.getAddress().getHostAddress());
            this.listSNMPv3Traps.add(snmpV3Trap);
            baseTrap.setNum(this.listSNMPv3Traps.size());
        }
        this.setChanged();
        this.notifyObservers(baseTrap);
    }

    public ArrayList<SNMPv1Trap> getSNMPv1Traps() {
        return this.listSNMPv1Traps;
    }

    public ArrayList<SNMPv3Trap> getSNMPv3Traps() {
        return this.listSNMPv3Traps;
    }

    public void setSNMPv3Traps(SNMPv3Trap trap) {
        this.listSNMPv3Traps.add(trap);
    }

    public void classification(SNMPv1Trap trap) {
        this.classifySender(trap);
        this.classifyCommunity(trap);
        this.classifySensor(trap);
    }

    public void classifySender(SNMPv1Trap trap) {
        if (this.sender.get(trap.getIp()) == null) {
            ArrayList<SNMPv1Trap> list = new ArrayList<SNMPv1Trap>();
            list.add(trap);
            this.sender.put(trap.getIp(), list);
        } else {
            ArrayList list = (ArrayList)this.sender.get(trap.getIp());
            list.add(trap);
        }
    }

    public void classifyCommunity(SNMPv1Trap trap) {
        if (this.community.get(trap.getCommunity()) == null) {
            ArrayList<SNMPv1Trap> list = new ArrayList<SNMPv1Trap>();
            list.add(trap);
            this.community.put(trap.getCommunity(), list);
        } else {
            ArrayList list = (ArrayList)this.community.get(trap.getCommunity());
            list.add(trap);
        }
    }

    public void classifySensor(SNMPv1Trap trap) {
        if (this.sensor.get(trap.getSensor()) == null) {
            ArrayList<SNMPv1Trap> list = new ArrayList<SNMPv1Trap>();
            list.add(trap);
            String sensorStr = trap.getSensor();
            if (sensorStr.isEmpty()) {
                sensorStr = "None";
            }
            this.sensor.put(sensorStr, list);
        } else {
            ArrayList list = (ArrayList)this.sensor.get(trap.getSensor());
            list.add(trap);
        }
    }

    public void save(String filename) {
    }

    public void load(String filename) {
    }

    public SortedMap getCommunity() {
        return this.community;
    }

    public SortedMap getSender() {
        return this.sender;
    }

    public SortedMap getSensorType() {
        return this.sensor;
    }

    public int getTrapV1Count() {
        return this.listSNMPv1Traps.size();
    }

    public int getTrapV3Count() {
        return this.listSNMPv3Traps.size();
    }

    public int getTotalTraps() {
        return this.listSNMPv1Traps.size() + this.listSNMPv3Traps.size();
    }

    public void clear() {
        this.listSNMPv1Traps.clear();
        this.listSNMPv3Traps.clear();
        this.sender.clear();
        this.community.clear();
        this.sensor.clear();
    }
}

