/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.trap.privacy;

import com.supermicro.ipmi.trap.privacy.PrivacyGeneric;
import com.supermicro.ipmi.trap.traps.SNMPv3Trap;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PrivDES
extends PrivacyGeneric {
    public static final String CIPHER_PADDING_INSTANCE = "DES/CBC/PKCS5Padding";
    public static final String CIPHER_NO_PADDING_INSTANCE = "DES/CBC/NoPadding";
    public static final String PROTOCOL_CLASS = "DES";
    public static final int KEY_BYTES = 8;
    public static final int INPUT_KEY_LENGTH = 16;

    @Override
    public byte[] decrypt(SNMPv3Trap trap, byte[] decryptionKey) {
        if (trap.getEncryptedPDULength() % 8 != 0 || trap.getEncryptedPDULength() < 8 || trap.getMsgPrivacyParameters().length != 8) {
            return null;
        }
        if (decryptionKey.length < 16) {
            return null;
        }
        byte[] privParam = trap.getMsgPrivacyParameters();
        byte[] iv = new byte[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            iv[i2] = (byte)(decryptionKey[8 + i2] ^ privParam[i2]);
        }
        return this.doDecrypt(trap.getMsgWholeMsg(), trap.getEncryptedPDUOffset(), trap.getEncryptedPDULength(), decryptionKey, iv);
    }

    protected byte[] doDecrypt(byte[] cryptedData, int offset, int length, byte[] decryptionKey, byte[] iv) {
        byte[] decryptedData = null;
        try {
            Cipher alg = this.reuseCipher(CIPHER_PADDING_INSTANCE);
            SecretKeySpec key = new SecretKeySpec(decryptionKey, 0, 8, PROTOCOL_CLASS);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            alg.init(2, (Key)key, ivSpec);
            decryptedData = alg.doFinal(cryptedData, offset, length);
            return decryptedData;
        }
        catch (Exception alg) {
            try {
                Cipher alg2 = this.reuseCipher(CIPHER_NO_PADDING_INSTANCE);
                SecretKeySpec key = new SecretKeySpec(decryptionKey, 0, 8, PROTOCOL_CLASS);
                IvParameterSpec ivSpec = new IvParameterSpec(iv);
                alg2.init(2, (Key)key, ivSpec);
                decryptedData = alg2.doFinal(cryptedData, offset, length);
                return decryptedData;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

