/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.trap.usm;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.algo.AES_CBC_128;
import com.supermicro.ipmi.trap.usm.AuthProtocol;
import com.supermicro.ipmi.trap.usm.PrivProtocol;
import com.supermicro.ipmi.trap.usm.UserTable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;

public class UserTableUtils {
    private static final String PROPERTIES_FILE_HEADER = "#";
    private static final String PROPERTIES_FILE_SLASH = "/";
    private static final String PROPERTIES_FILE_COMMA = ",";
    private static final String PROPERTIES_LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String[] FIELD_NAMES = new String[]{"No.", "Username", "Authetication Model", "Password", "Privacy Protocol", "Privacy Password"};
    public static final String DEFAULT_FILE_NAME = "snmpUserTable.properties";
    public static final String DEFAULT_FILE_PATH = System.getProperty("user.dir") + System.getProperty("file.separator") + "snmpUserTable.properties";
    public static final int USER_MAX_COUNT = 10;
    public static final int KEY_MAX_LENGTH = 16;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<UserTable> readPropertyFile(String filePath) {
        File tempFile;
        ArrayList<UserTable> listUserTable = new ArrayList<UserTable>();
        BufferedReader bufferReader = null;
        if (filePath != null && (tempFile = new File(filePath)).exists()) {
            try {
                String line;
                FileReader fileReader = new FileReader(tempFile);
                bufferReader = new BufferedReader(fileReader);
                while ((line = bufferReader.readLine()) != null) {
                    if (line.startsWith(PROPERTIES_FILE_HEADER)) continue;
                    String[] value = line.split(PROPERTIES_FILE_COMMA);
                    if (value == null || value.length != 6) break;
                    String username = value[1];
                    String authProtocol = value[2];
                    String authPassword = value[3];
                    String privProtocol = value[4];
                    String privPassword = value[5];
                    UserTable usrTable = new UserTable();
                    usrTable.setName(username);
                    usrTable.setAuthProtocol(new AuthProtocol(authProtocol));
                    usrTable.setAuthPassword(UserTableUtils.decryptPassword(authPassword, username, authProtocol));
                    usrTable.setPrivProtocol(new PrivProtocol(privProtocol));
                    usrTable.setPrivPassword(UserTableUtils.decryptPassword(privPassword, username, privProtocol));
                    listUserTable.add(usrTable);
                }
                fileReader.close();
                ArrayList<UserTable> arrayList = listUserTable;
                return arrayList;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            finally {
                try {
                    bufferReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return listUserTable;
    }

    public static void writePropertyFile(TableModel tableModel, String fileName) {
        String content = UserTableUtils.generateFileInput(tableModel);
        UserTableUtils.writeFile(content, fileName);
    }

    public static void writePropertyFile(UserTable userTable, String fileName) {
        List<UserTable> listUserTable = UserTableUtils.readPropertyFile(fileName);
        listUserTable.add(userTable);
        String content = UserTableUtils.generateFileInput(listUserTable);
        UserTableUtils.writeFile(content, fileName);
    }

    public static void writePropertyFile(List<UserTable> listUserTable, String fileName) {
        String content = UserTableUtils.generateFileInput(listUserTable);
        UserTableUtils.writeFile(content, fileName);
    }

    private static void writeFile(String content, String fileName) {
        Path path = Paths.get(fileName, new String[0]);
        byte[] contentBytes = content.getBytes();
        try {
            Files.write(path, contentBytes, new OpenOption[0]);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private static String generateFileInput(TableModel tableModel) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(UserTableUtils.generateFileHeader());
        for (int rowIdx = 0; rowIdx < tableModel.getRowCount(); ++rowIdx) {
            String number = String.valueOf(tableModel.getValueAt(rowIdx, 0));
            String username = String.valueOf(tableModel.getValueAt(rowIdx, 1));
            String authProtocol = String.valueOf(tableModel.getValueAt(rowIdx, 2));
            String authPassword = String.valueOf(tableModel.getValueAt(rowIdx, 3));
            String privProtocol = String.valueOf(tableModel.getValueAt(rowIdx, 4));
            String privPassword = String.valueOf(tableModel.getValueAt(rowIdx, 5));
            UserTableUtils.generetFilePayload(stringBuffer, number, username, authProtocol, authPassword, privProtocol, privPassword);
        }
        return stringBuffer.toString();
    }

    private static String generateFileInput(List<UserTable> listUserTable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(UserTableUtils.generateFileHeader());
        for (int rowIdx = 0; rowIdx < listUserTable.size(); ++rowIdx) {
            UserTable userTable = listUserTable.get(rowIdx);
            UserTableUtils.generetFilePayload(stringBuffer, String.valueOf(rowIdx + 1), userTable.getName(), userTable.getAuthProtocol().getProtocol(), userTable.getAuthPassword(), userTable.getPrivProtocol().getProtocol(), userTable.getPrivPassword());
        }
        return stringBuffer.toString();
    }

    private static String generateFileHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PROPERTIES_FILE_HEADER);
        for (int index = 0; index < FIELD_NAMES.length; ++index) {
            stringBuffer.append(FIELD_NAMES[index]);
            stringBuffer.append(index != FIELD_NAMES.length - 1 ? PROPERTIES_FILE_SLASH : "");
        }
        stringBuffer.append(PROPERTIES_LINE_SEPARATOR);
        return stringBuffer.toString();
    }

    private static String generetFilePayload(StringBuffer stringBuffer, String number, String name, String authMode, String authPwd, String privMode, String privPwd) {
        stringBuffer.append(number);
        stringBuffer.append(PROPERTIES_FILE_COMMA);
        stringBuffer.append(name);
        stringBuffer.append(PROPERTIES_FILE_COMMA);
        stringBuffer.append(authMode);
        stringBuffer.append(PROPERTIES_FILE_COMMA);
        stringBuffer.append(UserTableUtils.encryptPassword(authPwd, name, authMode));
        stringBuffer.append(PROPERTIES_FILE_COMMA);
        stringBuffer.append(privMode);
        stringBuffer.append(PROPERTIES_FILE_COMMA);
        stringBuffer.append(UserTableUtils.encryptPassword(privPwd, name, privMode));
        stringBuffer.append(PROPERTIES_LINE_SEPARATOR);
        return stringBuffer.toString();
    }

    private static String encryptPassword(String plaintext, String username, String protocol) {
        AES_CBC_128 priv = new AES_CBC_128();
        String keyStr = UserTableUtils.getConfuseKey(username, protocol);
        byte[] key = keyStr.getBytes();
        byte[] iv = new StringBuilder(keyStr).reverse().toString().getBytes();
        byte[] input = new byte[plaintext.getBytes().length + (16 - plaintext.getBytes().length % 16)];
        System.arraycopy(plaintext.getBytes(), 0, input, 0, plaintext.getBytes().length);
        byte[] encryptedBytes = priv.encrypt(iv, key, input);
        return ByteUtility.bytesToHexNoSpace(encryptedBytes);
    }

    private static String decryptPassword(String ciphertext, String username, String protocol) {
        AES_CBC_128 priv = new AES_CBC_128();
        String keyStr = UserTableUtils.getConfuseKey(username, protocol);
        byte[] key = keyStr.getBytes();
        byte[] iv = new StringBuilder(keyStr).reverse().toString().getBytes();
        byte[] binArray = ByteUtility.toBinArray(ciphertext);
        byte[] decryptedBytes = priv.decrypt(iv, key, binArray);
        return new String(decryptedBytes).trim();
    }

    private static String getConfuseKey(String key, String seed) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(key);
        do {
            stringBuffer.append(seed);
        } while (stringBuffer.length() < 16);
        return stringBuffer.substring(0, 16);
    }
}

