/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.util;

import java.util.ArrayList;
import java.util.List;

public class MaxThreadsMain {
    public static final int BATCH_SIZE = 4000;

    public static void main(String ... args) throws InterruptedException {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        try {
            for (int i2 = 0; i2 <= 100000; i2 += 4000) {
                long start = System.currentTimeMillis();
                MaxThreadsMain.addThread(threads, 4000);
                long end = System.currentTimeMillis();
                Thread.sleep(1000L);
                long delay = end - start;
                System.out.printf("%,d threads: Time to create %,d threads was %.3f seconds %n", threads.size(), 4000, (double)delay / 1000.0);
            }
        }
        catch (Throwable e2) {
            System.err.printf("After creating %,d threads, ", threads.size());
            e2.printStackTrace();
        }
    }

    private static void addThread(List<Thread> threads, int num) {
        for (int i2 = 0; i2 < num; ++i2) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (!Thread.interrupted()) {
                            Thread.sleep(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            t.setDaemon(true);
            t.setPriority(1);
            threads.add(t);
            t.start();
        }
    }
}

