/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.redfish.AuthUtilsForAndroid;
import java.io.IOException;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;

public class BasicAuthForAndroid
extends AuthUtilsForAndroid {
    private final OkHttpClient client;
    private String username;
    private String password;
    private String responseString;
    private int statusCode;

    public BasicAuthForAndroid(IPMIInterfaceConfig config) {
        this.username = config.getUserName();
        this.password = config.getPassword();
        this.client = new OkHttpClient.Builder().sslSocketFactory(this.createSSLSocketFactory(), (X509TrustManager)this.mTrustManager).hostnameVerifier((HostnameVerifier)new AuthUtilsForAndroid.TrustAllVerifier()).connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS)).authenticator(new Authenticator(){

            public Request authenticate(Route route, Response response) {
                if (BasicAuthForAndroid.this.responseCount(response) >= 3) {
                    return null;
                }
                String credential = Credentials.basic((String)BasicAuthForAndroid.this.username, (String)BasicAuthForAndroid.this.password);
                return response.request().newBuilder().header("Authorization", credential).build();
            }
        }).build();
    }

    private int responseCount(Response response) {
        int result = 1;
        while ((response = response.priorResponse()) != null) {
            ++result;
        }
        return result;
    }

    public int send_https_get(String url) throws Exception {
        Request request = new Request.Builder().url(url).build();
        try {
            Response response = this.client.newCall(request).execute();
            this.responseString = response.body().string();
            this.statusCode = response.code();
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                System.out.println("[ BMC -> YOU : " + this.statusCode + "  " + this.responseString + "]");
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return this.statusCode;
    }

    public int send_https_patch(String url, String bodyString) throws Exception {
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody requestBody = RequestBody.create((String)bodyString, (MediaType)JSON);
        Request request = new Request.Builder().patch(requestBody).url(url).addHeader("Accept", "application/json; */*").build();
        try {
            Response response = this.client.newCall(request).execute();
            this.responseString = response.body().string();
            this.statusCode = response.code();
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                System.out.println("[ BMC -> YOU : " + this.statusCode + "  " + this.responseString + "]");
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return this.statusCode;
    }

    public String getResponseString() {
        return this.responseString;
    }
}

