/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.activation.CSWProductKey;
import com.supermicro.redfish.RedfishHttpUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import javax.net.ssl.SSLParameters;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class RedfishActAPI {
    protected IPMIInterfaceConfig config;

    public RedfishActAPI(IPMIInterfaceConfig config) {
        this.config = config;
    }

    public String send_https_get(String url) throws Exception {
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.loadTrustMaterial(null, new TrustStrategy(){

            @Override
            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        });
        SSLParameters params = builder.build().getSupportedSSLParameters();
        String[] suites = params.getCipherSuites();
        SSLConnectionSocketFactory sslSF = new SSLConnectionSocketFactory(builder.build(), new String[]{"TLSv1", "TLSv1.2"}, suites, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("default").build();
        BasicCookieStore cookieStore = new BasicCookieStore();
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.cookie-store", cookieStore);
        String encoding = Base64.getEncoder().encodeToString((String.valueOf(this.config.getUserName()) + ":" + this.config.getPassword()).getBytes());
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(globalConfig).setDefaultCookieStore(cookieStore).setSSLSocketFactory(sslSF).build();
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader("Authorization", "Basic " + encoding);
        try (CloseableHttpResponse response2 = httpClient.execute(httpGet);){
            String response2String;
            int statusCode = response2.getStatusLine().getStatusCode();
            HttpEntity entity2 = response2.getEntity();
            String string = response2String = EntityUtils.toString(entity2);
            return string;
        }
    }

    public int send_https_post(String url, String bodyString) throws Exception {
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.loadTrustMaterial(null, new TrustStrategy(){

            @Override
            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        });
        SSLParameters params = builder.build().getSupportedSSLParameters();
        String[] suites = params.getCipherSuites();
        SSLConnectionSocketFactory sslSF = new SSLConnectionSocketFactory(builder.build(), new String[]{"TLSv1", "TLSv1.2"}, suites, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("default").build();
        BasicCookieStore cookieStore = new BasicCookieStore();
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.cookie-store", cookieStore);
        String encoding = Base64.getEncoder().encodeToString((String.valueOf(this.config.getUserName()) + ":" + this.config.getPassword()).getBytes());
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(globalConfig).setDefaultCookieStore(cookieStore).setSSLSocketFactory(sslSF).build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Authorization", "Basic " + encoding);
        StringEntity body = new StringEntity(bodyString);
        httpPost.setHeader("Content-type", "application/json");
        httpPost.setEntity(body);
        int statusCode = 99;
        try (CloseableHttpResponse response = httpClient.execute(httpPost);){
            statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity2 = response.getEntity();
            String string = EntityUtils.toString(entity2);
        }
        return statusCode;
    }

    public ArrayList<CSWProductKey> getProductKeyList() throws Exception {
        String input = this.sendQueryLicense();
        if (input.indexOf("odata.etag") != -1) {
            int index = input.indexOf("]", input.indexOf("Licenses"));
            input = input.substring(0, index + 1);
            input = String.valueOf(input) + "}";
        }
        input = this.refactorToJson(input);
        ArrayList<CSWProductKey> list = new ArrayList<CSWProductKey>();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        try {
            JsonNode rootArray = mapper.readTree(input);
            JsonNode description = rootArray.path("Name");
            JsonNode licenses = rootArray.path("Licenses");
            if (licenses.isArray()) {
                for (JsonNode l : licenses) {
                    CSWProductKey ck = new CSWProductKey();
                    JsonNode product = l.path("ProductKey");
                    JsonNode node = product.path("Node");
                    JsonNode name = node.path("LicenseName");
                    JsonNode licenseID = node.path("LicenseID");
                    JsonNode creationDate = node.path("CreateDate");
                    JsonNode signature = product.path("Signature");
                    JsonNode expireDate = node.path("ExpirationDate");
                    ck.setSwName(name.asText());
                    ck.setCreateDate(creationDate.asText());
                    ck.setLicenseID(licenseID.asInt());
                    ck.setSignature(signature.asText());
                    ck.setExpireDate(expireDate.asText());
                    list.add(ck);
                }
            }
            if (list.size() > 0) {
                return list;
            }
            return null;
        }
        catch (Exception e2) {
            throw new Exception(e2.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkIfLicenseSupported() {
        try {
            ArrayList<CSWProductKey> list = this.getProductKeyList();
            int i2 = 0;
            while (true) {
                if (i2 >= list.size()) {
                    return false;
                }
                CSWProductKey ck = list.get(i2);
                if (ck.getSwName().contains("SFT-OOB-LIC")) return true;
                if (ck.getSwName().contains("SFT-DCMS-SINGLE")) {
                    return true;
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            return false;
        }
    }

    public String sendQueryLicense() throws Exception {
        return this.send_https_get("https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/Managers/1/LicenseManager/QueryLicense");
    }

    public int ClearLicense(String fileName) throws Exception {
        String body = this.createBody(fileName);
        if (body == null || body.length() == 0) {
            System.out.println("Input file error");
            return 0;
        }
        return this.send_https_post("https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/Managers/1/LicenseManager/ClearLicense", body);
    }

    public int ClearLicense(int licenseID) throws Exception {
        String body = "{\"LicenseID\":\"" + licenseID + "\"}";
        return this.send_https_post("https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/Managers/1/LicenseManager/ClearLicense", body);
    }

    public int ActivateLicensebyFile(String fileName) throws Exception {
        String body = this.createBody(fileName);
        if (body == null || body.length() == 0) {
            System.out.println("Input file error");
            return 0;
        }
        if (body.indexOf("{") != 0) {
            body = body.substring(body.indexOf("{"));
        }
        return this.send_https_post("https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/Managers/1/LicenseManager/ActivateLicense", body);
    }

    public int ActivateLicense(String body) throws Exception {
        if (body.indexOf("{") != 0) {
            body = body.substring(body.indexOf("{"));
        }
        return this.send_https_post("https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/Managers/1/LicenseManager/ActivateLicense", body);
    }

    public int clearOOBLicense() throws Exception {
        String body = "{\"LicenseID\":\"1\"}";
        return this.send_https_post("https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/Managers/1/LicenseManager/ClearLicense", body);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkIfDCMSSingleExist() {
        try {
            ArrayList<CSWProductKey> list = this.getProductKeyList();
            int i2 = 0;
            while (true) {
                if (i2 >= list.size()) {
                    return false;
                }
                CSWProductKey ck = list.get(i2);
                if (ck.getSwName().contains("SFT-DCMS-SINGLE")) {
                    return true;
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            return false;
        }
    }

    public String createBody(String fileName) {
        String line = null;
        StringBuilder contentBuilder = new StringBuilder();
        try {
            FileReader fileReader = new FileReader(fileName);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                contentBuilder.append(line).append("\n");
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
        return contentBuilder.toString();
    }

    public String refactorToJson(String input) {
        input = input.replaceAll("\\\\\"", "\"");
        input = input.replaceAll("\\\\[n]", "").trim();
        input = input.replaceAll("\"[{]", "{");
        input = input.replaceAll("[}]\"", "}");
        return input;
    }

    public static void main(String[] args) {
        try {
            IPMIInterfaceConfig config = new IPMIInterfaceConfig();
            config.setIp("10.146.172.78");
            config.setUserName("ADMIN");
            config.setPassword("ADMIN");
            RedfishActAPI api = new RedfishActAPI(config);
            String input = api.sendQueryLicense();
            ArrayList<CSWProductKey> list = api.getProductKeyList();
            int i2 = 0;
            while (i2 < list.size()) {
                CSWProductKey ck = list.get(i2);
                System.out.println(ck.getLicenseID());
                System.out.println(ck.getSwName());
                System.out.println(ck.getSignature());
                ++i2;
            }
            System.out.println(api.checkIfDCMSSingleExist());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

