/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishHttpUtils;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.util.Iterator;
import org.apache.http.Header;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;

public class RedfishFlash
implements IPMIDCMOEMCommand.Progress {
    IPMIDCMOEMCommand.Progress progress;
    MOut mout = MOut.G();
    int valueBak = 0;

    public boolean flash(IPMIInterfaceConfig config, String filename, String bodyString) {
        String firmwareVersion;
        String pw;
        String id;
        String ip;
        RedfishFlash redfishFlash;
        long start;
        block64: {
            start = System.currentTimeMillis();
            redfishFlash = new RedfishFlash();
            redfishFlash.progress = redfishFlash;
            redfishFlash.setMOut(this.mout);
            ip = config.getIp();
            id = config.getUserName();
            pw = config.getPassword();
            byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(ip);
            this.mout.print("Check firmware file...");
            firmwareVersion = null;
            try {
                if (IPMIMessagingCommand.isX12GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX12RoTGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12RoT(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX12RoTHW1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12RoTHW1(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX12RoTHW2GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12RoTHW2(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isH12RoTGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH12RoT(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isH13ROTMAC12GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH13RoTMAC12(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isH13ROTMAC34GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH13RoTMAC34(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isAST2600GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionAST2600(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isAST2600HW1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionAST2600HW1(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isAST2600NonRoTGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionAST2600NonRoT(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isB12RoTHW1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionB12RoTHW1(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isB12AST2600GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionB12AST2600RoTHW1(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isB13AST2600RoTGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionB13ROT(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isB14AST2600RoT20GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionB14ROT(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isB3SD1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionB3AST2600(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isB3ST1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionB3AST2500(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isB4SA1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionB4AST2600(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX12DGOGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12DGO(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isH12SSFFGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH12SSFF(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isH12SSFRGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH12SSFR(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isH12SSGGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH12SSG(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isAST2600HW1ROT20GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionAST2600HW1ROT20(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isB12AST2600MAC1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionB12AST2600MAC1(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isM12GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionM12(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isH13GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH13(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX12AST2600NonRoT(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12SDV(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX12AST2600NonRoTHW1(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12STW(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX12DSCGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12DSC(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX12DGQGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12DGQ(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isH12DSGGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH12DSG(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isHGIMEZZGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionHGIMEZZ(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX13ROTGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX13ROT(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX13ROTMAC1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX13ROTMAC1(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX13ROTHW1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX13ROTHW1(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX13ROT8WAYSGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX13ROT8WAYS(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX12SPTGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12SPT(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX12DGUGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12DGU(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isMicroBladeCMMAST2600GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionMicroBladeCMMAST2600(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX13DeltaNextGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX13DeltaNext(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isH13DeltaNextGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH13DeltaNext(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isH13DeltaNextHW1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH13DeltaNextHW1(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isH13AST2600HW1Rot20GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH13AST2600HW1Rot20(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isH13AST2600NonRoTGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH13AST2600NonROT(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isH13OpenBMCHW2GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH13OpenBMCHW2(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isH14AST2600ROT20HW2GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH14AST2600ROT20HW2(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX13AST2600NonRoTGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX13AST2600NonRoT(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX13AST2600NonRoTHW1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX13AST2600NonRoTHW1(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX13AST2600ROT20LegoGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX13AST2600ROT20Lego(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX13AST2600RoTSBBGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX13AST2600ROT20SBB(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX13OpenBMCHW2GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX13OpenBmcHW2(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isG1AST2600ROT20LegoGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionG1AST2600ROT20Lego(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isJBOF2600GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionJBOFAST2600(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX14AST2600ROT20HW1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX14AST2600ROT20(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX14AST2600RoT20HW2GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX14AST2600ROT20HW2(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX14AST2600RoT20GD3GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX14AST2600ROT20GD3(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX14AST2600RoT20DCMHSGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX14AST2600ROT20DCMHS(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isX14AST2600RoT20MAC1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX14AST2600ROT20MAC1(filename);
                    break block64;
                }
                if (IPMIMessagingCommand.isAOMSCMOpenBMCLegoGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionAOMSCMOpenBMCLego(filename);
                    break block64;
                }
                this.mout.println("Target BMC type error");
                return false;
            }
            catch (Exception ex) {
                this.mout.println(ex.getMessage());
                return false;
            }
        }
        this.mout.println(" Done (ver:" + firmwareVersion + ")");
        this.mout.print("Check BMC status...");
        String bmcVersion = null;
        try {
            bmcVersion = redfishFlash.getCurrentFWVersion(ip, id, pw);
        }
        catch (Exception ex) {
            this.mout.println(ex.getMessage());
            return false;
        }
        this.mout.print(" Done (ver:" + bmcVersion + ")");
        try {
            redfishFlash.flashWorker(config, filename, bodyString, true);
        }
        catch (Exception ex1) {
            this.mout.println(ex1.getMessage());
            return false;
        }
        this.printTimeString("\nTotal Elapsed Time", System.currentTimeMillis() - start);
        return true;
    }

    public boolean flashBIOSLegacy(IPMIInterfaceConfig config, String filename, String bodyString) {
        long start = System.currentTimeMillis();
        RedfishFlash redfishFlash = new RedfishFlash();
        redfishFlash.progress = redfishFlash;
        redfishFlash.setMOut(this.mout);
        try {
            redfishFlash.flashLegacyWorker(config, filename, bodyString);
        }
        catch (Exception ex1) {
            this.mout.println(ex1.getMessage());
            return false;
        }
        this.printTimeString("\nUpdate Time", System.currentTimeMillis() - start);
        return true;
    }

    public boolean flashBIOS(IPMIInterfaceConfig config, String filename, String bodyString) {
        long start = System.currentTimeMillis();
        RedfishFlash redfishFlash = new RedfishFlash();
        redfishFlash.progress = redfishFlash;
        redfishFlash.setMOut(this.mout);
        try {
            redfishFlash.flashWorker(config, filename, bodyString, false);
        }
        catch (Exception ex1) {
            this.mout.println(ex1.getMessage());
            return false;
        }
        this.printTimeString("\nUpdate Time", System.currentTimeMillis() - start);
        return true;
    }

    public boolean flashCPLD(IPMIInterfaceConfig config, String filename, String bodyString) {
        long start = System.currentTimeMillis();
        RedfishFlash redfishFlash = new RedfishFlash();
        redfishFlash.progress = redfishFlash;
        redfishFlash.setMOut(this.mout);
        try {
            redfishFlash.flashCPLDWorker(config, filename, bodyString);
        }
        catch (Exception ex1) {
            this.mout.println(ex1.getMessage());
            return false;
        }
        this.printTimeString("\nUpdate Time", System.currentTimeMillis() - start);
        return true;
    }

    public void flashWorker(IPMIInterfaceConfig config, String filename, String bodyString, boolean isBMCUpdate) throws Exception {
        this.resetValue();
        this.progress.message("Uploading file ");
        String ip = RedfishHttpUtils.getUrlIP(config.getIp());
        String url = "https://" + ip + "/redfish/v1/UpdateService/" + "upload";
        BasicAuthClient bc = new BasicAuthClient(config);
        int returncode = bc.post_https_Update_multipart(url, filename, bodyString, this.progress);
        if (returncode >= 200 && returncode <= 210) {
            this.printPercentage();
            this.resetValue();
            this.progress.message("Updating       ");
            for (Header header : bc.getResponseHeader()) {
                if (!header.getName().trim().equalsIgnoreCase("Location")) continue;
                url = "https://" + ip + header.getValue().trim();
                break;
            }
            bc.send_https_get(url);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(bc.getResponseString());
            JsonNode task = node.path("Task");
            url = "https://" + ip + task.asText();
            int i2 = 0;
            boolean missPercentCount = false;
            int progressRetry = 0;
            while (i2 != 100) {
                try {
                    bc.send_https_get(url);
                    node = mapper.readTree(bc.getResponseString());
                    JsonNode percent = node.path("PercentComplete");
                    JsonNode taskState = node.path("TaskState");
                    if (taskState.asText().equalsIgnoreCase("Exception")) {
                        JsonNode messageArray = node.path("Messages");
                        JsonNode message = messageArray.findValue("Message");
                        JsonNode resolution = messageArray.findValue("Resolution");
                        this.progress.message(message.asText() + " " + resolution.asText() + "\n");
                        throw new Exception("Update failed");
                    }
                    i2 = percent.asInt();
                    this.progress.setValue(i2);
                    Thread.sleep(1000L);
                    progressRetry = 0;
                }
                catch (Exception e2) {
                    if (i2 != 0) {
                        if (progressRetry == 5) {
                            this.progress.setValue(100);
                            break;
                        }
                        ++progressRetry;
                        continue;
                    }
                    throw e2;
                }
            }
            this.printPercentage();
            if (isBMCUpdate) {
                int retry = 250;
                if (i2 == 100) {
                    this.progress.message("Resetting BMC");
                } else {
                    this.progress.message("Wait for BMC reset[" + i2 + "] ...");
                    try {
                        Thread.sleep((100 - i2) * 3 * 1000);
                    }
                    catch (InterruptedException taskState) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException taskState) {
                    // empty catch block
                }
                while (retry > 0) {
                    InetAddress address = InetAddress.getByName(config.getIp());
                    boolean result = address.isReachable(3000);
                    if (result) {
                        try {
                            Thread.sleep(25000L);
                            if (address.isReachable(3000)) break;
                            result = false;
                        }
                        catch (Exception ex) {
                            result = false;
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    --retry;
                }
                if (retry == 0) {
                    this.progress.message("BMC IP is unavailable currently. Please check after 2 minutes later");
                    this.progress.message("RoT devices will perform system backup, may need up to 8 minutes to recover.");
                } else {
                    this.progress.message("Done");
                }
            } else {
                this.checkTaskState(bc, url);
                this.progress.message("Done");
            }
        } else if (returncode >= 400 && returncode < 500) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(bc.getResponseString());
            JsonNode error = node.path("error");
            JsonNode extendInfo = error.path("@Message.ExtendedInfo");
            if (extendInfo.isArray()) {
                for (JsonNode l : extendInfo) {
                    Iterator<JsonNode> iterator;
                    JsonNode messageArgs = l.path("MessageArgs");
                    if (!messageArgs.isArray() || !(iterator = messageArgs.iterator()).hasNext()) continue;
                    JsonNode m = iterator.next();
                    throw new Exception("Error: " + m.asText());
                }
            }
        } else {
            if (returncode == 500) {
                throw new Exception("Error: 500 Internal Server Error. \nBMC is busy, please try again later");
            }
            throw new Exception("...Failed upload file, completion code " + returncode);
        }
    }

    public boolean flashLegacyWorker(IPMIInterfaceConfig config, String filename, String bodyString) throws Exception {
        this.resetValue();
        String ip = RedfishHttpUtils.getUrlIP(config.getIp());
        String middleUrl = "/redfish/v1/UpdateService/SmcFirmwareInventory/BIOS/Actions/SmcFirmwareInventory.";
        String updateModeUrl = "https://" + ip + "/redfish/v1/UpdateService/SmcFirmwareInventory/BIOS/Actions/SmcFirmwareInventory." + "EnterUpdateMode";
        String uploadBiosUrl = "https://" + ip + "/redfish/v1/UpdateService/SmcFirmwareInventory/BIOS/Actions/SmcFirmwareInventory." + "Upload";
        String updateBiosUrl = "https://" + ip + "/redfish/v1/UpdateService/SmcFirmwareInventory/BIOS/Actions/SmcFirmwareInventory." + "Update";
        BasicAuthClient authClient = new BasicAuthClient(config);
        ObjectMapper mapper = new ObjectMapper();
        this.progress.message("Enter update mode");
        int httpCode = authClient.send_https_post(updateModeUrl, "");
        if (httpCode < 200 || 210 < httpCode) {
            this.progress.message("...failed");
            return false;
        }
        this.progress.message("Uploading file ");
        httpCode = authClient.post_https_Update_multipart(uploadBiosUrl, filename, "", this.progress);
        if (httpCode < 200 || 210 < httpCode) {
            this.progress.message("...failed");
            return false;
        }
        this.printPercentage();
        this.progress.message("Updating       ");
        httpCode = authClient.send_https_post(updateBiosUrl, bodyString, "multipart/form-data");
        if (httpCode < 200 || 210 < httpCode) {
            this.progress.message("...failed");
            return false;
        }
        this.resetValue();
        JsonNode node = mapper.readTree(authClient.getResponseString());
        JsonNode acceptNode = node.path("Accepted");
        JsonNode entendedNode = acceptNode.path("@Message.ExtendedInfo");
        String updateTaskUrl = "https://" + ip;
        if (entendedNode.isArray()) {
            for (JsonNode l : entendedNode) {
                JsonNode messageArgs = l.path("MessageArgs");
                if (!messageArgs.isArray()) continue;
                for (JsonNode m : messageArgs) {
                    updateTaskUrl = updateTaskUrl + m.asText();
                }
            }
        }
        int percentValue = 0;
        int progressRetry = 0;
        boolean isTaskCompleted = false;
        while (percentValue != 100) {
            try {
                authClient.send_https_get(updateTaskUrl);
                node = mapper.readTree(authClient.getResponseString());
                JsonNode percent = node.path("PercentComplete");
                JsonNode taskState = node.path("TaskState");
                if (taskState.asText().equalsIgnoreCase("Exception")) {
                    JsonNode messageArray = node.path("Messages");
                    JsonNode message = messageArray.findValue("Message");
                    this.progress.message(message.asText() + "\n");
                    throw new Exception("Update failed");
                }
                isTaskCompleted = taskState.asText().equalsIgnoreCase("Completed");
                percentValue = percent.asInt();
                this.progress.setValue(percentValue);
                Thread.sleep(1000L);
                progressRetry = 0;
            }
            catch (Exception e2) {
                if (percentValue != 0) {
                    if (progressRetry == 5) {
                        this.progress.setValue(100);
                        break;
                    }
                    ++progressRetry;
                    continue;
                }
                throw e2;
            }
        }
        this.printPercentage();
        if (isTaskCompleted) {
            this.progress.message("Done");
            return true;
        }
        this.progress.message("Failed");
        return false;
    }

    public void flashCPLDWorker(IPMIInterfaceConfig config, String filename, String bodyString) throws Exception {
        this.resetValue();
        this.progress.message("Uploading file ");
        String ip = RedfishHttpUtils.getUrlIP(config.getIp());
        String url = "https://" + ip + "/redfish/v1/UpdateService/" + "upload";
        BasicAuthClient bc = new BasicAuthClient(config);
        int returncode = bc.post_https_Update_multipart(url, filename, bodyString, this.progress);
        if (returncode >= 200 && returncode <= 210) {
            this.printPercentage();
            this.resetValue();
            this.progress.message("Updating       ");
            for (Header header : bc.getResponseHeader()) {
                if (!header.getName().trim().equalsIgnoreCase("Location")) continue;
                url = "https://" + ip + header.getValue().trim();
                break;
            }
            bc.send_https_get(url);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(bc.getResponseString());
            JsonNode task = node.path("Task");
            url = "https://" + ip + task.asText();
            int i2 = 0;
            int progressRetry = 0;
            int taskReturnCode = 0;
            while (i2 != 100) {
                try {
                    taskReturnCode = bc.send_https_get(url, 30);
                    if (taskReturnCode >= 200 && taskReturnCode <= 210) {
                        node = mapper.readTree(bc.getResponseString());
                        JsonNode percent = node.path("PercentComplete");
                        JsonNode taskState = node.path("TaskState");
                        if (taskState.asText().equalsIgnoreCase("Exception")) {
                            JsonNode messageArray = node.path("Messages");
                            JsonNode message = messageArray.findValue("Message");
                            JsonNode resolution = messageArray.findValue("Resolution");
                            this.progress.message(message.asText() + " " + resolution.asText() + "\n");
                            throw new Exception("Update failed");
                        }
                        i2 = percent.asInt();
                        this.progress.setValue(i2);
                        Thread.sleep(1000L);
                        progressRetry = 0;
                        continue;
                    }
                    this.progress.setValue(100);
                    break;
                }
                catch (HttpHostConnectException connectionException) {
                    this.progress.setValue(100);
                    break;
                }
                catch (ConnectTimeoutException timeoutException) {
                    if (progressRetry == 3) {
                        this.progress.setValue(100);
                        break;
                    }
                    ++progressRetry;
                }
                catch (Exception e2) {
                    if (i2 != 0) {
                        if (progressRetry == 3) {
                            this.progress.setValue(100);
                            break;
                        }
                        ++progressRetry;
                        continue;
                    }
                    throw e2;
                }
            }
            this.printPercentage();
            int retry = 20;
            this.progress.message("Resetting BMC");
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException taskState) {
                // empty catch block
            }
            while (retry > 0) {
                InetAddress address = InetAddress.getByName(config.getIp());
                boolean result = address.isReachable(3000);
                if (result) {
                    try {
                        Thread.sleep(15000L);
                        if (address.isReachable(3000)) break;
                        result = false;
                    }
                    catch (Exception ex) {
                        result = false;
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --retry;
            }
            if (retry == 0) {
                this.progress.message("BMC IP is unavailable currently. Please check after 2 minutes later");
                this.progress.message("RoT devices will perform system backup, may need up to 8 minutes to recover.");
            } else {
                this.progress.message("Done");
            }
        } else if (returncode >= 400 && returncode < 500) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(bc.getResponseString());
            JsonNode error = node.path("error");
            JsonNode extendInfo = error.path("@Message.ExtendedInfo");
            if (extendInfo.isArray()) {
                for (JsonNode l : extendInfo) {
                    Iterator<JsonNode> iterator;
                    JsonNode messageArgs = l.path("MessageArgs");
                    if (!messageArgs.isArray() || !(iterator = messageArgs.iterator()).hasNext()) continue;
                    JsonNode m = iterator.next();
                    throw new Exception("Error: " + m.asText());
                }
            }
        } else {
            if (returncode == 500) {
                throw new Exception("Error: 500 Internal Server Error. \nBMC is busy, please try again later");
            }
            throw new Exception("...Failed upload file, completion code " + returncode);
        }
    }

    public String checkFirmwareVersionX12RoT(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -15 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12RoTHW1(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 2 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 RoT HW1 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12RoTHW2(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -77 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 RoT HW2 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 50 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH12RoT(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && (byte32[30] & 0xFF) == 34 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H12RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionM12(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && (byte32[30] & 0xFF) == 178 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (M12 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH13(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && (byte32[30] & 0xFF) == 244 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H13 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionAST2600(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 82 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 AST2600RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionAST2600HW1(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 98 && byte32[31] == 2) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 AST2600RoT HW1 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionAST2600NonRoT(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -108 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (AST2600NonRoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionB12RoTHW1(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 18 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (B12 RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionB12AST2600RoTHW1(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 114 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (B12 AST2600RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12DGO(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -46 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 DGO BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12SDV(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -14 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 SDV BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH12SSFF(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -110 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H12SSFF BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH12SSFR(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -30 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H12SSFR BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionAST2600HW1ROT20(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -62 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (SMT_X12IPMI2600 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionB12AST2600MAC1(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 3 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (B12AST2600 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12STW(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 99 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 STW BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12DSC(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -125 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 DSC BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH12SSG(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -109 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H12 SSG BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionB3AST2500(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -93 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (B3 AST2500 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionB3AST2600(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 35 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (B3 AST2600 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionB4AST2600(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -44 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (B4SA1 AST2600 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12DGQ(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 19 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 DGQ BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH12DSG(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 67 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H12 DSG BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionHGIMEZZ(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 83 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H12 DSG BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX13ROT(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -61 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X13 AST2600RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX13ROTHW1(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -45 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X13 AST2600RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX13ROT8WAYS(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 36 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X13 AST2600RoT 8-Ways BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12SPT(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 84 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 SPT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionB13ROT(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 68 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (B13 AST2600ROT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH13RoTMAC34(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 4 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H13 ROT2.0 MAC3/4 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH13RoTMAC12(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 20 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H13 ROT2.0 MAC1/2 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX13ROTMAC1(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 52 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X13 AST2600RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12DGU(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -92 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 AST2600RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionMicroBladeCMMAST2600(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -76 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 AST2600RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH13AST2600HW1Rot20(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -28 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X13 AST2600RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX13DeltaNext(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 85 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X13 AST2600RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH13DeltaNext(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 101 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H13 AST2600 Delta Next BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH13DeltaNextHW1(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -123 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H13 AST2600 Delta Next BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX13AST2600NonRoT(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 5 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X13 AST2600NonRoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX13AST2600NonRoTHW1(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 21 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X13 AST2600NonRoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX13AST2600ROT20Lego(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 37 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X13 AST2600RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionG1AST2600ROT20Lego(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 53 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (G1 AST2600RoT20 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionJBOFAST2600(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -60 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (JBOF AST2600RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX14AST2600ROT20(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 69 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X14 AST2600RoT20 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH14AST2600ROT20HW2(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -107 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H14 AST2600RoT20 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH13AST2600NonROT(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -91 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H13 AST2600 NonRoT20 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH13OpenBMCHW2(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            for (int i2 = 0; i2 < (int)(firmware.length() / (long)block) - 1; ++i2) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] != 83 || byte32[1] != 77 || byte32[2] != 67 || byte32[3] != 73 || byte32[4] != 115 || byte32[5] != 95 || byte32[6] != 70 || byte32[7] != 87 || byte32[30] != -59 || byte32[31] != 1) continue;
                version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                break;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H13 OpenBmc HW2 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX14AST2600ROT20HW2(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -43 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X14 AST2600RoT20 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX13AST2600ROT20SBB(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -27 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X13 AST2600RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX13OpenBmcHW2(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -75 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X13 OpenBmc HW2 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX14AST2600ROT20GD3(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 22 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X14 AST2600RoT20 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionB14ROT(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 38 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (B14 AST2600ROT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX14AST2600ROT20DCMHS(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 70 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X14 AST2600RoT20 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX14AST2600ROT20MAC1(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 118 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X14 AST2600RoT20 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionAOMSCMOpenBMCLego(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 6 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (AOM-SCM-NV OpenBmc BMC *.bin required)");
        }
        return version;
    }

    @Override
    public void setValue(int value) {
        if (value > this.valueBak) {
            for (int i2 = 0; i2 < value - this.valueBak; ++i2) {
                if ((i2 + value) % 2 != 0) continue;
                this.mout.print(">");
            }
            this.valueBak = value;
        }
    }

    public void resetValue() {
        this.valueBak = 0;
    }

    public void printPercentage() {
        if (this.valueBak == 100) {
            this.mout.print(" 100%");
        }
    }

    public String getCurrentFWVersion(String ip, String username, String password) throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(username);
        config.setPassword(password);
        config.setPrivilege((byte)4);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiGlobalCommand);
        if (sessionController == null) {
            throw new Exception("Connect failed");
        }
        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
        sessionController.closeSession();
        if (deviceInfo.usingAuxiliaryFWVesion) {
            return "" + deviceInfo.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2) + "." + ByteUtility.byteToHex(deviceInfo.auxiliaryFirmwareRevisionInfo[0]);
        }
        return "" + deviceInfo.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2);
    }

    public void printTimeString(String label, long diffMillis) {
        if (diffMillis == 0L) {
            return;
        }
        long diffDays = diffMillis / 86400000L;
        long leftHours = diffMillis % 86400000L / 3600000L;
        long leftMins = diffMillis % 86400000L % 3600000L / 60000L;
        long leftSecs = diffMillis % 86400000L % 3600000L % 60000L / 1000L;
        this.mout.println(label + ": " + leftMins + " min " + leftSecs + " sec(s)");
    }

    @Override
    public void message(String message) {
        this.mout.print("\n" + message);
    }

    @Override
    public void left(long value) {
    }

    public IPMIDCMOEMCommand.Progress getProgress() {
        return this.progress;
    }

    public void setProgress(IPMIDCMOEMCommand.Progress progress) {
        this.progress = progress;
    }

    public void setMOut(MOut mout) {
        this.mout = mout;
    }

    private void checkTaskState(BasicAuthClient client, String url) {
        long delayMaximum = 5000L;
        long currentTime = 0L;
        long beginTime = System.currentTimeMillis();
        ObjectMapper mapper = new ObjectMapper();
        do {
            try {
                client.send_https_get(url);
                JsonNode node = mapper.readTree(client.getResponseString());
                JsonNode taskState = node.path("TaskState");
                if (!taskState.asText().equalsIgnoreCase("Completed")) {
                    Thread.sleep(1000L);
                    continue;
                }
                currentTime = System.currentTimeMillis();
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while ((currentTime = System.currentTimeMillis()) - beginTime < 5000L);
    }

    public static void main(String[] args) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String s = "{\r\n    \"Accepted\": {\r\n        \"code\": \"Base.v1_4_0.Accepted\",\r\n        \"Message\": \"Successfully Accepted Request. Please see the location header and ExtendedInfo for more information.\",\r\n        \"@Message.ExtendedInfo\": [\r\n            {\r\n                \"MessageId\": \"SMC.v1.0.OemSimpleupdateAcceptedMessage\",\r\n                \"Severity\": \"Ok\",\r\n                \"Resolution\": \"No resolution was required.\",\r\n                \"Message\": \"Please also check Task Resource /redfish/v1/TaskService/Tasks/1 to see more information.\",\r\n                \"MessageArgs\": [\r\n                    \"/redfish/v1/TaskService/Tasks/1\"\r\n                ],\r\n                \"RelatedProperties\": [\r\n                    \"BmcUpdateAccepted\"\r\n                ]\r\n            }\r\n        ]\r\n    }\r\n}";
        JsonNode node = mapper.readTree(s);
        JsonNode accept = node.path("Accepted");
        JsonNode extendInfo = accept.path("@Message.ExtendedInfo");
        if (extendInfo.isArray()) {
            for (JsonNode l : extendInfo) {
                JsonNode messageArgs = l.path("MessageArgs");
                if (!messageArgs.isArray()) continue;
                for (JsonNode m : messageArgs) {
                    System.out.println(m.asText());
                }
            }
        }
    }
}

