/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.SystemLockdownCommand;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.SessionLoginClient;

public abstract class RedfishTokenCommand
extends Command {
    protected SessionLoginClient sessionLoginClient;
    protected ISessionController sessionController = null;

    public boolean preValidate() {
        return true;
    }

    public abstract void runCommand() throws Exception;

    @Override
    public void execute() throws Exception {
        if (!this.preValidate()) {
            this.statusCode = 147;
            return;
        }
        this.sessionLoginClient = new SessionLoginClient(this.config);
        try {
            this.runCommand();
        }
        catch (Exception e2) {
            MOut.G(this).println("Cannot connect to " + RedfishHttpUtils.getUrlIP(this.config.getIp()));
            this.statusCode = 145;
        }
        finally {
            this.sessionLoginClient.closeSession();
        }
    }

    public boolean checkIfSystemLockdown() {
        SystemLockdownCommand systemLockdownCommand = new SystemLockdownCommand(null);
        try {
            this.sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilegeEx(this.config, systemLockdownCommand);
        }
        catch (IPMIException ex) {
            return false;
        }
        if (systemLockdownCommand.isSystemLocked()) {
            MOut.G(this).println("System is in lock down mode. This action is forbidden.");
            this.sessionController.closeSession();
            this.statusCode = 156;
            return true;
        }
        this.sessionController.closeSession();
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void printFailMessage(int result, String responseString) {
        if (result >= 400 && result < 500) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                JsonNode node = mapper.readTree(responseString);
                JsonNode error = node.path("error");
                JsonNode extendInfo = error.path("@Message.ExtendedInfo");
                if (!extendInfo.isArray()) return;
                for (JsonNode l : extendInfo) {
                    JsonNode messageArgs = l.path("MessageArgs");
                    JsonNode message = l.findPath("Message");
                    MOut.G(this).println("Error: " + message.asText());
                    if (!messageArgs.isArray()) continue;
                    for (JsonNode m : messageArgs) {
                        MOut.G(this).println("Error Argument: " + m.asText());
                    }
                }
                return;
            }
            catch (Exception e2) {
                MOut.G(this).println("...Failed upload file, completion code " + result);
                return;
            }
        } else {
            MOut.G(this).println("...Failed upload file, completion code " + result);
        }
    }
}

