/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import com.supermicro.redfish.AuthClient;
import com.supermicro.redfish.RedfishHttpUtils;
import java.io.File;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class SessionLoginClient
extends AuthClient {
    private String token;
    private int sessionID = -1;
    private String responseString;
    private String currentURL;
    private int statusCode;

    public SessionLoginClient(IPMIInterfaceConfig config) {
        this.config = config;
        try {
            if (!this.getToken()) {
                System.out.println("Get token failed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send_https_get(String url) throws Exception {
        CloseableHttpClient httpClient = this.prepareHttpClient();
        this.resetURL(url);
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader("x-auth-token", this.token);
        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
            System.out.println("[ YOU -> BMC : Sending http get " + httpGet.getURI() + "]");
        }
        CloseableHttpResponse response2 = httpClient.execute(httpGet);
        try {
            this.statusCode = response2.getStatusLine().getStatusCode();
            HttpEntity entity2 = response2.getEntity();
            this.responseString = EntityUtils.toString(entity2);
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                System.out.println("[ BMC -> YOU : " + this.statusCode + "  " + this.responseString + "]");
            }
            int n = this.statusCode;
            return n;
        }
        finally {
            response2.close();
            httpClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send_https_post(String url, String bodyString) throws Exception {
        CloseableHttpClient httpClient = this.prepareHttpClient();
        this.resetURL(url);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("x-auth-token", this.token);
        if (bodyString.length() != 0) {
            StringEntity body = new StringEntity(bodyString);
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setEntity(body);
        }
        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
            System.out.println("[ YOU -> BMC : Sending http post " + httpPost.getURI() + "]");
        }
        CloseableHttpResponse response = httpClient.execute(httpPost);
        try {
            this.statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity2 = response.getEntity();
            this.responseString = EntityUtils.toString(entity2);
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                System.out.println("[ BMC -> YOU : " + this.statusCode + "  " + this.responseString + "]");
            }
        }
        finally {
            response.close();
            httpClient.close();
        }
        return this.statusCode;
    }

    public int post_https_Update_multipart(String url, String filename, String bodyString) throws Exception {
        CloseableHttpClient httpClient = this.prepareHttpClient();
        HttpPost httpUpload = new HttpPost(url);
        this.resetURL(url);
        httpUpload.setHeader("x-auth-token", this.token);
        FileBody fileBody = new FileBody(new File(filename));
        StringBody stringBody1 = new StringBody(bodyString, ContentType.MULTIPART_FORM_DATA);
        MultipartEntityBuilder mpBuilder = MultipartEntityBuilder.create();
        mpBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        mpBuilder.addPart("UpdateParameters", stringBody1);
        mpBuilder.addPart("UpdateFile", fileBody);
        HttpEntity entity = mpBuilder.build();
        httpUpload.setEntity(entity);
        CloseableHttpResponse response = httpClient.execute(httpUpload);
        int returnCode = response.getStatusLine().getStatusCode();
        response.close();
        httpClient.close();
        return returnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send_https_patch(String url, String bodyString) throws Exception {
        CloseableHttpClient httpClient = this.prepareHttpClient();
        this.resetURL(url);
        HttpPatch httpPatch = new HttpPatch(url);
        httpPatch.setHeader("x-auth-token", this.token);
        if (bodyString.length() != 0) {
            StringEntity body = new StringEntity(bodyString);
            httpPatch.setHeader("Content-type", "application/json");
            httpPatch.setEntity(body);
        }
        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
            System.out.println("[ YOU -> BMC : Sending http patch " + httpPatch.getURI() + "]");
        }
        CloseableHttpResponse response = httpClient.execute(httpPatch);
        try {
            this.statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity2 = response.getEntity();
            this.responseString = EntityUtils.toString(entity2);
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                System.out.println("[ BMC -> YOU : " + this.statusCode + "  " + this.responseString + "]");
            }
        }
        finally {
            response.close();
            httpClient.close();
        }
        return this.statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send_https_delete(String url) throws Exception {
        CloseableHttpClient httpClient = this.prepareHttpClient();
        this.resetURL(url);
        HttpDelete httpDelete = new HttpDelete(url);
        httpDelete.setHeader("x-auth-token", this.token);
        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
            System.out.println("[ YOU -> BMC : Sending http delete " + httpDelete.getURI() + "]");
        }
        CloseableHttpResponse response = httpClient.execute(httpDelete);
        try {
            this.statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            this.responseString = EntityUtils.toString(entity);
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                System.out.println("[ BMC -> YOU : " + this.statusCode + "  " + this.responseString + "]");
            }
        }
        finally {
            response.close();
            httpClient.close();
        }
        return this.statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getToken() throws Exception {
        int statusCode;
        CloseableHttpClient httpClient = this.prepareHttpClient();
        HttpPost httpPost = new HttpPost("https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/SessionService/Sessions/");
        String bodyString = "{\"UserName\":\"" + this.config.getUserName() + "\",\"Password\":\"" + this.config.getPassword() + "\"}";
        StringEntity body = new StringEntity(bodyString);
        httpPost.setHeader("Content-type", "application/json");
        httpPost.setEntity(body);
        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
            System.out.println("[ YOU -> BMC : Sending http post " + httpPost.getURI() + "]");
        }
        CloseableHttpResponse response = httpClient.execute(httpPost);
        try {
            statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity2 = response.getEntity();
            this.token = response.getFirstHeader("X-Auth-Token").getValue();
            String response2String = EntityUtils.toString(entity2);
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                System.out.println("[ BMC -> YOU : " + statusCode + "  " + response2String + "]");
            }
            try {
                this.setSessionID(response2String);
            }
            catch (Exception e2) {
                statusCode = 99;
                System.out.println("Exception: SessionID not found");
            }
        }
        finally {
            response.close();
            httpClient.close();
        }
        return statusCode == 201;
    }

    public void closeSession() throws Exception {
        if (this.sessionID == -1) {
            return;
        }
        CloseableHttpClient httpClient = this.prepareHttpClient();
        HttpDelete httpDelete = new HttpDelete("https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/SessionService/Sessions/" + this.sessionID);
        httpDelete.setHeader("Content-type", "application/json");
        httpDelete.setHeader("x-auth-token", this.token);
        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
            System.out.println("[ YOU -> BMC : Sending http delete " + httpDelete.getURI() + "]");
        }
        CloseableHttpResponse response = httpClient.execute(httpDelete);
        int statusCode = response.getStatusLine().getStatusCode();
        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
            HttpEntity entity = response.getEntity();
            String response2String = EntityUtils.toString(entity);
            System.out.println("[ BMC -> YOU : " + statusCode + "  " + response2String + "]");
        }
        response.close();
        httpClient.close();
    }

    public void setSessionID(String input) throws JsonProcessingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootArray = mapper.readTree(input);
        JsonNode id = rootArray.path("Id");
        this.sessionID = id.asInt();
    }

    public String getResponseString() {
        return this.responseString;
    }

    private void resetURL(String url) {
        this.responseString = "";
        this.currentURL = url;
        this.statusCode = 0;
    }

    public void printResult() {
        System.out.println("URL:" + this.currentURL);
        System.out.println("Redfish StatusCode:" + this.statusCode);
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("2.2.2.2");
        config.setUserName(StunnelUtility.testADMIN());
        config.setPassword(StunnelUtility.testADMIN());
        GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL = 1;
        SessionLoginClient sc = new SessionLoginClient(config);
        System.out.println(sc.token + "  " + sc.sessionID);
        try {
            sc.send_https_get("https://2.147.2.2/redfish/v1/Systems/1/");
            sc.closeSession();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

