/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishActAPI;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;
import java.util.ArrayList;

public class ADDeleteAddressCommand
extends RedfishTokenCommand {
    int deleteIndex = 99;

    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length != 1) {
            this.printUsage();
            return false;
        }
        try {
            this.deleteIndex = Integer.parseInt(this.parameters[0]);
            if (this.deleteIndex < 1 || this.deleteIndex > 3) {
                MOut.G(this).println("Invalid Index");
                this.printUsage();
                return false;
            }
        }
        catch (NumberFormatException ex) {
            this.printUsage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        RedfishActAPI api = new RedfishActAPI(this.config);
        if (!api.checkIfDCMSSingleExist()) {
            MOut.G(this).println("Login failed. DCMS-single may need to be activated for this device.");
            MOut.G(this).println("Or user credentials may be wrong.");
            this.statusCode = 155;
            return;
        }
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/AccountService/";
        int result = this.sessionLoginClient.send_https_get(url);
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(this.sessionLoginClient.getResponseString());
            JsonNode ActiveDirectory = node.path("ActiveDirectory");
            JsonNode ServiceEnabled = ActiveDirectory.path("ServiceEnabled");
            JsonNode ServiceAddress = ActiveDirectory.path("ServiceAddresses");
            boolean isEnable = ServiceEnabled.asBoolean();
            if (isEnable) {
                ArrayList<String> list = new ArrayList<String>();
                if (ServiceAddress.isArray()) {
                    for (int i2 = 0; i2 < ServiceAddress.size(); ++i2) {
                        list.add(ServiceAddress.get(i2).asText());
                    }
                }
                if (this.deleteIndex > list.size()) {
                    MOut.G(this).println("Address not found");
                    this.statusCode = 149;
                    return;
                }
                list.remove(this.deleteIndex - 1);
                String body = "{\"ActiveDirectory\": {\"ServiceAddresses\":[";
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    body = body + "\"" + (String)list.get(i3) + "\",";
                    if (i3 != list.size() - 1) continue;
                    body = body.substring(0, body.length() - 1);
                }
                result = this.sessionLoginClient.send_https_patch(url, body = body + "]}}");
                if (result < 200 || result > 210) {
                    MOut.G(this).println("Action failed. ErrorCode:" + result);
                    this.statusCode = 149;
                    return;
                }
            } else {
                MOut.G(this).println("Active Directory is disabled");
                this.statusCode = 149;
                return;
            }
            MOut.G(this).println("Done");
            this.statusCode = 0;
        } else {
            MOut.G(this).println("Fail to read Active Directory information. ErrorCode:" + result);
            this.statusCode = 149;
        }
    }

    public void printUsage() {
        MOut.G(this).println("Usage: redfish accountService ad deleteAddress <number>");
    }
}

