/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishActAPI;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;

public class ADListCommand
extends RedfishCommand {
    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        RedfishActAPI api = new RedfishActAPI(this.config);
        if (!api.checkIfDCMSSingleExist()) {
            MOut.G(this).println("Login failed. DCMS-single may need to be activated for this device.");
            MOut.G(this).println("Or user credentials may be wrong.");
            this.statusCode = 155;
            return;
        }
        BasicAuthClient bc = new BasicAuthClient(this.config);
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/AccountService/";
        int result = bc.send_https_get(url);
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(bc.getResponseString());
            JsonNode ActiveDirectory = node.path("ActiveDirectory");
            JsonNode ServiceEnabled = ActiveDirectory.path("ServiceEnabled");
            JsonNode ServiceAddress = ActiveDirectory.path("ServiceAddresses");
            JsonNode RemoteRole = ActiveDirectory.path("RemoteRoleMapping");
            boolean isEnable = ServiceEnabled.asBoolean();
            if (isEnable) {
                int i2;
                StringBuffer formatedString;
                String formatTemplate;
                if (ServiceAddress.isArray()) {
                    MOut.G(this).print(this.toFormatedAddressHeader());
                    formatTemplate = " %-5s | %-50s\n";
                    formatedString = new StringBuffer();
                    if (ServiceAddress.size() == 0) {
                        MOut.G(this).println("None");
                    } else {
                        for (i2 = 0; i2 < ServiceAddress.size(); ++i2) {
                            formatedString.append(String.format(formatTemplate, i2 + 1, ServiceAddress.get(i2).asText()));
                        }
                    }
                    if (formatedString.length() != 0) {
                        MOut.G(this).println(formatedString.toString());
                    }
                }
                if (RemoteRole.isArray()) {
                    MOut.G(this).println();
                    MOut.G(this).print(this.toFormatedRoleHeader());
                }
                formatTemplate = " %-5s | %30s | %20s | %15s\n";
                formatedString = new StringBuffer();
                if (RemoteRole.size() == 0) {
                    MOut.G(this).println("None");
                } else {
                    for (i2 = 0; i2 < RemoteRole.size(); ++i2) {
                        JsonNode roleMapping = RemoteRole.get(i2);
                        JsonNode RemoteGroup = roleMapping.path("RemoteGroup");
                        JsonNode RemoteUser = roleMapping.path("RemoteUser");
                        JsonNode LocalRole = roleMapping.path("LocalRole");
                        formatedString.append(String.format(formatTemplate, i2 + 1, RemoteUser.asText(), RemoteGroup.asText(), LocalRole.asText().toLowerCase().equals("readonly") ? "User" : LocalRole.asText()));
                    }
                }
                if (formatedString.length() != 0) {
                    MOut.G(this).println(formatedString.toString());
                }
            } else {
                MOut.G(this).println("Active Directory is disabled");
                this.statusCode = 149;
                return;
            }
            this.statusCode = 0;
        } else {
            MOut.G(this).println("Fail to read Active Directory information. ErrorCode:" + result);
            this.statusCode = 149;
        }
    }

    public String toFormatedRoleHeader() {
        String formatTemplate = " %-5s | %30s | %20s | %15s\n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "No.", "Remote User", "Remote Group", "Role"));
        header.append(String.format(formatTemplate, "-----", "-----------------------------", "-------------------", "--------------"));
        return header.toString();
    }

    public String toFormatedAddressHeader() {
        String formatTemplate = " %-5s | %-50s\n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "No.", "Service Addresses list"));
        header.append(String.format(formatTemplate, "-----", "--------------------------------------------------"));
        return header.toString();
    }
}

