/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishActAPI;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;

public class ADStatusCommand
extends RedfishTokenCommand {
    boolean state;

    @Override
    public boolean preValidate() {
        if (this.parameters != null) {
            try {
                int status = Integer.parseInt(this.parameters[0]);
                if (status != 1 && status != 0) {
                    this.printUsage();
                    return false;
                }
                this.state = status != 0;
            }
            catch (Exception e2) {
                this.printUsage();
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        RedfishActAPI api = new RedfishActAPI(this.config);
        if (!api.checkIfDCMSSingleExist()) {
            MOut.G(this).println("Login failed. DCMS-single may need to be activated for this device.");
            MOut.G(this).println("Or user credentials may be wrong.");
            this.statusCode = 155;
            return;
        }
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/AccountService/";
        BasicAuthClient bc = new BasicAuthClient(this.config);
        if (this.parameters == null) {
            int result = bc.send_https_get(url);
            if (result >= 200 && result <= 210) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode node = mapper.readTree(bc.getResponseString());
                JsonNode ActiveDirectory = node.path("ActiveDirectory");
                JsonNode ServiceEnabled = ActiveDirectory.path("ServiceEnabled");
                boolean isEnable = ServiceEnabled.asBoolean();
                if (isEnable) {
                    MOut.G(this).println("ActiveDirectory enabled");
                } else {
                    MOut.G(this).println("ActiveDirectory disabled");
                }
                MOut.G(this).println("");
                this.printUsage();
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Fail to read Active Directory information. ErrorCode:" + result);
                this.statusCode = 149;
            }
        } else {
            int result = this.sessionLoginClient.send_https_get(url);
            if (result >= 200 && result <= 210) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode node = mapper.readTree(this.sessionLoginClient.getResponseString());
                JsonNode ActiveDirectory = node.path("ActiveDirectory");
                JsonNode ServiceEnabled = ActiveDirectory.path("ServiceEnabled");
                boolean isEnable = ServiceEnabled.asBoolean();
                if (isEnable && this.state) {
                    MOut.G(this).println("AD is currently enabled already.");
                    this.statusCode = 0;
                } else if (!isEnable && !this.state) {
                    MOut.G(this).println("AD is currently disabled already.");
                    this.statusCode = 0;
                } else {
                    JsonNode LDAP = node.path("LDAP");
                    JsonNode LDAPServiceEnabled = LDAP.path("ServiceEnabled");
                    boolean isLADPEnable = LDAPServiceEnabled.asBoolean();
                    if (isLADPEnable) {
                        MOut.G(this).println("LDAP is currently enabled. Please disable it and then re-enable AD.");
                        this.statusCode = 149;
                        return;
                    }
                    String urlRadius = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/Managers/1/" + "Oem/" + "Supermicro/" + "RADIUS";
                    result = this.sessionLoginClient.send_https_get(urlRadius);
                    if (result >= 200 && result <= 210) {
                        node = mapper.readTree(this.sessionLoginClient.getResponseString());
                        JsonNode RadiusEnabled = node.path("RadiusEnabled");
                        boolean isRadiusEnable = RadiusEnabled.asBoolean();
                        if (isRadiusEnable) {
                            MOut.G(this).println("Radius is currently enabled. Please disable it and then re-enable AD.");
                            this.statusCode = 149;
                            return;
                        }
                    } else {
                        this.printFailMessage(result, this.sessionLoginClient.getResponseString());
                        MOut.G(this).println("Failed");
                        this.statusCode = 149;
                        return;
                    }
                    String body = "{\"ActiveDirectory\": {\"ServiceEnabled\":" + this.state + "}}";
                    result = bc.send_https_patch(url, body);
                    if (result >= 200 && result <= 210) {
                        MOut.G(this).println("Done");
                        this.statusCode = 0;
                    } else {
                        this.printFailMessage(result, bc.getResponseString());
                        this.statusCode = 149;
                    }
                }
            } else {
                this.printFailMessage(result, bc.getResponseString());
                this.statusCode = 149;
            }
        }
    }

    public void printUsage() {
        MOut.G(this).println("Usage: redfish accountService ad status [enabled]");
        MOut.G(this).println("       enable : 1");
        MOut.G(this).println("       disable :0");
    }
}

