/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.AlertSetBaseCommand;

public class AlertDeleteCommand
extends RedfishCommand {
    public static final String URI_SUFFIX = "EventService/Subscriptions/";

    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length != 1) {
            MOut.G(this).println("Wrong parameter.");
            this.statusCode = 147;
            return false;
        }
        try {
            int index = Integer.parseInt(this.parameters[0]);
            if (index < 1 || index > 16) {
                MOut.G(this).println("Index is out of range(1 to 16).");
                this.statusCode = 147;
                return false;
            }
        }
        catch (NumberFormatException e2) {
            MOut.G(this).println("Index should be a integer in 1 to 16.");
            this.statusCode = 147;
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!AlertSetBaseCommand.isSupported(this.config)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        BasicAuthClient client = new BasicAuthClient(this.config);
        String alertURI = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/" + URI_SUFFIX + this.parameters[0];
        int responseResult = client.send_https_delete(alertURI);
        if (responseResult == 200) {
            MOut.G(this).println("Done");
            this.statusCode = 0;
        } else if (responseResult == 404) {
            MOut.G(this).println("404 not found");
            this.statusCode = 153;
        } else {
            MOut.G(this).println("Failed, error code:[" + responseResult + "]");
            this.statusCode = 149;
        }
    }
}

