/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.AlertSetBaseCommand;

public class AlertSetSNMPv1Command
extends AlertSetBaseCommand {
    public static final String URI_SUFFIX = "EventService/Subscriptions/";
    public static final String JSON_TEMPLATE = "{\"Oem\":{\"Supermicro\":{\"EnableSubscription\":true,\"Severity\":\"%s\"}},\"Protocol\":\"SNMPv1\",\"Destination\":\"%s\",\"SNMP\":{\"TrapCommunity\":\"%s\"},\"EventTypes\":[\"Alert\"]}";

    @Override
    public boolean preValidate() {
        if (null == this.parameters || this.parameters.length != 4) {
            this.usage();
            this.statusCode = 147;
            return false;
        }
        if (!this.isValidNumber(this.parameters[0])) {
            this.statusCode = 147;
            MOut.G(this).println("Number should be a integer in 1-16 range.");
            this.usage();
            return false;
        }
        if (!this.isValidSeverity(this.parameters[1])) {
            this.statusCode = 147;
            MOut.G(this).println("It is an invalid severity value.");
            this.usage();
            return false;
        }
        if (!this.isValidIP(this.parameters[2])) {
            this.statusCode = 147;
            MOut.G(this).println("It is an invalid IP format.");
            this.usage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!AlertSetBaseCommand.isSupported(this.config)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        String jsonBody = String.format(JSON_TEMPLATE, this.getSeverity(this.parameters[1]), this.parameters[2], this.parameters[3]);
        String redfishURI = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/" + URI_SUFFIX + Integer.valueOf(this.parameters[0]);
        this.runPatchCommand(redfishURI, jsonBody);
    }

    private void usage() {
        MOut.G(this).println("Usage: redfish eventService alert setSNMPv1 <number> <severity> <destination> <trap community>");
        MOut.G(this).println("Severity: ");
        MOut.G(this).println(" Information : 0");
        MOut.G(this).println(" Warning     : 1");
        MOut.G(this).println(" Critical    : 2");
        MOut.G(this).println("Destination: ");
        MOut.G(this).println(" IPv4/IPv6 format");
    }
}

