/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.LicenseManager;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.text.BIOSConfigurationHelper;
import java.util.HashMap;

public abstract class BIOSConfigurationBaseCommand
extends RedfishCommand {
    private String backupSessionIP = null;
    private BIOSConfigurationHelper helper = null;
    private static HashMap<Byte, Byte> legacySupportedMap = null;

    public BIOSConfigurationBaseCommand() {
        legacySupportedMap = new HashMap();
        legacySupportedMap.put((byte)27, (byte)43);
    }

    protected boolean isCommandAvailable() {
        ISessionController controller;
        boolean result;
        block7: {
            result = false;
            controller = null;
            IPMIMessagingCommand command = new IPMIMessagingCommand(null);
            try {
                controller = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilegeEx(this.config, command);
            }
            catch (IPMIException e2) {
                MOut.G(this).println("Failed to establish connection");
                this.statusCode = 145;
                break block7;
            }
            boolean isLegacySupport = this.isLegacySupport(command.getIPMIInterface());
            byte[] guid = IPMIMessagingCommand.getSystemGUIDbyConfig(this.config);
            if (!isLegacySupport && IPMIMessagingCommand.isBeforeX12(guid)) {
                MOut.G(this).println("This device is not supported");
                this.statusCode = 153;
            } else {
                LicenseManager manager = new LicenseManager(command.getIPMIInterface(), this.config);
                if (!manager.checkIfDCMSLicenseExist()) {
                    MOut.G(this).println("DCMS-single needs to be activated for this device");
                    this.statusCode = 155;
                } else {
                    result = true;
                }
            }
        }
        if (controller != null) {
            controller.closeSession();
        }
        return result;
    }

    protected BIOSConfigurationHelper getHelper() {
        if (!this.compareToSessionIP()) {
            this.helper = null;
        }
        if (this.helper == null) {
            this.helper = new BIOSConfigurationHelper(super.getConfig());
        }
        return this.helper;
    }

    private boolean compareToSessionIP() {
        if (this.backupSessionIP == null || !this.backupSessionIP.equals(super.getConfig().getIp())) {
            this.backupSessionIP = super.getConfig().getIp();
            return false;
        }
        return true;
    }

    private boolean isLegacySupport(IPMIInterface ipmiInterface) {
        Byte key;
        IPMIOEMCommand command = new IPMIOEMCommand(ipmiInterface);
        byte[] productID = command.getProductID();
        return productID != null && productID.length >= 2 && (key = legacySupportedMap.get(productID[1])) != null && key == productID[0];
    }
}

