/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.text.Argument;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.BIOSAttributeSchema;
import com.supermicro.redfish.text.BIOSConfigurationGeneralCommand;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BIOSConfigurationHelper {
    public static final String BIOS_REGISTRIES_URL_SUFFIX = "/redfish/v1/Registries";
    public static final String BIOS_ATTRIBUTE_URL_SUFFIX = "/redfish/v1/Systems/1/Bios";
    public static final String BIOS_ATTRIBUTE_SD_URL_SUFFIX = "/redfish/v1/Systems/1/Bios/SD";
    public static final String BIOS_ATTRIBUTE_RESET_URL_SUFFIX = "/redfish/v1/Systems/1/Bios/Actions/Bios.ResetBios";
    public static final String BIOS_ATTRIBUTE_REGISTRY_PREFIX = "BiosAttributeRegistry";
    public static final String BIOS_NODE_REGISTY_VER_URI = "Members";
    public static final String BIOS_NODE_REGISTY_OEM_URI = "Uri";
    public static final int BIOS_VALUE_MAX_LENGTH = 40;
    private final String PROTECTED_ATTRIBUTE_PASSWORD_ADMIN = "AdministratorPassword";
    private final String PROTECTED_ATTRIBUTE_PASSWORD_USER = "UserPassword";
    private IPMIInterfaceConfig ipmiInterfaceConfig;
    private Map<String, String> attributeHashMap;
    private Map<String, String> commandNameHashMap;
    private Map<String, BIOSAttributeSchema> schemaHashMap;
    private List<String> attributeProtectedList;

    public BIOSConfigurationHelper(IPMIInterfaceConfig config) {
        this.ipmiInterfaceConfig = config;
        this.commandNameHashMap = new HashMap<String, String>();
        this.schemaHashMap = new HashMap<String, BIOSAttributeSchema>();
        this.attributeProtectedList = new ArrayList<String>();
        this.attributeProtectedList.add("AdministratorPassword");
        this.attributeProtectedList.add("UserPassword");
    }

    public String getAttribute(String keyword) throws Exception {
        if (this.schemaHashMap.isEmpty() && !this.getAttributeSchema()) {
            return null;
        }
        if (!this.getAttributeCollection()) {
            return null;
        }
        String attributeName = null;
        attributeName = this.schemaHashMap.containsKey(keyword) ? keyword : this.commandNameHashMap.get(keyword);
        if (attributeName == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Description : " + this.getAttributeHelpText(attributeName)).append("\n");
        buffer.append(this.getAttributeValueRules(attributeName)).append("\n");
        String attributeNameRaw = null;
        String valueSD = null;
        attributeNameRaw = attributeName.contains("(R)") && this.schemaHashMap.get(attributeName).getDisplayName().contains("(R)") ? attributeName : this.revertNonAsciiSymbol(attributeName);
        valueSD = this.getAttributeSD(attributeNameRaw);
        buffer.append("--------------------------------").append("\n");
        if (valueSD != null) {
            buffer.append("Current value : " + this.attributeHashMap.get(attributeNameRaw));
            buffer.append("\nPending value : " + valueSD);
        } else {
            buffer.append("Current value : " + this.attributeHashMap.get(attributeNameRaw));
        }
        return buffer.toString();
    }

    public String getAllAttributes() throws Exception {
        return this.getAllAttributes(null);
    }

    public String getAllAttributes(String keyword) throws Exception {
        if (this.schemaHashMap.isEmpty() && !this.getAttributeSchema()) {
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                System.out.println("Get attribute schema failed");
            }
            return null;
        }
        if (!this.getAttributeCollection()) {
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                System.out.println("Get attributes failed");
            }
            return null;
        }
        return this.outputAttributeHashMap(this.attributeHashMap, keyword);
    }

    public Map<String, String> getAttributeMap() throws Exception {
        if (!this.getAttributeCollection()) {
            return null;
        }
        return this.attributeHashMap;
    }

    public Map<String, BIOSAttributeSchema> getSchemaHashMap() throws Exception {
        if (this.schemaHashMap.isEmpty() && !this.getAttributeSchema()) {
            return null;
        }
        return this.schemaHashMap;
    }

    public boolean setAttribute(String keyword, String value) throws Exception {
        boolean result = false;
        if (!this.schemaHashMap.isEmpty() || this.getAttributeSchema()) {
            String attributeName = null;
            attributeName = this.schemaHashMap.containsKey(keyword) ? keyword : this.commandNameHashMap.get(keyword);
            if (attributeName == null) {
                System.out.println("Command is not found");
            } else {
                BIOSAttributeSchema attributeSchema = this.schemaHashMap.get(attributeName);
                if (attributeSchema == null) {
                    System.out.println("Cannot find attribute in schema");
                } else if (attributeSchema.isProtected()) {
                    System.out.println("Protected value");
                    System.out.println(this.getAttributeHelpText(attributeName));
                    System.out.println(this.getAttributeValueRules(attributeName));
                } else if (attributeSchema.isGrayOut()) {
                    System.out.println("GrayOut attribute value");
                    System.out.println(this.getAttributeHelpText(attributeName));
                    System.out.println(this.getAttributeValueRules(attributeName));
                } else if (attributeSchema.isReadOnly()) {
                    System.out.println("ReadOnly attribute value");
                    System.out.println(this.getAttributeHelpText(attributeName));
                    System.out.println(this.getAttributeValueRules(attributeName));
                } else if (!attributeSchema.isValidAttribute(value)) {
                    System.out.println("Invalid attribute value");
                    System.out.println(this.getAttributeHelpText(attributeName));
                    System.out.println(this.getAttributeValueRules(attributeName));
                } else {
                    result = this.setAttributeCollection(attributeName, value);
                }
            }
        }
        return result;
    }

    public void setAttributeBatch(String name, String value, StringBuffer strBuffer) throws Exception {
        if ((this.schemaHashMap.isEmpty() || this.commandNameHashMap.isEmpty()) && !this.getAttributeSchema()) {
            strBuffer = null;
        } else {
            String primaryKey = this.commandNameHashMap.get(name);
            if (primaryKey == null || primaryKey.isEmpty()) {
                System.out.println("invalid command name[" + name + "]");
            } else if (!this.schemaHashMap.containsKey(primaryKey)) {
                System.out.println("invalid attribute name[" + primaryKey + "]");
            } else if (!this.schemaHashMap.get(primaryKey).isValidAttribute(value)) {
                System.out.println("invalid attribute value[" + value + "] of " + primaryKey);
                System.out.println(this.getAttributeHelpText(primaryKey));
                System.out.println(this.getAttributeValueRules(primaryKey));
            } else if (!(this.schemaHashMap.get(primaryKey).isProtected() || this.schemaHashMap.get(primaryKey).isReadOnly() || this.schemaHashMap.get(primaryKey).isGrayOut())) {
                String formatTemplate = primaryKey.contains("(R)") && this.schemaHashMap.get(primaryKey).getDisplayName().contains("(R)") ? "\"" + this.replaceDoubleQuoteSymbol(primaryKey) + "\": %s" : "\"" + this.replaceDoubleQuoteSymbol(this.revertNonAsciiSymbol(primaryKey)) + "\": %s";
                String patchBody = null;
                BIOSAttributeSchema schema = this.schemaHashMap.get(primaryKey);
                int valueType = schema.getValueType();
                switch (valueType) {
                    case 0: {
                        patchBody = String.format(formatTemplate, "\"" + value + "\"");
                        break;
                    }
                    case 2: 
                    case 4: {
                        patchBody = String.format(formatTemplate, "\"" + value + "\"");
                        break;
                    }
                    case 1: {
                        patchBody = String.format(formatTemplate, schema.getConvertedBoolString(value));
                        break;
                    }
                    case 3: {
                        patchBody = String.format(formatTemplate, value);
                        break;
                    }
                }
                if (strBuffer.length() != 0) {
                    strBuffer.append(", ");
                }
                strBuffer.append(patchBody);
            }
        }
    }

    public boolean setAttributeMenu(Argument menuArgument) throws Exception {
        if (!this.getAttributeSchema()) {
            return false;
        }
        if (!this.getAttributeCollection()) {
            return false;
        }
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>(this.attributeHashMap.entrySet());
        list.sort(Map.Entry.comparingByKey());
        for (Map.Entry entry : list) {
            BIOSAttributeSchema schema = this.schemaHashMap.get(this.convertNonAsciiSymbol((String)entry.getKey()));
            String path = this.convertNonAsciiSymbol(schema.getPath());
            String[] subPaths = this.splitPath(path);
            Argument leafArgument = this.findLeafArgument(menuArgument, subPaths);
            if (leafArgument != null) {
                leafArgument.addNextArgument(this.createTargetArgument(schema));
                continue;
            }
            return false;
        }
        return true;
    }

    public int resetBIOS() {
        int result = 400;
        BasicAuthClient client = new BasicAuthClient(this.ipmiInterfaceConfig);
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.ipmiInterfaceConfig.getIp()) + BIOS_ATTRIBUTE_RESET_URL_SUFFIX;
        try {
            result = client.send_https_post(url, "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private String getAttributeHelpText(String attributeName) throws Exception {
        if (this.schemaHashMap.isEmpty() && !this.getAttributeSchema()) {
            return "";
        }
        if (!this.schemaHashMap.containsKey(attributeName)) {
            return "invalid attribute name";
        }
        return this.schemaHashMap.get(attributeName).getDescription();
    }

    private String getAttributeValueRules(String attributeName) throws Exception {
        if (this.schemaHashMap.isEmpty() && !this.getAttributeSchema()) {
            return "";
        }
        if (!this.schemaHashMap.containsKey(attributeName)) {
            return "invalid attribute name";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Type: ");
        BIOSAttributeSchema schema = this.schemaHashMap.get(attributeName);
        if (schema.getValueType() == 0) {
            buffer.append("Enumeration").append("\n");
            buffer.append(schema.getValueRulesDescription());
        } else if (schema.getValueType() == 3) {
            buffer.append("Integer").append("\n");
            buffer.append(schema.getValueRulesDescription());
        } else if (schema.getValueType() == 2) {
            buffer.append("String").append("\n");
            buffer.append(schema.getValueRulesDescription());
        } else if (schema.getValueType() == 1) {
            buffer.append("Boolean").append("\n");
            buffer.append(schema.getValueRulesDescription());
        } else if (schema.getValueType() == 4) {
            buffer.append("Password");
        }
        return buffer.toString();
    }

    private boolean getAttributeSchema() throws Exception {
        block4: {
            String registiesOEMURI;
            RedfishHttpUtils utils = new RedfishHttpUtils();
            utils.setEnumMajorSymbol("~");
            utils.setEnumMinorSymbol("`");
            String registiesVersionURI = this.getRegistriesVersionURI(utils);
            if (registiesVersionURI != null && (registiesOEMURI = this.getRegisteriesOEMURI(utils, registiesVersionURI)) != null) {
                try {
                    this.setAttributeSchema(utils, registiesOEMURI);
                }
                catch (Exception ex) {
                    if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                        System.out.println("Get attribute schema failed");
                    }
                    break block4;
                }
                return true;
            }
        }
        return false;
    }

    private String getRegistriesVersionURI(RedfishHttpUtils utils) throws Exception {
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.ipmiInterfaceConfig.getIp()) + BIOS_REGISTRIES_URL_SUFFIX;
        int result = utils.sendRedfishGet(this.ipmiInterfaceConfig, url);
        if (200 <= result && result <= 206) {
            List<HashMap<String, String>> mapList = utils.getEntryList();
            for (HashMap<String, String> map : mapList) {
                if (null == map || !map.values().toString().contains(BIOS_ATTRIBUTE_REGISTRY_PREFIX)) continue;
                return map.values().toString().replace("[", "").replace("]", "");
            }
        }
        return null;
    }

    private String getRegisteriesOEMURI(RedfishHttpUtils utils, String suffixURL) throws Exception {
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.ipmiInterfaceConfig.getIp()) + suffixURL;
        int result = utils.sendRedfishGet(this.ipmiInterfaceConfig, url);
        if (200 <= result && result <= 206) {
            List<HashMap<String, String>> mapList = utils.getEntryList();
            for (HashMap<String, String> map : mapList) {
                if (null == map || !map.containsKey(BIOS_NODE_REGISTY_OEM_URI)) continue;
                return map.get(BIOS_NODE_REGISTY_OEM_URI);
            }
        }
        return null;
    }

    private void setAttributeSchema(RedfishHttpUtils utils, String suffixURL) throws Exception {
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.ipmiInterfaceConfig.getIp()) + suffixURL;
        int result = utils.sendRedfishGet(this.ipmiInterfaceConfig, url);
        if (200 <= result && result <= 206) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
            String body = utils.getRedfishResponse();
            JsonNode rootNode = mapper.readTree(body);
            List<HashMap<String, String>> schemaHashMapList = utils.getEntryListInNode(rootNode.path("RegistryEntries"));
            Map<String, Integer> displayNameCounterMap = this.getDisplayNameCounterMap(schemaHashMapList);
            this.commandNameHashMap.clear();
            for (HashMap<String, String> map : schemaHashMapList) {
                String primaryKey = map.get("AttributeName");
                if (primaryKey == null) continue;
                primaryKey = this.convertNonAsciiSymbol(primaryKey);
                String displayName = map.get("DisplayName").replaceAll("\\s", "");
                Integer displayNameCount = displayNameCounterMap.get(displayName);
                boolean isDuplicated = displayNameCount != null ? displayNameCount > 1 : false;
                String commandName = this.convertNonAsciiSymbol(this.getCommandName(primaryKey, displayName, isDuplicated));
                BIOSAttributeSchema schema = new BIOSAttributeSchema();
                schema.setAttributeName(primaryKey);
                schema.setDisplayName(displayName);
                schema.setCommandName(commandName);
                schema.setPath(this.convertNonAsciiSymbol(map.get("MenuPath")).replaceAll("\\s", ""));
                schema.setReadOnly(map.get("ReadOnly") != null ? map.get("ReadOnly").equals("true") : true);
                schema.setHidden(map.get("Hidden") != null ? map.get("Hidden").equals("true") : false);
                schema.setGrayOuty(map.get("GrayOut").equals("true"));
                schema.setValueType(map.get("Type"));
                schema.setProtected(this.attributeProtectedList != null ? this.attributeProtectedList.contains(displayName) : false);
                schema.setDescription(this.convertNonAsciiSymbol(map.get("HelpText")));
                if (schema.getValueType() == 0) {
                    schema.setValueRules(map.get("Value"));
                } else if (schema.getValueType() == 2) {
                    Integer minLength = Integer.valueOf(map.get("MinLength"));
                    Integer maxLength = Integer.valueOf(map.get("MaxLength"));
                    schema.setValueRules(minLength, maxLength);
                } else if (schema.getValueType() == 3) {
                    BigDecimal loBound = new BigDecimal(map.get("LowerBound"));
                    BigDecimal hiBound = new BigDecimal(map.get("UpperBound"));
                    Integer sIncrement = Integer.valueOf(map.get("ScalarIncrement"));
                    schema.setValueRules(loBound, hiBound, sIncrement);
                }
                this.commandNameHashMap.put(commandName, primaryKey);
                this.schemaHashMap.put(primaryKey, schema);
            }
        }
    }

    private boolean getAttributeCollection() throws Exception {
        RedfishHttpUtils utils = new RedfishHttpUtils();
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.ipmiInterfaceConfig.getIp()) + BIOS_ATTRIBUTE_URL_SUFFIX;
        int result = utils.sendRedfishGet(this.ipmiInterfaceConfig, url);
        if (200 <= result && result <= 206) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = mapper.readTree(utils.getRedfishResponse());
            this.attributeHashMap = utils.getEntry(rootNode.path("Attributes"));
            return true;
        }
        return false;
    }

    private String getAttributeSD(String attributeName) throws Exception {
        HashMap<String, String> hashmap = this.getAttributeSDCollection();
        if (null != hashmap && hashmap.containsKey(attributeName)) {
            return hashmap.get(attributeName);
        }
        return null;
    }

    public HashMap<String, String> getAttributeSDCollection() throws Exception {
        RedfishHttpUtils utils = new RedfishHttpUtils();
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.ipmiInterfaceConfig.getIp()) + BIOS_ATTRIBUTE_SD_URL_SUFFIX;
        int result = utils.sendRedfishGet(this.ipmiInterfaceConfig, url);
        if (200 <= result && result <= 206) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = mapper.readTree(utils.getRedfishResponse());
            return utils.getEntry(rootNode.path("Attributes"));
        }
        return null;
    }

    private String outputAttributeHashMap(Map<String, String> hashmap, String keyword) {
        ArrayList<Map.Entry<String, String>> attributeList = new ArrayList<Map.Entry<String, String>>(hashmap.entrySet());
        HashMap<String, String> outputHashmap = new HashMap<String, String>();
        StringBuffer buffer = new StringBuffer();
        int commandNameMaxLength = 0;
        int commandValueMaxLength = 0;
        for (int index = 0; index < attributeList.size(); ++index) {
            String attributeName = attributeList.get(index) != null ? (String)((Map.Entry)attributeList.get(index)).getKey() : "";
            BIOSAttributeSchema schema = this.schemaHashMap.get(this.convertNonAsciiSymbol(attributeName));
            String commandName = schema.getCommandName() != null ? schema.getCommandName() : "";
            String commandValue = this.attributeHashMap.get(attributeName) != null ? this.attributeHashMap.get(attributeName) : "";
            commandNameMaxLength = Math.max(commandNameMaxLength, commandName.length());
            commandValueMaxLength = Math.max(commandValueMaxLength, commandValue.length());
            if (keyword != null) {
                if (!commandName.toLowerCase().contains(keyword.toLowerCase()) && !commandValue.toLowerCase().contains(keyword.toLowerCase())) continue;
                outputHashmap.put(this.convertNonAsciiSymbol(commandName), commandValue);
                continue;
            }
            outputHashmap.put(this.convertNonAsciiSymbol(commandName), this.getShortenValue(commandValue));
        }
        if (keyword == null) {
            commandValueMaxLength = Math.min(commandValueMaxLength, 40);
        }
        if (outputHashmap.size() > 0) {
            int idx;
            ArrayList outputList = new ArrayList(outputHashmap.entrySet());
            outputList.sort(Map.Entry.comparingByKey());
            String descriptinBar = "Total attributes";
            String formatTemplate = " %-" + commandNameMaxLength + "s | %-" + commandValueMaxLength + "s |\n";
            String firstBar = "";
            String secondBar = "";
            for (idx = 0; idx < commandNameMaxLength; ++idx) {
                firstBar = firstBar + "-";
            }
            for (idx = 0; idx < commandValueMaxLength; ++idx) {
                secondBar = secondBar + "-";
            }
            buffer.append(String.format(formatTemplate, firstBar, secondBar));
            buffer.append(String.format(formatTemplate, "Command name", "Current value"));
            buffer.append(String.format(formatTemplate, firstBar, secondBar));
            for (Map.Entry entry : outputList) {
                buffer.append(String.format(formatTemplate, entry.getKey(), entry.getValue(), ""));
            }
            buffer.append(String.format(formatTemplate, firstBar, secondBar));
            buffer.append(String.format(formatTemplate, "Total attributes", outputList.size()));
        } else {
            buffer.append("No attributes match your search.");
        }
        return buffer.toString();
    }

    public boolean setAttributeCollectionBuffer(StringBuffer stringBuffer) throws Exception {
        BasicAuthClient client = new BasicAuthClient(this.ipmiInterfaceConfig);
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.ipmiInterfaceConfig.getIp()) + BIOS_ATTRIBUTE_URL_SUFFIX;
        int responseResult = client.send_https_patch(url, stringBuffer.toString(), "UTF-8");
        if (200 <= responseResult && responseResult <= 206) {
            return true;
        }
        if (responseResult == 404) {
            System.out.println("404 not found");
            return false;
        }
        this.printExtendedInfo(responseResult, client.getResponseString());
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void printExtendedInfo(int statusCode, String responseString) {
        if (400 <= statusCode && statusCode < 500) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                JsonNode node = mapper.readTree(responseString);
                JsonNode error = node.path("error");
                JsonNode extendInfo = error.path("@Message.ExtendedInfo");
                if (!extendInfo.isArray()) return;
                for (JsonNode l : extendInfo) {
                    JsonNode messageArgs = l.path("MessageArgs");
                    JsonNode message = l.findPath("Message");
                    System.out.println("Error: " + message.asText());
                    if (!messageArgs.isArray()) continue;
                    for (JsonNode m : messageArgs) {
                        System.out.println("Error  Argument: " + m.asText());
                    }
                }
                return;
            }
            catch (Exception e2) {
                System.out.println("...Failed to execute command, completion code " + statusCode);
                return;
            }
        } else {
            System.out.println("...Failed to execute command, completion code " + statusCode);
        }
    }

    private boolean setAttributeCollection(String attributeName, String attributeValue) throws Exception {
        int responseResult;
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.ipmiInterfaceConfig.getIp()) + BIOS_ATTRIBUTE_URL_SUFFIX;
        String formatTemplate = null;
        formatTemplate = attributeName.contains("(R)") && this.schemaHashMap.get(attributeName).getDisplayName().contains("(R)") ? this.replaceDoubleQuoteSymbol(attributeName) : this.replaceDoubleQuoteSymbol(this.revertNonAsciiSymbol(attributeName));
        formatTemplate = "{\"Attributes\":{\"" + formatTemplate + "\": %s}}";
        String patchBody = null;
        BIOSAttributeSchema schema = this.schemaHashMap.get(attributeName);
        int valueType = schema.getValueType();
        switch (valueType) {
            case 0: {
                try {
                    Integer.valueOf(attributeValue);
                    patchBody = String.format(formatTemplate, "\"" + schema.getConvertedEnumString(attributeValue) + "\"");
                }
                catch (Exception e2) {
                    patchBody = String.format(formatTemplate, "\"" + attributeValue + "\"");
                }
                break;
            }
            case 2: 
            case 4: {
                patchBody = String.format(formatTemplate, "\"" + attributeValue + "\"");
                break;
            }
            case 1: {
                patchBody = String.format(formatTemplate, schema.getConvertedBoolString(attributeValue));
                break;
            }
            case 3: {
                patchBody = String.format(formatTemplate, attributeValue);
                break;
            }
            default: {
                System.out.println("Value type " + valueType + " is undefined");
            }
        }
        BasicAuthClient client = new BasicAuthClient(this.ipmiInterfaceConfig);
        int n = responseResult = patchBody != null ? client.send_https_patch(url, patchBody, "UTF-8") : 406;
        if (200 <= responseResult && responseResult <= 206) {
            System.out.println("Done");
            return true;
        }
        if (responseResult == 404) {
            // empty if block
        }
        return false;
    }

    private Argument findLeafArgument(Argument currentArgument, String[] subPaths) {
        for (String path : subPaths) {
            String argName = this.replaceOrSymbol(path);
            Argument tempArgument = currentArgument.getArgument(argName);
            if (tempArgument == null) {
                Argument subArgument = new Argument(argName, argName, "");
                currentArgument.addNextArgument(subArgument);
                currentArgument = currentArgument.getArgument(argName);
                continue;
            }
            currentArgument = tempArgument;
        }
        return currentArgument;
    }

    private Argument createTargetArgument(BIOSAttributeSchema schema) {
        return new Argument(schema.getCommandName(), schema.getCommandName(), schema.getDescription(), new BIOSConfigurationGeneralCommand(schema.getAttributeName()));
    }

    public String convertNonAsciiSymbol(String value) {
        if (value.contains("\u00ae")) {
            return value.replaceAll("\u00ae", "(R)").replaceAll("[^\\p{ASCII}]", "");
        }
        return value;
    }

    public String revertNonAsciiSymbol(String value) {
        if (value.contains("(R)")) {
            return value.replaceAll("\\(R\\)", "\u00ae");
        }
        return value;
    }

    public String getShortenValue(String value) {
        if (value.length() < 40) {
            return value;
        }
        value = value.substring(0, 37) + "...";
        return value;
    }

    private String replaceDoubleQuoteSymbol(String value) {
        return value.replaceAll("\"", "\\\\\"");
    }

    private String replaceOrSymbol(String value) {
        return value.replaceAll("\\|", "/");
    }

    private String[] splitPath(String value) {
        if (value.contains("./")) {
            return value.replaceFirst("./", "").split("/");
        }
        return value.replaceFirst(".\\\\", "").split("\\\\");
    }

    private Map<String, Integer> getDisplayNameCounterMap(List<HashMap<String, String>> schemaList) {
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        for (HashMap<String, String> map : schemaList) {
            if (map.get("AttributeName") == null) continue;
            String displayName = map.get("DisplayName");
            String type = map.get("Type");
            if (displayName == null || type == null || type.equals("SubTitle") || type.equals("Goto") || type.equals("Text")) continue;
            String displayImpactName = displayName.replaceAll("\\s", "");
            if (counter.get(displayImpactName) != null) {
                counter.put(displayImpactName, counter.get(displayImpactName) + 1);
                continue;
            }
            counter.put(displayImpactName, 1);
        }
        return counter;
    }

    private String getCommandName(String attributeName, String displayName, boolean isDuplicated) {
        String name = null;
        name = isDuplicated ? (attributeName.startsWith(displayName) ? attributeName : displayName + "_" + attributeName) : displayName;
        return name;
    }
}

