/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.text.BIOSConfigurationBaseCommand;

public class BIOSConfigurationResetCommand
extends BIOSConfigurationBaseCommand {
    private boolean isReboot;

    @Override
    public boolean preValidate() {
        this.isReboot = false;
        if (super.getParameters() != null) {
            for (String param : super.getParameters()) {
                if (!param.equalsIgnoreCase("--reboot")) continue;
                this.isReboot = true;
            }
        }
        return super.preValidate();
    }

    @Override
    public void runCommand() throws Exception {
        if (!super.isCommandAvailable()) {
            return;
        }
        RedfishCommand.HTTP_CALLBACK callback = () -> {
            MOut.G(this).println("Done");
            MOut.G(this).println("Note: All BIOS attributes will be reset after next reboot");
        };
        this.statusCode = super.statusCodeHandler(callback, super.getHelper().resetBIOS(), "");
        if (this.isReboot) {
            IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
            this.sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilegeEx(this.config, ipmiChassisCommand);
            if (ipmiChassisCommand.reset()) {
                this.statusCode = 0;
            } else {
                this.statusCode = 149;
                MOut.G(this).println("reset fail");
            }
            if (this.sessionController != null) {
                this.sessionController.closeSession();
            }
        } else {
            MOut.G(this).println("Remind: Remember to reboot to proceed BIOS reset");
        }
    }
}

