/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.text.BIOSAttributeSchema;
import com.supermicro.redfish.text.BIOSConfigurationBaseCommand;
import com.supermicro.redfish.text.BIOSConfigurationHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class BIOSConfigurationSaveCommand
extends BIOSConfigurationBaseCommand {
    private int fileOption;
    private File file = null;
    private String filename = null;
    private Properties properties = null;
    private final int SAVE_MODE_DEFAULT = 0;
    private final int SAVE_MODE_PENDING = 1;
    private final int SAVE_MODE_PENDING_DIFF = 2;
    private final String DEFAULT_FILE_NAME = "biosConfiguration.properties";

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean preValidate() {
        block7: {
            block8: {
                this.filename = null;
                this.fileOption = 0;
                this.usage();
                if (null == this.parameters || this.parameters.length <= 0) break block8;
                this.filename = this.parameters[0];
                if (this.parameters.length > 1) {
                    if (this.parameters[1].equals("0")) {
                        this.fileOption = 0;
                        break block7;
                    } else if (this.parameters[1].equals("1")) {
                        this.fileOption = 1;
                        break block7;
                    } else {
                        if (!this.parameters[1].equals("2")) {
                            MOut.G(this).println("Invalid parameters");
                            return false;
                        }
                        this.fileOption = 2;
                    }
                }
                break block7;
            }
            this.filename = "biosConfiguration.properties";
        }
        if (!this.createFile(this.filename)) {
            MOut.G(this).println("Create file failed");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!super.isCommandAvailable()) {
            return;
        }
        boolean result = false;
        switch (this.fileOption) {
            case 1: {
                result = this.setPropertyFromSD();
                break;
            }
            case 2: {
                result = this.setPropertyFromDiffSD();
                break;
            }
            default: {
                result = this.setPropertyFromAttributes();
            }
        }
        if (result) {
            if (this.properties != null && !this.properties.isEmpty()) {
                this.writeFile();
                MOut.G(this).println("\"" + this.filename + "\" file saved");
            } else {
                MOut.G(this).println("No attributes saved to file");
            }
            this.statusCode = 0;
        } else {
            MOut.G(this).println("Failed");
            this.statusCode = 149;
        }
    }

    private boolean setPropertyFromAttributes() {
        block4: {
            BIOSConfigurationHelper helper = new BIOSConfigurationHelper(super.getConfig());
            Map<String, String> attributeHashMap = null;
            Map<String, BIOSAttributeSchema> schemaHashmap = null;
            try {
                attributeHashMap = helper.getAttributeMap();
                if (attributeHashMap == null) break block4;
                schemaHashmap = super.getHelper().getSchemaHashMap();
                if (schemaHashmap == null) {
                }
            }
            catch (Exception e2) {}
            break block4;
            TreeMap<String, String> treeMap = new TreeMap<String, String>(attributeHashMap);
            Set<String> keySet = treeMap.keySet();
            Iterator<String> ite = keySet.iterator();
            this.clearProperty();
            while (ite.hasNext()) {
                String key = ite.next().toString();
                String keyConveted = helper.convertNonAsciiSymbol(key);
                this.setProperty(schemaHashmap.get(keyConveted).getCommandName(), attributeHashMap.get(key));
            }
            return true;
        }
        return false;
    }

    private boolean setPropertyFromSD() {
        block4: {
            BIOSConfigurationHelper helper = new BIOSConfigurationHelper(super.getConfig());
            HashMap<String, String> sdHashmap = null;
            Map<String, BIOSAttributeSchema> schemaHashmap = null;
            try {
                sdHashmap = helper.getAttributeSDCollection();
                if (sdHashmap == null) break block4;
                schemaHashmap = super.getHelper().getSchemaHashMap();
                if (schemaHashmap == null) {
                }
            }
            catch (Exception e2) {}
            break block4;
            TreeMap<String, String> treeMap = new TreeMap<String, String>(sdHashmap);
            Set<String> keySet = treeMap.keySet();
            Iterator<String> ite = keySet.iterator();
            this.clearProperty();
            while (ite.hasNext()) {
                String key = ite.next().toString();
                String keyConveted = helper.convertNonAsciiSymbol(key);
                this.setProperty(schemaHashmap.get(keyConveted).getCommandName(), (String)sdHashmap.get(key));
            }
            return true;
        }
        return false;
    }

    private boolean setPropertyFromDiffSD() {
        block7: {
            BIOSConfigurationHelper helper = new BIOSConfigurationHelper(super.getConfig());
            HashMap<String, String> sdHashmap = null;
            Map<String, String> attributeHashMap = null;
            Map<String, BIOSAttributeSchema> schemaHashmap = null;
            try {
                sdHashmap = helper.getAttributeSDCollection();
                if (sdHashmap == null) break block7;
                schemaHashmap = super.getHelper().getSchemaHashMap();
                if (schemaHashmap == null) {
                }
            }
            catch (Exception e2) {}
            break block7;
            try {
                attributeHashMap = helper.getAttributeMap();
                if (attributeHashMap == null) {
                }
            }
            catch (Exception e3) {}
            break block7;
            TreeMap<String, String> treeMap = new TreeMap<String, String>(sdHashmap);
            Set<String> keySet = treeMap.keySet();
            Iterator<String> ite = keySet.iterator();
            this.clearProperty();
            while (ite.hasNext()) {
                String attributeValue;
                String key = ite.next().toString();
                String keyConveted = helper.convertNonAsciiSymbol(key);
                String sdValue = (String)sdHashmap.get(key);
                if (sdValue.equals(attributeValue = attributeHashMap.get(key))) continue;
                this.setProperty(schemaHashmap.get(keyConveted).getCommandName(), (String)sdHashmap.get(key));
            }
            return true;
        }
        return false;
    }

    private boolean createFile(String filename) {
        try {
            Files.deleteIfExists(Paths.get(filename, new String[0]));
        }
        catch (IOException e2) {
            return false;
        }
        this.file = new File(filename);
        return true;
    }

    private boolean setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (key == null || value == null) {
            return false;
        }
        this.properties.put(key, value);
        return true;
    }

    private void clearProperty() {
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    private boolean writeFile() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            if (this.properties != null) {
                this.properties.store(fileOutputStream, "BIOS Configuration");
            }
            fileOutputStream.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
        return true;
    }

    private void usage() {
        MOut.G(this).println("Usage: redfish biosConfiguration save [<filename> [option]]");
        MOut.G(this).println("Options:");
        MOut.G(this).println(" 0 - Save all current settings to file (default)");
        MOut.G(this).println(" 1 - Save all settings in the pending list to file");
        MOut.G(this).println(" 2 - Only save settings with different values from current BIOS in the pending list to file");
        MOut.G(this).println("");
    }
}

