/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import org.apache.http.Header;

public class CrashDumpGenerateCommand
extends RedfishCommand {
    public static final String DUMPGENERATE = "/redfish/v1/Oem/Supermicro/DumpService/Actions/SmcDumpService.CreateDump";

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid) || IPMIMessagingCommand.isH12RoTGUID(guid) || IPMIMessagingCommand.isH13GUID(guid) || IPMIMessagingCommand.isH13AST2600NonRoTGUID(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        String ip = RedfishHttpUtils.getUrlIP(this.config.getIp());
        BasicAuthClient bc = new BasicAuthClient(this.config);
        String dumpService = "https://" + ip + "/" + "/redfish/v1/Oem/Supermicro/DumpService/";
        int result = bc.send_https_get(dumpService);
        if (result == 404) {
            MOut.G(this).println("404 not found");
            this.statusCode = 153;
            return;
        }
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(bc.getResponseString());
            Header[] actions = node.path("Actions");
            if (actions == null) {
                MOut.G(this).println("This device is not supported");
                this.statusCode = 153;
                return;
            }
            try {
                JsonNode createDump = actions.path("#SmcDumpService.CreateDump");
                if (createDump.isNull()) {
                    MOut.G(this).println("This device is not supported");
                    this.statusCode = 153;
                    return;
                }
                JsonNode createDumpTarget = createDump.path("target");
                if (createDumpTarget.isNull()) {
                    MOut.G(this).println("This device is not supported");
                    this.statusCode = 153;
                    return;
                }
                String targetPath = createDumpTarget.textValue();
                if (targetPath == null) {
                    MOut.G(this).println("This device is not supported");
                    this.statusCode = 153;
                    return;
                }
            }
            catch (Exception e2) {
                MOut.G(this).println("This device is not supported");
                this.statusCode = 153;
                return;
            }
        }
        String url = "https://" + ip + "/" + DUMPGENERATE;
        result = bc.send_https_get("https://" + ip + "/" + "/redfish/v1/Oem/Supermicro/DumpService/");
        if (result == 404) {
            MOut.G(this).println("Not supported device");
            this.statusCode = 153;
            return;
        }
        String body = "{\"DumpType\":\"Host Dump\"}";
        result = bc.send_https_post(url, body);
        if (result >= 200 && result <= 210) {
            for (Header header : bc.getResponseHeader()) {
                if (!header.getName().trim().equalsIgnoreCase("Location")) continue;
                url = "https://" + this.config.getIp() + header.getValue().trim();
                break;
            }
            bc.send_https_get(url);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(bc.getResponseString());
            JsonNode task = node.path("Task");
            url = "https://" + this.config.getIp() + task.asText();
            MOut.G(this).println("====================================");
            MOut.G(this).println("Generating file");
            MOut.G(this).println("====================================");
            int currentProgress = 0;
            int lastProgress = 0;
            int progressRetry = 0;
            while (currentProgress != 100) {
                try {
                    bc.send_https_get(url);
                    node = mapper.readTree(bc.getResponseString());
                    JsonNode percent = node.path("PercentComplete");
                    currentProgress = percent.asInt();
                    if (currentProgress > lastProgress) {
                        for (int i2 = 0; i2 < (currentProgress - lastProgress) / 2; ++i2) {
                            MOut.G(this).print(">");
                        }
                        lastProgress = currentProgress;
                    }
                    Thread.sleep(1000L);
                    progressRetry = 0;
                }
                catch (Exception e3) {
                    if (currentProgress != 0) {
                        if (progressRetry == 5) break;
                        ++progressRetry;
                        continue;
                    }
                    throw e3;
                }
            }
            MOut.G(this).println("100%");
            MOut.G(this).println("Done");
            this.statusCode = 0;
        } else {
            this.printFailMessage(result, bc.getResponseString());
            this.statusCode = 149;
        }
    }
}

