/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.MELListCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;

public class EventListCommand
extends RedfishCommand {
    public static final String HEL_URI_SUFFIX = "/redfish/v1/Systems/1/LogServices/Log1/Entries/";
    public static final String MEL_URI_SUFFIX = "/redfish/v1/Managers/1/LogServices/Log1/Entries/";
    public static final int EVENT_LOG_HEALTH = 0;
    public static final int EVENT_LOG_MAINTENANCE = 1;
    public static final String HEL_NODE_ID = "Id";
    public static final String HEL_NODE_SEVERITY = "Severity";
    public static final String HEL_NODE_DATETIME = "Created";
    public static final String HEL_NODE_SENSOR_TYPE = "SensorType";
    public static final String HEL_NODE_SENSOR_TYPE_OEM = "OemSensorType";
    public static final String HEL_NODE_MESSAGE = "Message";
    public static final String HEL_NODE_ENTRY_CODE = "EntryCode";
    public static final String MEL_NODE_ID = "Id";
    public static final String MEL_NODE_SEVERITY = "Severity";
    public static final String MEL_NODE_DATETIME = "Created";
    public static final String MEL_NODE_INTERFACE = "Oem/Supermicro/Interface";
    public static final String MEL_NODE_USER = "Oem/Supermicro/User";
    public static final String MEL_NODE_SOURCE = "Oem/Supermicro/Source";
    public static final String MEL_NODE_MESSAGE_X11 = "Description";
    public static final String MEL_NODE_MESSAGE_X12 = "Message";
    private int eventType;
    private int beginIndex;
    private int endIndex;
    private int lastEvents;
    private int offsetYear;
    private int offsetMonth;
    private int offsetDay;
    private RedfishHttpUtils utils = new RedfishHttpUtils();

    public EventListCommand() {
    }

    public EventListCommand(int type) {
        this.eventType = type;
    }

    @Override
    public boolean preValidate() {
        this.reset();
        if (null != this.parameters) {
            for (int index = 0; index < this.parameters.length; ++index) {
                if (index != this.parameters.length - 1) {
                    if (this.parameters[index].equals("-y")) {
                        if (!this.setOffsetYear(this.parameters[index + 1])) {
                            MOut.G(this).println("Parameter behind -y should be a positive integer.");
                            return false;
                        }
                        ++index;
                        continue;
                    }
                    if (this.parameters[index].equals("-m")) {
                        if (!this.setOffsetMonth(this.parameters[index + 1])) {
                            MOut.G(this).println("Parameter behind -m should be a positive integer.");
                            return false;
                        }
                        ++index;
                        continue;
                    }
                    if (this.parameters[index].equals("-d")) {
                        if (!this.setOffsetDay(this.parameters[index + 1])) {
                            MOut.G(this).println("Parameter behind -d should be a positive integer.");
                            return false;
                        }
                        ++index;
                        continue;
                    }
                }
                try {
                    switch (index) {
                        case 0: {
                            this.lastEvents = Integer.valueOf(this.parameters[index]);
                            this.beginIndex = -1;
                            this.endIndex = -1;
                            break;
                        }
                        case 1: {
                            this.lastEvents = -1;
                            this.beginIndex = Integer.valueOf(this.parameters[index - 1]);
                            this.endIndex = Integer.valueOf(this.parameters[index]);
                        }
                    }
                }
                catch (NumberFormatException e2) {
                    MOut.G(this).println("Parameter format is invalid.");
                    this.statusCode = 147;
                    return false;
                }
                if (this.endIndex >= this.beginIndex) continue;
                MOut.G(this).println("Parameter range is invalid.");
                this.statusCode = 147;
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid;
        if (this.eventType == 1 && IPMIMessagingCommand.isBeforeX12(guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp()))) {
            ISessionController sessionController = null;
            MELListCommand command = new MELListCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.config, command, 10);
            if (sessionController == null) {
                MOut.G(this).println("Session create failed");
                this.statusCode = 149;
                return;
            }
            this.statusCode = this.isEventFilter() ? command.runCommand(this) : command.runCommand(this.beginIndex, this.endIndex, this.lastEvents);
            sessionController.closeSession();
            return;
        }
        int result = this.utils.sendRedfishGet(super.getConfig(), this.getRedfishURL(this.eventType));
        if (result == 200) {
            this.outputEvents(this.utils.getEntryList());
            this.statusCode = 0;
        } else if (result == 404) {
            MOut.G(this).println(this.getEventType() + " is not supported on this device");
            this.statusCode = 153;
        } else {
            this.printFailMessage(result, this.utils.getRedfishResponse());
            MOut.G(this).println("Failed");
            this.statusCode = 149;
        }
    }

    public String getRedfishURL(int type) {
        String suffixURL = type == 0 ? HEL_URI_SUFFIX : MEL_URI_SUFFIX;
        return "https://" + RedfishHttpUtils.getUrlIP(super.getConfig().getIp()) + suffixURL;
    }

    private void outputEvents(List<HashMap<String, String>> entryList) {
        this.utils.reviseIndex(this.beginIndex, this.endIndex, this.lastEvents);
        int rIndex = this.utils.getRightIndex();
        int lIndex = this.utils.getLeftIndex();
        if (entryList.size() == 0) {
            System.out.println(this.getEventType() + " empty");
        } else if (rIndex == lIndex) {
            System.out.println("No events in the range");
        } else {
            this.outputMaintenanceEvents(entryList, lIndex, rIndex);
        }
    }

    private void outputMaintenanceEvents(List<HashMap<String, String>> entryList, int leftIndex, int rightIndex) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean isEventFilterOn = this.isEventFilter();
        for (int index = leftIndex; index < rightIndex; ++index) {
            String datetime = this.utils.convertDatetimeFormat(entryList.get(index).get("Created"));
            if (isEventFilterOn && this.isDateOutOfRange(datetime, "-")) continue;
            stringBuilder.setLength(0);
            stringBuilder.append("--------------------------------------------------------------------");
            stringBuilder.append("\n");
            stringBuilder.append("Event:");
            stringBuilder.append(entryList.get(index).get("Id"));
            stringBuilder.append(" Time:");
            stringBuilder.append(datetime);
            stringBuilder.append(" Severity:");
            stringBuilder.append(entryList.get(index).get("Severity"));
            stringBuilder.append(" Interface:");
            stringBuilder.append(entryList.get(index).get(MEL_NODE_INTERFACE));
            stringBuilder.append(" User:");
            stringBuilder.append(entryList.get(index).get(MEL_NODE_USER));
            stringBuilder.append("\n");
            stringBuilder.append("Source:");
            stringBuilder.append(entryList.get(index).get(MEL_NODE_SOURCE));
            stringBuilder.append(" Desc:");
            stringBuilder.append(entryList.get(index).get("Message") != null ? entryList.get(index).get("Message") : entryList.get(index).get(MEL_NODE_MESSAGE_X11));
            System.out.println(stringBuilder.toString());
        }
        if (isEventFilterOn && stringBuilder.length() <= 0) {
            System.out.println("There are no event in last " + this.getDateUnit());
        }
    }

    private String getEventType() {
        return this.eventType == 0 ? "HEL" : "MEL";
    }

    public boolean isDateOutOfRange(String datetime, String seperator) {
        String datetimeSeprator = " ";
        String datetimeFormat = "yyyy" + seperator + "MM" + seperator + "dd";
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(datetimeFormat);
        String current = formatter.format(LocalDateTime.now());
        String value = datetime;
        if (value.contains(" ")) {
            value = value.split(" ")[0];
        }
        LocalDate eventDate = null;
        LocalDate currentDate = null;
        try {
            eventDate = LocalDate.parse(value, formatter);
            currentDate = LocalDate.parse(current, formatter);
        }
        catch (RuntimeException ex) {
            return true;
        }
        return !(eventDate == null || currentDate == null || this.offsetYear > 0 && ChronoUnit.YEARS.between(eventDate, currentDate) < (long)this.offsetYear || this.offsetMonth > 0 && ChronoUnit.MONTHS.between(eventDate, currentDate) < (long)this.offsetMonth || this.offsetDay > 0 && ChronoUnit.DAYS.between(eventDate, currentDate) < (long)this.offsetDay);
        {
        }
    }

    public String getDateUnit() {
        if (this.offsetYear > 0) {
            return this.offsetYear + " year" + (this.offsetYear > 1 ? "s" : "");
        }
        if (this.offsetMonth > 0) {
            return this.offsetMonth + " month" + (this.offsetMonth > 1 ? "s" : "");
        }
        return this.offsetDay + " day" + (this.offsetDay > 1 ? "s" : "");
    }

    public void reset() {
        this.beginIndex = -1;
        this.endIndex = -1;
        this.lastEvents = -1;
        this.offsetYear = -1;
        this.offsetMonth = -1;
        this.offsetDay = -1;
    }

    public boolean isEventFilter() {
        return this.offsetYear > 0 || this.offsetMonth > 0 || this.offsetDay > 0;
    }

    public boolean setOffsetYear(String value) {
        try {
            this.offsetYear = Integer.valueOf(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return this.offsetYear > 0;
    }

    public boolean setOffsetMonth(String value) {
        try {
            this.offsetMonth = Integer.valueOf(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return this.offsetMonth > 0;
    }

    public boolean setOffsetDay(String value) {
        try {
            this.offsetDay = Integer.valueOf(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return this.offsetDay > 0;
    }
}

