/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import java.net.InetAddress;

public class FirmwareInventoryInstallCommand
extends RedfishCommand {
    String action = "";
    String target = "";

    @Override
    public boolean preValidate() {
        block9: {
            if (this.parameters == null || this.parameters.length != 2) {
                this.printUsage();
                return false;
            }
            if (this.parameters[0].equalsIgnoreCase("BMC")) {
                this.target = "/redfish/v1/Managers/1";
            } else if (this.parameters[0].equalsIgnoreCase("BIOS")) {
                this.target = "/redfish/v1/Systems/1";
            } else {
                MOut.G(this).println("Target must be either BMC or BIOS");
                return false;
            }
            try {
                int a2 = Integer.parseInt(this.parameters[1]);
                if (a2 == 0) {
                    this.action = "Recover";
                    break block9;
                }
                if (a2 == 1) {
                    this.action = "UpdateGolden";
                    break block9;
                }
                MOut.G(this).println("Action must be 0 or 1");
                this.printUsage();
                return false;
            }
            catch (NumberFormatException e2) {
                this.printUsage();
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        String ip = this.config.getIp();
        String id = this.config.getUserName();
        String pw = this.config.getPassword();
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(ip);
        if (IPMIMessagingCommand.isBeforeX12(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
        try {
            this.sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilegeEx(this.config, ipmiChassisCommand);
        }
        catch (IPMIException ex) {
            MOut.G(this).println("Can not open IPMI session");
            this.statusCode = 146;
            return;
        }
        if (this.parameters[0].equalsIgnoreCase("BIOS") && ipmiChassisCommand.isPowerOn()) {
            MOut.G(this).println("Update BIOS requires system power off");
            this.statusCode = 149;
            return;
        }
        IPMIOEMCommand ipmioemCommand = new IPMIOEMCommand(ipmiChassisCommand.getIPMIInterface());
        try {
            if (!ipmioemCommand.isBoardProvision()) {
                MOut.G(this).println("The board had not been provisioned");
            }
        }
        catch (IPMIException iPMIException) {
            // empty catch block
        }
        this.sessionController.closeSession();
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/UpdateService/" + "Actions/" + "Oem/" + "SmcUpdateService.Install";
        BasicAuthClient bc = new BasicAuthClient(this.config);
        String bodyString = "{\"Targets\":[\"" + this.target + "\"],\n\"InstallOptions\":[\"" + this.action + "\"]}";
        int result = bc.send_https_post(url, bodyString);
        if (result == 404) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        if (result >= 200 && result <= 210) {
            long start = System.currentTimeMillis();
            if (this.parameters[0].equalsIgnoreCase("BIOS")) {
                MOut.G(this).println("Command success. BIOS update is starting...");
                MOut.G(this).println("Please note that BMC function may be limited during update");
            } else {
                MOut.G(this).println("Command success. BMC may be disconnected for updating.");
                MOut.G(this).println("Waiting for BMC to recover");
            }
            int retry = 180;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (retry > 0) {
                InetAddress address = InetAddress.getByName(this.config.getIp());
                boolean recover = address.isReachable(3000);
                if (recover) {
                    try {
                        Thread.sleep(25000L);
                        if (address.isReachable(3000)) break;
                        recover = false;
                    }
                    catch (Exception ex) {
                        recover = false;
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --retry;
            }
            if (retry == 0) {
                MOut.G(this).println("BMC IP is unavailable currently. Please check after 2 minutes later");
            } else {
                MOut.G(this).println("Done");
                this.printTimeString("\nUpdate Time", System.currentTimeMillis() - start);
            }
            this.statusCode = 0;
            return;
        }
        this.printFailMessage(result, bc.getResponseString());
        MOut.G(this).println("Failed");
        this.statusCode = 149;
    }

    public void printUsage() {
        MOut.G(this).println("Usage: redfish firmwareInventory install <Target> <Action>");
        MOut.G(this).println("Target:");
        MOut.G(this).println("        BMC");
        MOut.G(this).println("        BIOS");
        MOut.G(this).println("Action:");
        MOut.G(this).println("        0: Recover");
        MOut.G(this).println("        1: UpdateGolden");
    }

    public void printTimeString(String label, long diffMillis) {
        if (diffMillis == 0L) {
            return;
        }
        long diffDays = diffMillis / 86400000L;
        long leftHours = diffMillis % 86400000L / 3600000L;
        long leftMins = diffMillis % 86400000L % 3600000L / 60000L;
        long leftSecs = diffMillis % 86400000L % 3600000L % 60000L / 1000L;
        MOut.G(this).println(label + ": " + leftMins + " min " + leftSecs + " sec(s)");
    }
}

