/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;

public class IPCtrlEditCommand
extends RedfishTokenCommand {
    int index;

    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length != 4) {
            this.printUsage();
            return false;
        }
        if (!this.parameters[3].equals("0") && !this.parameters[3].equals("1")) {
            this.printUsage();
            return false;
        }
        try {
            this.index = Integer.parseInt(this.parameters[0]);
            if (this.index < 1 || this.index > 10) {
                MOut.G(this).print("Rule number out of limit");
                return false;
            }
        }
        catch (Exception e2) {
            MOut.G(this).print("Rule number error");
            this.printUsage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        String ip = RedfishHttpUtils.getUrlIP(this.config.getIp());
        String url = "https://" + ip + "/redfish/v1/Managers/1/" + "Oem/" + "Supermicro/" + "IPAccessControl/";
        int result = this.sessionLoginClient.send_https_get(url);
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(this.sessionLoginClient.getResponseString());
            JsonNode ServiceEnabled = node.path("ServiceEnabled");
            boolean isEnable = ServiceEnabled.asBoolean();
            if (isEnable) {
                url = "https://" + ip + "/redfish/v1/Managers/1/" + "Oem/" + "Supermicro/" + "IPAccessControl/" + "FilterRules" + "/" + this.index;
                String policy = this.parameters[3].equals("0") ? "Drop" : "Accept";
                String bodyString = "{\"Address\": \"" + this.parameters[1] + "\", \"PrefixLength\": " + this.parameters[2] + ", \"Policy\": \"" + policy + "\"}";
                int result2 = this.sessionLoginClient.send_https_patch(url, bodyString);
                if (result2 >= 200 && result2 <= 210) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                } else {
                    this.printFailMessage(result2, this.sessionLoginClient.getResponseString());
                    this.statusCode = 149;
                }
            } else {
                MOut.G(this).println("IP Access Control is disabled");
                this.statusCode = 149;
            }
        } else {
            this.printFailMessage(result, this.sessionLoginClient.getResponseString());
            this.statusCode = 149;
        }
    }

    public void printUsage() {
        MOut.G(this).println("Usage: redfish ipctrl edit <rule no> <IP> <prefix> <policy>");
        MOut.G(this).println("       policy :  Accept=1  Drop=0");
    }
}

