/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishActAPI;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;
import java.util.ArrayList;

public class LDAPAddAddressCommand
extends RedfishTokenCommand {
    int ssl = 0;

    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length != 2 && this.parameters.length != 3) {
            this.printUsage();
            return false;
        }
        try {
            int port = Integer.parseInt(this.parameters[1]);
            if (port < 1 || port > 65535) {
                MOut.G(this).println("Port number must be between 1 and 65535");
                return false;
            }
        }
        catch (NumberFormatException e2) {
            MOut.G(this).println("Port number must be between 1 and 65535");
            return false;
        }
        if (this.parameters.length == 3) {
            try {
                this.ssl = Integer.parseInt(this.parameters[2]);
                if (this.ssl != 0 && this.ssl != 1) {
                    MOut.G(this).println("SSL must be 0 or 1");
                    return false;
                }
            }
            catch (NumberFormatException e3) {
                MOut.G(this).println("SSL must be 0 or 1");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid) && !IPMIMessagingCommand.isB3ST1GUID(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        RedfishActAPI api = new RedfishActAPI(this.config);
        if (!api.checkIfDCMSSingleExist()) {
            MOut.G(this).println("Login failed. DCMS-single may need to be activated for this device.");
            MOut.G(this).println("Or user credentials may be wrong.");
            this.statusCode = 155;
            return;
        }
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/AccountService/";
        int result = this.sessionLoginClient.send_https_get(url);
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(this.sessionLoginClient.getResponseString());
            JsonNode LDAP = node.path("LDAP");
            JsonNode ServiceEnabled = LDAP.path("ServiceEnabled");
            JsonNode ServiceAddress = LDAP.path("ServiceAddresses");
            boolean isEnable = ServiceEnabled.asBoolean();
            if (isEnable) {
                ArrayList<String> list = new ArrayList<String>();
                if (ServiceAddress.isArray()) {
                    if (ServiceAddress.size() == 3) {
                        MOut.G(this).println("Address list can only support up to 3 server addresses");
                        this.statusCode = 149;
                        return;
                    }
                    for (int i2 = 0; i2 < ServiceAddress.size(); ++i2) {
                        list.add(ServiceAddress.get(i2).asText());
                    }
                }
                String title = this.ssl == 0 ? "ldap://" : "ldaps://";
                String source = title + this.parameters[0] + ":" + this.parameters[1];
                list.add(source);
                String body = "{\"LDAP\": {\"ServiceAddresses\":[";
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    body = body + "\"" + (String)list.get(i3) + "\",";
                    if (i3 != list.size() - 1) continue;
                    body = body.substring(0, body.length() - 2);
                }
                result = this.sessionLoginClient.send_https_patch(url, body = body + "\"]}}");
                if (result < 200 || result > 210) {
                    MOut.G(this).println("Action failed. ErrorCode:" + result);
                    this.statusCode = 149;
                    return;
                }
            } else {
                MOut.G(this).println("LDAP is disabled");
                this.statusCode = 149;
                return;
            }
            MOut.G(this).println("Done");
            this.statusCode = 0;
        } else {
            MOut.G(this).println("Fail to read LDAP information. ErrorCode:" + result);
            this.statusCode = 149;
        }
    }

    public void printUsage() {
        MOut.G(this).println("Usage: redfish accountService ldap addAddress <IP> <Port> [SSL]");
        MOut.G(this).println("       For SSL : default=0, 1=ldaps://, 0=ldap://");
    }
}

