/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishActAPI;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;

public class LDAPBindPasswordCommand
extends RedfishCommand {
    private String bindPassword = null;

    @Override
    public boolean preValidate() {
        if (this.parameters != null) {
            this.bindPassword = this.parameters[0];
            return true;
        }
        MOut.G(this).println("Bind password is empty");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid) && !IPMIMessagingCommand.isB3ST1GUID(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        RedfishActAPI api = new RedfishActAPI(this.config);
        if (!api.checkIfDCMSSingleExist()) {
            MOut.G(this).println("Login failed. DCMS-single may need to be activated for this device.");
            MOut.G(this).println("Or user credentials may be wrong.");
            this.statusCode = 155;
            return;
        }
        RedfishHttpUtils utils = new RedfishHttpUtils();
        BasicAuthClient bc = new BasicAuthClient(this.config);
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/AccountService/";
        int result = bc.send_https_get(url);
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(bc.getResponseString());
            JsonNode LDAP = node.path("LDAP");
            JsonNode ServiceEnabled = LDAP.path("ServiceEnabled");
            boolean isEnable = ServiceEnabled.asBoolean();
            if (isEnable) {
                RedfishCommand.HTTP_CALLBACK callback = () -> MOut.G(this.getOriginalParser()).println("Done");
                String body = "{\"LDAP\":{\"Authentication\":{\"Password\": \"" + this.bindPassword + "\"}}}";
                int httpStatusCode = utils.sendRedfishPatch(this.getConfig(), url, body);
                this.statusCode = this.statusCodeHandler(callback, httpStatusCode, utils.getRedfishResponse());
                return;
            }
            MOut.G(this).println("LDAP Service is disabled");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Fail to read LDAP information. ErrorCode:" + result);
        this.statusCode = 149;
    }
}

