/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.kvm.authentication.KVMRedfishState;
import com.supermicro.ipmi.kvm.authentication.KVMSessionConnection;
import com.supermicro.ipmi.text.LicenseManager;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import java.awt.Desktop;
import java.io.InputStream;
import java.net.URI;

public class RedfishHTML5KVMCommand
extends RedfishCommand {
    @Override
    public void runCommand() throws Exception {
        int kvmInterface = -1;
        boolean isGetKvmInterface = false;
        if (this.parameters != null && this.parameters.length > 0) {
            if ("-switchOnlyJava".equalsIgnoreCase(this.parameters[0].trim())) {
                kvmInterface = 0;
            } else if ("-switchOnlyHTML5".equalsIgnoreCase(this.parameters[0].trim())) {
                kvmInterface = 1;
            } else if ("-status".equalsIgnoreCase(this.parameters[0].trim())) {
                isGetKvmInterface = true;
            } else {
                MOut.G(this).println("Usage: redfish kvm [options]");
                MOut.G(this).println("switchOptions:");
                MOut.G(this).println("-----------------------------------------------------");
                MOut.G(this).println("           -switchOnlyJava : switch to Java interface ");
                MOut.G(this).println("           -switchOnlyHTML5: switch to HTML5 interface");
                MOut.G(this).println("           -status: get current KVM interface");
                MOut.G(this).println("Note: It won't launch KVM when using the option");
                this.statusCode = 147;
                return;
            }
        }
        byte[] guid = IPMIMessagingCommand.getSystemGUIDbyConfig(this.config);
        KVMSessionConnection kvmSession = new KVMSessionConnection(this.config.getIp(), this.config.getUserName(), this.config.getPassword(), guid);
        if (isGetKvmInterface) {
            kvmInterface = kvmSession.getKVMInterface();
            String kvmInterfaceStr = "";
            switch (kvmInterface) {
                case 0: {
                    kvmInterfaceStr = "JAVA-plugin";
                    this.statusCode = 0;
                    break;
                }
                case 1: {
                    kvmInterfaceStr = "HTML5";
                    this.statusCode = 0;
                    break;
                }
                default: {
                    this.statusCode = 148;
                    kvmInterfaceStr = "Can't check the current kvm interface";
                }
            }
            MOut.G(this).println("Current KVM interface: " + kvmInterfaceStr);
            return;
        }
        if (kvmInterface > -1) {
            boolean switchResult = kvmSession.switchKVMInterface(kvmInterface);
            if (!switchResult) {
                this.statusCode = 149;
                MOut.G(this).println("Switch fail");
            } else {
                this.statusCode = 0;
                MOut.G(this).println("Done");
            }
            return;
        }
        IPMIMessagingCommand command = new IPMIMessagingCommand(null);
        ISessionController controller = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilegeEx(this.config, command);
        LicenseManager lm = new LicenseManager(command.getIPMIInterface(), this.config);
        if (this.config.getPrivilege() < 3) {
            MOut.G(this).println(GlobalDefine.completionCodeString.get("D4").toString());
            this.statusCode = 148;
            controller.closeSession();
            return;
        }
        if (IPMIMessagingCommand.isHGIMEZZGUID(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            controller.closeSession();
            return;
        }
        if (IPMIMessagingCommand.isBeforeX12(guid) && !lm.checkIfDCMSLicenseExist() && this.config.getPrivilege() == 4) {
            MOut.G(this).println("DCMS-single needs to be activated for this device");
            this.statusCode = 155;
            controller.closeSession();
            return;
        }
        controller.closeSession();
        boolean switchResult = kvmSession.switchKVMInterface(1);
        if (!switchResult) {
            this.statusCode = 149;
            return;
        }
        String root = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp());
        KVMRedfishState kvmRedfishState = kvmSession.getKvmRedfishState();
        if (kvmRedfishState != null && kvmRedfishState.getCurrentInterface() == 1 && kvmRedfishState.getKvmURI() != null) {
            String kvmRUI = root + kvmRedfishState.getKvmURI();
            this.openKVM(kvmRUI);
            return;
        }
        BasicAuthClient bc = new BasicAuthClient(this.config);
        String url = root + "/redfish/v1/Managers/1/";
        int result = bc.send_https_get(url);
        if (result == 404) {
            MOut.G(this).println("404 not found");
            this.statusCode = 153;
            return;
        }
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(bc.getResponseString());
            JsonNode oem = node.path("Oem");
            JsonNode supermicro = oem.path("Supermicro");
            JsonNode ikvm = supermicro.path("IKVM");
            JsonNode ikvmOdataId = ikvm.path("@odata.id");
            String ikvmOdataIdValue = ikvmOdataId.textValue();
            int KVMResult = bc.send_https_get(root + ikvmOdataIdValue);
            if (KVMResult >= 200 && KVMResult <= 210) {
                node = mapper.readTree(bc.getResponseString());
                String uri = node.path("URI").textValue();
                String kvmRUI = root + uri;
                this.openKVM(kvmRUI);
            } else {
                this.printFailMessage(KVMResult, bc.getResponseString());
                this.statusCode = 149;
            }
        } else {
            this.printFailMessage(result, bc.getResponseString());
            this.statusCode = 149;
        }
    }

    void openKVM(String kvmRUI) {
        block5: {
            try {
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    Desktop.getDesktop().browse(new URI(kvmRUI));
                    MOut.G(this).println("Done");
                    break block5;
                }
                InputStream inStream = null;
                inStream = Runtime.getRuntime().exec(new String[]{"which", "xdg-open"}).getInputStream();
                if (null != inStream && inStream.read() != -1) {
                    Runtime.getRuntime().exec(new String[]{"xdg-open", kvmRUI});
                    inStream.close();
                    MOut.G(this).println("Done");
                    break block5;
                }
                MOut.G(this).println("Can't launch HTML version KVM in this environment due to no available browser found");
                this.statusCode = 149;
                if (null != inStream) {
                    inStream.close();
                }
                return;
            }
            catch (Exception e2) {
                MOut.G(this).println("Open KVM exception " + e2.getMessage());
                this.statusCode = 149;
                return;
            }
        }
        this.statusCode = 0;
    }
}

