/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.SMTPRedfishHelper;
import java.util.HashMap;

public class SMTPServerAddressCommand
extends RedfishCommand {
    private String address = null;

    @Override
    public boolean preValidate() {
        this.address = null;
        if (this.parameters != null) {
            if (SMTPRedfishHelper.isValidServerAddress(this.parameters[0]) || IPMILanCommand.isValidateDomain(this.parameters[0])) {
                this.address = this.parameters[0];
            } else {
                MOut.G(this).println("Server Address is invalid");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!SMTPRedfishHelper.isSupportedRedfishSMTP(this.config)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        RedfishHttpUtils utils = new RedfishHttpUtils();
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/EventService";
        if (this.address == null) {
            RedfishCommand.HTTP_CALLBACK callback = () -> {
                HashMap<String, String> entryMap = utils.getEntry();
                MOut.G(this.getOriginalParser()).println(entryMap.get("SMTP/ServerAddress"));
            };
            int httpStatusCode = utils.sendRedfishGet(this.getConfig(), url);
            this.statusCode = this.statusCodeHandler(callback, httpStatusCode, utils.getRedfishResponse());
        } else {
            RedfishCommand.HTTP_CALLBACK callback = () -> MOut.G(this.getOriginalParser()).println("Done");
            String body = utils.getPatchBody(super.getConfig(), url);
            body = utils.updateEntryValue(body, "SMTP/ServerAddress", this.address);
            int httpStatusCode = utils.sendRedfishPatch(super.getConfig(), url, body);
            this.statusCode = this.statusCodeHandler(callback, httpStatusCode, utils.getRedfishResponse());
        }
    }
}

