/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.SNMPBaseCommand;
import java.util.HashMap;

public class SNMPv3AuthCommand
extends SNMPBaseCommand {
    private int status;

    @Override
    public boolean preValidate() {
        if (super.getParameters() != null && super.getParameters().length >= 1) {
            try {
                this.status = Integer.valueOf(super.getParameters()[0]);
                if (0 <= this.status && this.status <= 2) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        } else {
            return true;
        }
        MOut.G(this).println("Invalid parameters");
        this.usage();
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isProtocolSupported()) {
            return;
        }
        RedfishHttpUtils utils = new RedfishHttpUtils();
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/Managers/1/NetworkProtocol";
        if (super.getParameters() == null) {
            int result = utils.sendRedfishGet(this.config, url);
            RedfishCommand.HTTP_CALLBACK callback = () -> {
                HashMap<String, String> map = utils.getEntry();
                String value = map.get("SNMP/AuthenticationProtocol");
                String valueStr = this.getProtocolAbbr(value);
                MOut.G(this).println("SNMPv3 authentication protocol is " + (valueStr.isEmpty() ? "not set" : valueStr));
                MOut.G(this).println("");
                this.usage();
            };
            this.statusCode = this.statusCodeHandler(callback, result, utils.getRedfishResponse());
        } else {
            if (!this.isProtocolEnabled(utils, "SNMP/ProtocolEnabled") || !this.isProtocolEnabled(utils, "SNMP/EnableSNMPv3")) {
                return;
            }
            String node = "SNMP/AuthenticationProtocol".replace("SNMP/", "");
            String protocol = null;
            protocol = this.status == 0 ? "HMAC_MD5" : (this.status == 1 ? "HMAC_SHA96" : SNMP_COMMONE_PROTOCOL_ACCOUNT);
            String requestBody = "{\"SNMP\": {\"" + node + "\": \"" + protocol + "\"}}";
            RedfishCommand.HTTP_CALLBACK callback = () -> MOut.G(this).println("Done");
            int result = utils.sendRedfishPatch(this.config, url, requestBody);
            this.statusCode = this.statusCodeHandler(callback, result, utils.getRedfishResponse());
        }
    }

    private void usage() {
        MOut.G(this).println("Usage: redfish eventService snmp snmpv3 authentication [mode]\nmode:\n " + SNMP_AUTH_PROTOCOL_ABBR_MD5 + "     : 0\n " + SNMP_AUTH_PROTOCOL_ABBR_SHA + "     : 1\n " + SNMP_COMMONE_PROTOCOL_ACCOUNT + " : 2");
    }
}

