/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text.scc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;

public class SCCCheckingChassisCommand
extends RedfishTokenCommand {
    @Override
    public void runCommand() throws Exception {
        String ip = RedfishHttpUtils.getUrlIP(this.config.getIp());
        String url = "https://" + ip + "/redfish/v1/Chassis/1/";
        int result = this.sessionLoginClient.send_https_get(url);
        if (result < 200 || result > 210) {
            MOut.G(this).println("redfish/v1/Chassis/1 connection failed");
            this.statusCode = 149;
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(this.sessionLoginClient.getResponseString());
        JsonNode asset = node.path("AssetTag");
        JsonNode uid = node.path("IndicatorLED");
        JsonNode serialNumber = node.path("SerialNumber");
        MOut.G(this).println("---------------------------------------------------------------------------");
        String formatTemplate = " %-25s | %-45s |\n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(formatTemplate, "AssetTag", asset.asText()));
        fStr.append(String.format(formatTemplate, "SerialNumber", serialNumber.asText()));
        fStr.append(String.format(formatTemplate, "IndicatorLED", uid.asText()));
        MOut.G(this).print(fStr.toString());
        MOut.G(this).println("---------------------------------------------------------------------------");
        this.statusCode = 0;
    }
}

