/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text.scc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;

public class SCCCheckingGPUCommand
extends RedfishTokenCommand {
    @Override
    public void runCommand() throws Exception {
        JsonNode oemSupermicro;
        JsonNode oem;
        String manufactureVender;
        JsonNode model;
        JsonNode gpuVendor;
        JsonNode manufacturer;
        JsonNode health;
        JsonNode state;
        JsonNode status;
        JsonNode item;
        JsonNode device;
        StringBuffer fStr;
        StringBuffer fStr2;
        JsonNode maxspeed;
        JsonNode manufacturer2;
        JsonNode type;
        JsonNode fwVersion;
        JsonNode serialNumber;
        JsonNode partNumber;
        JsonNode model2;
        JsonNode health2;
        JsonNode state2;
        JsonNode status2;
        JsonNode pnode;
        int result2;
        String formatTemplate;
        JsonNode member;
        JsonNode node;
        ObjectMapper mapper;
        String ip = RedfishHttpUtils.getUrlIP(this.config.getIp());
        int gpuCount = 0;
        String url = "https://" + ip + "/redfish/v1/Systems/1/" + "Processors";
        int result = this.sessionLoginClient.send_https_get(url);
        if (result >= 200 && result <= 210) {
            mapper = new ObjectMapper();
            node = mapper.readTree(this.sessionLoginClient.getResponseString());
            member = node.path("Members");
            formatTemplate = " %-25s | %-45s |\n";
            if (member.isArray()) {
                for (JsonNode l : member) {
                    if (!l.path("@odata.id").asText().contains("GPU")) continue;
                    MOut.G(this).println("---------------------------------------------------------------------------");
                    url = "https://" + ip + l.path("@odata.id").asText();
                    result2 = this.sessionLoginClient.send_https_get(url);
                    if (result2 < 200 || result2 > 210) continue;
                    pnode = mapper.readTree(this.sessionLoginClient.getResponseString());
                    status2 = pnode.path("Status");
                    state2 = status2.path("State");
                    health2 = status2.path("Health");
                    model2 = pnode.path("Model");
                    partNumber = pnode.path("PartNumber");
                    serialNumber = pnode.path("SerialNumber");
                    fwVersion = pnode.findPath("FirmwareVersion");
                    type = pnode.path("ProcessorType");
                    manufacturer2 = pnode.path("Manufacturer");
                    maxspeed = pnode.path("MaxSpeedMHz");
                    fStr2 = new StringBuffer();
                    fStr2.append(String.format(formatTemplate, "ProcessorType", type.asText()));
                    fStr2.append(String.format(formatTemplate, "State", state2.asText()));
                    fStr2.append(String.format(formatTemplate, "Health", health2.asText()));
                    fStr2.append(String.format(formatTemplate, "Model", model2.asText()));
                    fStr2.append(String.format(formatTemplate, "MaxSpeedMHz", maxspeed.asText() + " MHz"));
                    fStr2.append(String.format(formatTemplate, "PartNumber", partNumber.asText()));
                    fStr2.append(String.format(formatTemplate, "SerialNumber", serialNumber.asText()));
                    fStr2.append(String.format(formatTemplate, "Manufacturer", manufacturer2.asText()));
                    fStr2.append(String.format(formatTemplate, "FirmwareVersion", fwVersion.asText()));
                    MOut.G(this).print(fStr2.toString());
                    MOut.G(this).println("---------------------------------------------------------------------------");
                    ++gpuCount;
                }
            }
        } else {
            MOut.G(this).println("redfish/v1/Systems/1/Processors connection failed");
            this.statusCode = 149;
            return;
        }
        if (gpuCount > 0) {
            MOut.G(this).println("Total GPU count: " + gpuCount);
            this.statusCode = 0;
            return;
        }
        url = "https://" + ip + "/redfish/v1/" + "Systems";
        result = this.sessionLoginClient.send_https_get(url);
        if (result >= 200 && result <= 210) {
            mapper = new ObjectMapper();
            node = mapper.readTree(this.sessionLoginClient.getResponseString());
            member = node.path("Members");
            formatTemplate = " %-25s | %-45s |\n";
            if (member.isArray()) {
                for (JsonNode l : member) {
                    if (!l.path("@odata.id").asText().contains("UBB")) continue;
                    MOut.G(this).println("---------------------------------------------------------------------------");
                    url = "https://" + ip + l.path("@odata.id").asText() + "/Processors";
                    result2 = this.sessionLoginClient.send_https_get(url);
                    if (result2 < 200 || result2 > 210) continue;
                    pnode = mapper.readTree(this.sessionLoginClient.getResponseString());
                    status2 = pnode.path("Status");
                    state2 = status2.path("State");
                    health2 = status2.path("Health");
                    model2 = pnode.path("Model");
                    partNumber = pnode.path("PartNumber");
                    serialNumber = pnode.path("SerialNumber");
                    fwVersion = pnode.findPath("FirmwareVersion");
                    type = pnode.path("ProcessorType");
                    manufacturer2 = pnode.path("Manufacturer");
                    maxspeed = pnode.path("MaxSpeedMHz");
                    fStr2 = new StringBuffer();
                    fStr2.append(String.format(formatTemplate, "ProcessorType", type.asText()));
                    fStr2.append(String.format(formatTemplate, "State", state2.asText()));
                    fStr2.append(String.format(formatTemplate, "Health", health2.asText()));
                    fStr2.append(String.format(formatTemplate, "Model", model2.asText()));
                    fStr2.append(String.format(formatTemplate, "MaxSpeedMHz", maxspeed.asText() + " MHz"));
                    fStr2.append(String.format(formatTemplate, "PartNumber", partNumber.asText()));
                    fStr2.append(String.format(formatTemplate, "SerialNumber", serialNumber.asText()));
                    fStr2.append(String.format(formatTemplate, "Manufacturer", manufacturer2.asText()));
                    fStr2.append(String.format(formatTemplate, "FirmwareVersion", fwVersion.asText()));
                    MOut.G(this).print(fStr2.toString());
                    MOut.G(this).println("---------------------------------------------------------------------------");
                    ++gpuCount;
                }
            } else {
                MOut.G(this).println("redfish/v1/Chassis/ connection failed");
                this.statusCode = 149;
                return;
            }
        }
        if (gpuCount > 0) {
            MOut.G(this).println("Total GPU count: " + gpuCount);
            this.statusCode = 0;
            return;
        }
        url = "https://" + ip + "/redfish/v1/" + "Systems/HGX_Baseboard_0/Processors";
        result = this.sessionLoginClient.send_https_get(url);
        if (result >= 200 && result <= 210) {
            mapper = new ObjectMapper();
            node = mapper.readTree(this.sessionLoginClient.getResponseString());
            member = node.path("Members");
            formatTemplate = " %-25s | %-45s |\n";
            if (member.isArray()) {
                for (JsonNode l : member) {
                    if (!l.path("@odata.id").asText().contains("GPU")) continue;
                    MOut.G(this).println("---------------------------------------------------------------------------");
                    url = "https://" + ip + l.path("@odata.id").asText();
                    result2 = this.sessionLoginClient.send_https_get(url);
                    if (result2 < 200 || result2 > 210) continue;
                    fStr = new StringBuffer();
                    device = mapper.readTree(this.sessionLoginClient.getResponseString());
                    item = device.path("Id");
                    status = device.path("Status");
                    state = status.path("State");
                    health = status.path("Health");
                    manufacturer = device.path("Manufacturer");
                    gpuVendor = device.path("GPUVendor");
                    model = device.path("Model");
                    JsonNode fwVersion2 = device.path("FirmwareVersion");
                    JsonNode serialNumber2 = device.path("SerialNumber");
                    JsonNode partNumber2 = device.path("PartNumber");
                    JsonNode maxspeed2 = device.path("MaxSpeedMHz");
                    JsonNode location = device.path("Location");
                    JsonNode plocation = location.path("PartLocation");
                    JsonNode locationType = plocation.path("LocationType");
                    JsonNode serviceLabel = plocation.path("ServiceLabel");
                    manufactureVender = manufacturer.asText();
                    if ("".equals(manufactureVender) && !"".equals(gpuVendor.asText())) {
                        manufactureVender = gpuVendor.asText();
                    } else if ("".equals(manufactureVender) && "".equals(gpuVendor.asText()) && (oem = device.path("Oem")) != null && (oemSupermicro = oem.path("Supermicro")) != null) {
                        manufactureVender = oemSupermicro.path("GPUVendor").asText();
                    }
                    fStr.append(String.format(formatTemplate, "Item", item.asText()));
                    fStr.append(String.format(formatTemplate, "State", state.asText()));
                    fStr.append(String.format(formatTemplate, "Health", health.asText()));
                    fStr.append(String.format(formatTemplate, "Model", model.asText()));
                    fStr.append(String.format(formatTemplate, "MaxSpeedMHz", maxspeed2.asText() + " MHz"));
                    fStr.append(String.format(formatTemplate, "PartNumber", partNumber2.asText()));
                    fStr.append(String.format(formatTemplate, "SerialNumber", serialNumber2.asText()));
                    fStr.append(String.format(formatTemplate, "Manufacturer", manufactureVender));
                    fStr.append(String.format(formatTemplate, "LocationType", locationType.asText()));
                    fStr.append(String.format(formatTemplate, "ServiceLabel", serviceLabel.asText()));
                    fStr.append(String.format(formatTemplate, "FirmwareVersion", fwVersion2.asText()));
                    MOut.G(this).print(fStr.toString());
                    MOut.G(this).println("---------------------------------------------------------------------------");
                    ++gpuCount;
                }
            }
        }
        if (gpuCount > 0) {
            MOut.G(this).println("Total GPU count: " + gpuCount);
            this.statusCode = 0;
            return;
        }
        url = "https://" + ip + "/redfish/v1/Chassis/1/" + "PCIeDevices";
        result = this.sessionLoginClient.send_https_get(url);
        if (result >= 200 && result <= 210) {
            mapper = new ObjectMapper();
            node = mapper.readTree(this.sessionLoginClient.getResponseString());
            member = node.path("Members");
            formatTemplate = " %-25s | %-45s |\n";
            if (member.isArray()) {
                for (JsonNode l : member) {
                    if (!l.path("@odata.id").asText().contains("GPU")) continue;
                    MOut.G(this).println("---------------------------------------------------------------------------");
                    url = "https://" + ip + l.path("@odata.id").asText();
                    result2 = this.sessionLoginClient.send_https_get(url);
                    if (result2 < 200 || result2 > 210) continue;
                    fStr = new StringBuffer();
                    device = mapper.readTree(this.sessionLoginClient.getResponseString());
                    item = device.path("Id");
                    status = device.path("Status");
                    state = status.path("State");
                    health = status.path("Health");
                    manufacturer = device.path("Manufacturer");
                    gpuVendor = device.path("GPUVendor");
                    model = device.path("Model");
                    JsonNode serialNumber3 = device.path("SerialNumber");
                    JsonNode partNumber3 = device.path("PartNumber");
                    JsonNode fwVersion3 = device.path("FirmwareVersion");
                    JsonNode interfaces = device.path("PCIeInterface");
                    JsonNode type2 = interfaces.path("PCIeType");
                    JsonNode maxType = interfaces.path("MaxPCIeType");
                    JsonNode lanesInUse = interfaces.path("LanesInUse");
                    JsonNode maxLanes = interfaces.path("MaxLanes");
                    manufactureVender = manufacturer.asText();
                    if ("".equals(manufactureVender) && !"".equals(gpuVendor.asText())) {
                        manufactureVender = gpuVendor.asText();
                    } else if ("".equals(manufactureVender) && "".equals(gpuVendor.asText()) && (oem = device.path("Oem")) != null && (oemSupermicro = oem.path("Supermicro")) != null) {
                        manufactureVender = oemSupermicro.path("GPUVendor").asText();
                    }
                    fStr.append(String.format(formatTemplate, "Item", item.asText()));
                    fStr.append(String.format(formatTemplate, "State", state.asText()));
                    fStr.append(String.format(formatTemplate, "Health", health.asText()));
                    fStr.append(String.format(formatTemplate, "Model", model.asText()));
                    fStr.append(String.format(formatTemplate, "PartNumber", partNumber3.asText()));
                    fStr.append(String.format(formatTemplate, "SerialNumber", serialNumber3.asText()));
                    fStr.append(String.format(formatTemplate, "Manufacturer", manufactureVender));
                    fStr.append(String.format(formatTemplate, "FirmwareVersion", fwVersion3.asText()));
                    fStr.append(String.format(formatTemplate, "PCIeType", type2.asText()));
                    fStr.append(String.format(formatTemplate, "MaxPCIeType", maxType.asText()));
                    fStr.append(String.format(formatTemplate, "LanesInUse", lanesInUse.asText()));
                    fStr.append(String.format(formatTemplate, "MaxLanes", maxLanes.asText()));
                    MOut.G(this).print(fStr.toString());
                    MOut.G(this).println("---------------------------------------------------------------------------");
                    ++gpuCount;
                }
            }
        }
        MOut.G(this).println("Total GPU count: " + gpuCount);
        this.statusCode = 0;
    }
}

