/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text.scc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;

public class SCCCheckingLANMACCommand
extends RedfishTokenCommand {
    @Override
    public void runCommand() throws Exception {
        String ip = RedfishHttpUtils.getUrlIP(this.config.getIp());
        String url = "https://" + ip + "/redfish/v1/Systems/1/" + "EthernetInterfaces";
        int result = this.sessionLoginClient.send_https_get(url);
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(this.sessionLoginClient.getResponseString());
            JsonNode member = node.path("Members");
            String formatTemplate = " %-25s | %-45s |\n";
            if (member.isArray()) {
                MOut.G(this).println("\n  EthernetInterfaces");
                MOut.G(this).println("---------------------------------------------------------------------------");
                if (member.size() == 0) {
                    MOut.G(this).println(" None");
                }
                for (JsonNode l : member) {
                    url = "https://" + ip + l.path("@odata.id").asText();
                    int result2 = this.sessionLoginClient.send_https_get(url);
                    if (result2 < 200 || result2 > 210) continue;
                    JsonNode pnode = mapper.readTree(this.sessionLoginClient.getResponseString());
                    JsonNode status = pnode.path("Status");
                    JsonNode state = status.path("State");
                    JsonNode health = status.path("Health");
                    JsonNode name = pnode.path("Name");
                    JsonNode mac = pnode.path("MACAddress");
                    StringBuffer fStr = new StringBuffer();
                    fStr.append(String.format(formatTemplate, "Name", name.asText()));
                    fStr.append(String.format(formatTemplate, "MACAddress", mac.asText()));
                    fStr.append(String.format(formatTemplate, "State", state.asText()));
                    fStr.append(String.format(formatTemplate, "Health", health.asText()));
                    MOut.G(this).print(fStr.toString());
                    MOut.G(this).println("---------------------------------------------------------------------------");
                }
            }
        } else {
            MOut.G(this).println("redfish/v1/Systems/1/EthernetInterfaces connection failed");
            this.statusCode = 149;
            return;
        }
        this.statusCode = 0;
    }
}

