/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text.scc;

import com.supermicro.ipmi.activation.CSWProductKey;
import com.supermicro.ipmi.text.LicenseManager;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;

public class SCCCheckingLicenseCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        LicenseManager lm = new LicenseManager(this.ipmiCMMOEMCommand.getIPMIInterface(), this.config);
        String formatTemplate = " %-20s %2s %15s\n";
        StringBuffer content = new StringBuffer();
        try {
            ArrayList<CSWProductKey> productkeylist = lm.getProductKeyList();
            if (productkeylist != null && productkeylist.size() > 0) {
                for (int i2 = 0; i2 < productkeylist.size(); ++i2) {
                    content.append(String.format(formatTemplate, productkeylist.get(i2).getSwName(), "", "Activated"));
                }
            } else {
                MOut.G(this).println("No Node product key activated");
                this.statusCode = 149;
                return;
            }
            MOut.G(this).println(content.toString());
            if (!lm.checkIfDCMSLicenseExist()) {
                MOut.G(this).println("No DCMS-Single key activated");
                this.statusCode = 149;
                return;
            }
            this.statusCode = 0;
        }
        catch (Exception e2) {
            MOut.G(this).println("Query productKey fail..   " + e2.getMessage());
            this.statusCode = 148;
        }
    }

    public String getKeyDisplayName(int aID) {
        String mDisplayName;
        switch (aID) {
            case 0: {
                mDisplayName = "Reserved";
                break;
            }
            case 1: {
                mDisplayName = "SFT-SSM-LIC";
                break;
            }
            case 2: {
                mDisplayName = "SFT-SD5-LIC";
                break;
            }
            case 3: {
                mDisplayName = "SFT-SUM-LIC";
                break;
            }
            case 4: {
                mDisplayName = "SFT-SPM-LIC";
                break;
            }
            case 5: {
                mDisplayName = "SFT-SCM-LIC";
                break;
            }
            case 6: {
                mDisplayName = "SFT-DCMS-Single";
                break;
            }
            case 7: {
                mDisplayName = "SFT-SITE-LIC";
                break;
            }
            case 8: {
                mDisplayName = "DCMS-CALL-HOME";
                break;
            }
            default: {
                mDisplayName = "Unsupported SWID:" + aID;
            }
        }
        return mDisplayName;
    }
}

