/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text.scc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;

public class SCCCheckingMemoryCommand
extends RedfishTokenCommand {
    @Override
    public void runCommand() throws Exception {
        String ip = RedfishHttpUtils.getUrlIP(this.config.getIp());
        String url = "https://" + ip + "/redfish/v1/Systems/1/" + "Memory";
        int result = this.sessionLoginClient.send_https_get(url);
        int dimmCount = 0;
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(this.sessionLoginClient.getResponseString());
            JsonNode member = node.path("Members");
            String formatTemplate = " %-25s | %-45s |\n";
            if (member.isArray()) {
                MOut.G(this).println("\n  Memory");
                MOut.G(this).println("---------------------------------------------------------------------------");
                if (member.size() == 0) {
                    MOut.G(this).println(" None");
                }
                for (JsonNode l : member) {
                    JsonNode pnode;
                    JsonNode memoryType;
                    url = "https://" + ip + l.path("@odata.id").asText();
                    int result2 = this.sessionLoginClient.send_https_get(url);
                    if (result2 < 200 || result2 > 210 || !(memoryType = (pnode = mapper.readTree(this.sessionLoginClient.getResponseString())).path("MemoryType")).asText().equalsIgnoreCase("DRAM")) continue;
                    JsonNode locator = pnode.path("DeviceLocator");
                    JsonNode type = pnode.path("MemoryDeviceType");
                    JsonNode correction = pnode.path("ErrorCorrection");
                    JsonNode speed = pnode.path("OperatingSpeedMhz");
                    JsonNode size = pnode.path("CapacityMiB");
                    JsonNode manufacturer = pnode.path("Manufacturer");
                    JsonNode serialNumber = pnode.path("SerialNumber");
                    JsonNode partNumber = pnode.path("PartNumber");
                    JsonNode module = pnode.path("BaseModuleType");
                    JsonNode databits = pnode.path("DataWidthBits");
                    JsonNode busbits = pnode.path("BusWidthBits");
                    StringBuffer fStr = new StringBuffer();
                    fStr.append(String.format(formatTemplate, "Locator", locator.asText()));
                    fStr.append(String.format(formatTemplate, "DeviceType", type.asText()));
                    fStr.append(String.format(formatTemplate, "Operating Speed", speed.asText() + " MHz"));
                    fStr.append(String.format(formatTemplate, "Size", size.asText() + " MB"));
                    fStr.append(String.format(formatTemplate, "ErrorCorrection", correction.asText()));
                    fStr.append(String.format(formatTemplate, "ModuleType", module.asText()));
                    fStr.append(String.format(formatTemplate, "DataWidthBits", databits.asText()));
                    fStr.append(String.format(formatTemplate, "BusWidthBits", busbits.asText()));
                    fStr.append(String.format(formatTemplate, "SerialNumber", serialNumber.asText()));
                    fStr.append(String.format(formatTemplate, "PartNumber", partNumber.asText()));
                    fStr.append(String.format(formatTemplate, "Manufacturer", manufacturer.asText()));
                    MOut.G(this).println(fStr.toString());
                    MOut.G(this).println("---------------------------------------------------------------------------");
                    ++dimmCount;
                }
            }
        } else {
            MOut.G(this).println("redfish/v1/Systems/1/Memory connection failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Total Dimm count: " + dimmCount);
        this.statusCode = 0;
    }
}

