/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text.scc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;

public class SCCCheckingStorageCommand
extends RedfishTokenCommand {
    @Override
    public void runCommand() throws Exception {
        String ip = RedfishHttpUtils.getUrlIP(this.config.getIp());
        String url = "https://" + ip + "/redfish/v1/Systems/1/" + "Storage/";
        int result = this.sessionLoginClient.send_https_get(url);
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(this.sessionLoginClient.getResponseString());
            JsonNode member = node.path("Members");
            String formatTemplate = " %-25s | %-45s |\n";
            if (member.isArray()) {
                MOut.G(this).println("---------------------------------------------------------------------------");
                if (member.size() == 0) {
                    MOut.G(this).println(" None");
                }
                for (JsonNode l : member) {
                    url = "https://" + ip + l.path("@odata.id").asText();
                    int result2 = this.sessionLoginClient.send_https_get(url);
                    if (result2 < 200 || result2 > 210) continue;
                    JsonNode pnode = mapper.readTree(this.sessionLoginClient.getResponseString());
                    JsonNode id = pnode.path("Id");
                    JsonNode manufacturer = pnode.path("Manufacturer");
                    JsonNode model = pnode.path("Model");
                    JsonNode fwVersion = pnode.findPath("FirmwareVersion");
                    StringBuffer fStr = new StringBuffer();
                    fStr.append(String.format(formatTemplate, "ID", id.asText()));
                    fStr.append(String.format(formatTemplate, "Manufacturer", manufacturer.asText()));
                    fStr.append(String.format(formatTemplate, "Model", model.asText()));
                    fStr.append(String.format(formatTemplate, "FirmwareVersion", fwVersion.asText()));
                    MOut.G(this).println(fStr.toString());
                    MOut.G(this).println("---------------------------------------------------------------------------");
                    if (!url.contains("NVMeSSD") && !url.contains("HA-RAID") && !url.contains("RAIDIntegrated") && !url.contains("SATAEmbedded")) continue;
                    JsonNode drives = pnode.path("Drives");
                    for (JsonNode drive : drives) {
                        String url_drive = "https://" + ip + drive.path("@odata.id").asText();
                        int result3 = this.sessionLoginClient.send_https_get(url_drive);
                        if (result3 < 200 || result3 > 210) continue;
                        JsonNode dnode = mapper.readTree(this.sessionLoginClient.getResponseString());
                        JsonNode d_id = dnode.path("Id");
                        JsonNode d_status = dnode.path("Status");
                        JsonNode d_state = d_status.path("State");
                        JsonNode d_health = d_status.path("Health");
                        JsonNode d_manufacturer = dnode.path("Manufacturer");
                        JsonNode d_serial = dnode.path("SerialNumber");
                        JsonNode d_led = dnode.path("IndicatorLED");
                        JsonNode d_mediaType = dnode.path("MediaType");
                        JsonNode d_capacity = dnode.path("CapacityBytes");
                        StringBuffer fStr2 = new StringBuffer();
                        fStr2.append(String.format(formatTemplate, "ID", d_id.asText()));
                        fStr2.append(String.format(formatTemplate, "State", d_state.asText()));
                        fStr2.append(String.format(formatTemplate, "Health", d_health.asText()));
                        fStr2.append(String.format(formatTemplate, "Manufacturer", d_manufacturer.asText()));
                        fStr2.append(String.format(formatTemplate, "SerialNumber", d_serial.asText()));
                        fStr2.append(String.format(formatTemplate, "IndicatorLED", d_led.asText()));
                        fStr2.append(String.format(formatTemplate, "MediaType", d_mediaType.asText()));
                        fStr2.append(String.format(formatTemplate, "CapacityBytes", d_capacity.asText()));
                        MOut.G(this).print(fStr2.toString());
                        MOut.G(this).println("---------------------------------------------------------------------------");
                    }
                }
            }
        } else {
            MOut.G(this).println("redfish/v1/Systems/1/Storage connection failed");
            this.statusCode = 149;
            return;
        }
        this.statusCode = 0;
    }
}

