/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.softkeyboard;

import com.ami.kvm.jviewer.hid.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.USBKeyboardRep;
import com.supermicro.softkeyboard.IKeyboardLayout;
import com.supermicro.softkeyboard.Key;
import com.supermicro.softkeyboard.KeyButton;
import com.supermicro.softkeyboard.KeyChar;
import com.supermicro.softkeyboard.KeyboardLanguage;
import com.supermicro.softkeyboard.KeyboardLanguage_EN;
import com.supermicro.softkeyboard.KeyboardLayout_109;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;

public class SoftKeyboard
extends JPanel
implements MouseListener {
    KVMClient kvmClient;
    IKeyboardLayout keyboardLayout;
    KeyboardLanguage keyboardLanguage;
    KeyButton[] keyButtons;
    int keyWidth = 22;
    int keyHeight = 22;
    boolean combineKeyMode = false;
    boolean combineKeyLock = false;
    boolean isNumLock = false;
    boolean isCapsLock = false;
    boolean isScrollLock = false;
    boolean isLShift = false;
    boolean isLCtrl = false;
    boolean isLAlt = false;
    boolean isLWin = false;
    boolean isRShift = false;
    boolean isRCtrl = false;
    boolean isRAlt = false;
    boolean isRWin = false;
    boolean isPrtSc = false;
    Timer timer = null;
    MouseEvent tempMouseEvent;

    public SoftKeyboard() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
    }

    private void myInit() throws Exception {
        this.keyboardLayout = new KeyboardLayout_109();
        this.keyboardLanguage = new KeyboardLanguage_EN();
        this.layoutKeyboard(this.keyboardLayout.getKeyboardLayout());
        int n = this.keyWidth * this.keyboardLayout.sizeOfWidth();
        int n2 = this.keyHeight * this.keyboardLayout.sizeOfHeight();
        this.setPreferredSize(new Dimension(n, n2));
    }

    public void changeKeyboardLanguage(KeyboardLanguage keyboardLanguage) {
        this.keyboardLanguage = keyboardLanguage;
        this.cleanToggleStatus();
        this.layoutKeyboard(this.keyboardLayout.getKeyboardLayout());
        this.repaint();
    }

    public void layoutKeyboard(Key[] keyArray) {
        HashMap hashMap = this.keyboardLanguage.getKeyboardCharHT();
        this.removeAll();
        this.keyButtons = new KeyButton[keyArray.length];
        for (int k = 0; k < keyArray.length; ++k) {
            KeyChar keyChar = (KeyChar)hashMap.get(keyArray[k].getKeyNumber());
            this.keyButtons[k] = new KeyButton(keyArray[k], keyChar);
            this.keyButtons[k].setBounds((int)((double)this.keyWidth * keyArray[k].getXLoc()), (int)((double)this.keyHeight * keyArray[k].getYLoc()), (int)((double)this.keyWidth * keyArray[k].getWidthRatio()), (int)((double)this.keyHeight * keyArray[k].getHeightRatio()));
            this.keyButtons[k].addMouseListener(this);
            this.add(this.keyButtons[k]);
        }
        this.setCombineKeyMode(true);
    }

    public void setKeyDisplayStatus(int n) {
        for (int k = 0; k < this.keyButtons.length; ++k) {
            this.keyButtons[k].setKeyDisplayStatus(n);
        }
    }

    public void setNumlock(boolean bl) {
        for (int k = 0; k < this.keyButtons.length; ++k) {
            this.keyButtons[k].setIsNumlock(bl);
        }
    }

    public void showKeyboardChar(KeyChar[] keyCharArray) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Object object;
        if (this.combineKeyMode) {
            this.updateModifierStatus(mouseEvent);
            this.updateShiftKeyCharDisplay();
            if (this.isModifierKey((KeyButton)mouseEvent.getSource())) {
                return;
            }
        }
        this.sendKey(mouseEvent);
        if (!this.combineKeyLock && ((KeyButton)(object = (KeyButton)mouseEvent.getSource())).getKeyType() != 1) {
            this.cleanToggleStatus();
            this.updateShiftKeyCharDisplay();
        }
        this.tempMouseEvent = mouseEvent;
        object = new TimerTask(){

            @Override
            public void run() {
                SoftKeyboard.this.sendKey(SoftKeyboard.this.tempMouseEvent);
            }
        };
        this.timer = new Timer();
        this.timer.schedule((TimerTask)object, 500L, 100L);
    }

    public boolean isCombineKeyMode() {
        return this.combineKeyMode;
    }

    public boolean isCombineKeyLock() {
        return this.combineKeyLock;
    }

    public KVMClient getKvmClient() {
        return this.kvmClient;
    }

    public void cleanToggleStatus() {
        for (int k = 0; k < this.keyButtons.length; ++k) {
            if (!this.isModifierKey(this.keyButtons[k])) continue;
            this.keyButtons[k].clearToggleStatus();
        }
        this.isLShift = false;
        this.isLAlt = false;
        this.isLCtrl = false;
        this.isLWin = false;
        this.isRShift = false;
        this.isRAlt = false;
        this.isRCtrl = false;
        this.isRWin = false;
        this.isPrtSc = false;
    }

    public void setCombineKeyMode(boolean bl) {
        this.combineKeyMode = bl;
        for (int k = 0; k < this.keyButtons.length; ++k) {
            if (this.isModifierKey(this.keyButtons[k])) {
                if (bl) {
                    this.keyButtons[k].setKeyType(1);
                    continue;
                }
                this.keyButtons[k].setKeyType(0);
                continue;
            }
            this.keyButtons[k].setKeyType(0);
        }
    }

    public void setCombineKeyLock(boolean bl) {
        this.combineKeyLock = bl;
    }

    public void setKvmClient(KVMClient kVMClient) {
        this.kvmClient = kVMClient;
    }

    private boolean isModifierKey(KeyButton keyButton) {
        return keyButton.getKey().getKeyNumber() == 44 || keyButton.getKey().getKeyNumber() == 58 || keyButton.getKey().getKeyNumber() == 60 || keyButton.getKey().getKeyNumber() == 127 || keyButton.getKey().getKeyNumber() == 57 || keyButton.getKey().getKeyNumber() == 64 || keyButton.getKey().getKeyNumber() == 62 || keyButton.getKey().getKeyNumber() == 128 || keyButton.getKey().getKeyNumber() == 124;
    }

    private void updateModifierStatus(MouseEvent mouseEvent) {
        KeyButton keyButton = (KeyButton)mouseEvent.getSource();
        switch (keyButton.getKey().getKeyNumber()) {
            case 44: {
                this.isLShift = keyButton.keyToggleStatus;
                break;
            }
            case 58: {
                this.isLCtrl = keyButton.keyToggleStatus;
                break;
            }
            case 60: {
                this.isLAlt = keyButton.keyToggleStatus;
                break;
            }
            case 127: {
                this.isLWin = keyButton.keyToggleStatus;
                break;
            }
            case 57: {
                this.isRShift = keyButton.keyToggleStatus;
                break;
            }
            case 64: {
                this.isRCtrl = keyButton.keyToggleStatus;
                break;
            }
            case 62: {
                this.isRAlt = keyButton.keyToggleStatus;
                break;
            }
            case 128: {
                this.isRWin = keyButton.keyToggleStatus;
                break;
            }
            case 90: {
                this.isNumLock = keyButton.keyToggleStatus;
            }
            case 124: {
                this.isPrtSc = keyButton.keyToggleStatus;
            }
        }
    }

    private void updateShiftKeyCharDisplay() {
        if (this.isLShift || this.isRShift) {
            this.setKeyDisplayStatus(1);
        } else {
            this.setKeyDisplayStatus(0);
        }
    }

    private void updateNumLockCharDisplay() {
        this.setNumlock(this.isNumLock);
    }

    public void sendKey(MouseEvent mouseEvent) {
        KeyButton keyButton = (KeyButton)mouseEvent.getSource();
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        if (this.isLCtrl) {
            uSBKeyboardRep.set(17, 2, true);
            this.kvmClient.sendKMMessage(uSBKeyboardRep);
        }
        if (this.isLShift) {
            uSBKeyboardRep.set(16, 2, true);
            this.kvmClient.sendKMMessage(uSBKeyboardRep);
        }
        if (this.isLAlt) {
            uSBKeyboardRep.set(18, 2, true);
            this.kvmClient.sendKMMessage(uSBKeyboardRep);
        }
        if (this.isLWin) {
            uSBKeyboardRep.set(524, 2, true);
            this.kvmClient.sendKMMessage(uSBKeyboardRep);
        }
        if (this.isRCtrl) {
            uSBKeyboardRep.set(17, 3, true);
            this.kvmClient.sendKMMessage(uSBKeyboardRep);
        }
        if (this.isRShift) {
            uSBKeyboardRep.set(16, 3, true);
            this.kvmClient.sendKMMessage(uSBKeyboardRep);
        }
        if (this.isRAlt) {
            uSBKeyboardRep.set(18, 3, true);
            this.kvmClient.sendKMMessage(uSBKeyboardRep);
        }
        if (this.isRWin) {
            uSBKeyboardRep.set(524, 3, true);
            this.kvmClient.sendKMMessage(uSBKeyboardRep);
        }
        if (this.isPrtSc) {
            uSBKeyboardRep.set(154, 1, true);
            this.kvmClient.sendKMMessage(uSBKeyboardRep);
        }
        int n = keyButton.getKey().getJavaVirtualKey();
        uSBKeyboardRep.set(n, keyButton.getKey().getKeyLocation(), true);
        this.kvmClient.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(n, keyButton.getKey().getKeyLocation(), false);
        this.kvmClient.sendKMMessage(uSBKeyboardRep);
        if (this.isPrtSc) {
            uSBKeyboardRep.set(154, 1, false);
            this.kvmClient.sendKMMessage(uSBKeyboardRep);
        }
        if (this.isLWin) {
            uSBKeyboardRep.set(524, 2, false);
            this.kvmClient.sendKMMessage(uSBKeyboardRep);
        }
        if (this.isLAlt) {
            uSBKeyboardRep.set(18, 2, false);
            this.kvmClient.sendKMMessage(uSBKeyboardRep);
        }
        if (this.isLShift) {
            uSBKeyboardRep.set(16, 2, false);
            this.kvmClient.sendKMMessage(uSBKeyboardRep);
        }
        if (this.isLCtrl) {
            uSBKeyboardRep.set(17, 2, false);
            this.kvmClient.sendKMMessage(uSBKeyboardRep);
        }
        if (this.isRWin) {
            uSBKeyboardRep.set(524, 3, false);
            this.kvmClient.sendKMMessage(uSBKeyboardRep);
        }
        if (this.isRAlt) {
            uSBKeyboardRep.set(18, 3, false);
            this.kvmClient.sendKMMessage(uSBKeyboardRep);
        }
        if (this.isRShift) {
            uSBKeyboardRep.set(16, 3, false);
            this.kvmClient.sendKMMessage(uSBKeyboardRep);
        }
        if (this.isRCtrl) {
            uSBKeyboardRep.set(17, 3, false);
            this.kvmClient.sendKMMessage(uSBKeyboardRep);
        }
    }

    public void softKeyboardKeyPressed(KeyEvent keyEvent) {
        for (int k = 0; k < this.keyButtons.length; ++k) {
            if (this.keyButtons[k].getKey().getJavaVirtualKey() != keyEvent.getKeyCode()) continue;
            this.keyButtons[k].setMousePressedVisible(true);
        }
    }

    public void softKeyboardKeyReleased(KeyEvent keyEvent) {
        for (int k = 0; k < this.keyButtons.length; ++k) {
            if (this.keyButtons[k].getKey().getJavaVirtualKey() != keyEvent.getKeyCode()) continue;
            this.keyButtons[k].setMousePressedVisible(false);
        }
    }
}

