/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.swproductkey;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.swproductkey.InvalidMacAddressFormatException;
import com.supermicro.swproductkey.InvalidProductKeyFormatException;
import com.supermicro.swproductkey.InvalidSWFRUDataException;
import com.supermicro.swproductkey.ProductKey;
import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESSWFru255Data {
    private static Logger logger = LoggerFactory.getLogger(AESSWFru255Data.class);
    private static byte formatVersion = 0;
    String mac = null;
    Date timestamp = null;

    public static byte getFormatVersion() {
        return formatVersion;
    }

    String getMac() {
        return this.mac;
    }

    void setMac(String aMac) {
        this.mac = aMac;
    }

    Date getTimestamp() {
        return this.timestamp;
    }

    void setTimestamp(Date aTimestamp) {
        this.timestamp = aTimestamp;
    }

    static String[] calculateIVandKey(byte[] aBoardID) {
        byte b2;
        StringBuffer sbIvKey = new StringBuffer();
        byte[] otherIVKeyDate = new byte[]{95, -70, -1, -15};
        byte[] byArray = aBoardID;
        int n = aBoardID.length;
        int n2 = 0;
        while (n2 < n) {
            b2 = byArray[n2];
            sbIvKey.append(String.format("%02X", b2));
            ++n2;
        }
        byArray = otherIVKeyDate;
        n = otherIVKeyDate.length;
        n2 = 0;
        while (n2 < n) {
            b2 = byArray[n2];
            sbIvKey.append(String.format("%02X", b2));
            ++n2;
        }
        String keyData = DigestUtils.md5Hex(sbIvKey.toString());
        String[] retBa = new String[]{keyData.substring(0, 16), keyData.substring(16)};
        return retBa;
    }

    public static byte[] createSWFRU255Data(byte[] aBoardID, String aMAC) throws InvalidSWFRUDataException {
        ByteBuffer bf = ByteBuffer.allocate(256);
        try {
            byte[] encryptedDataBa = AESSWFru255Data.getEncryptedMacAddressAndTimestamp(aBoardID, aMAC);
            bf.put(formatVersion);
            bf.put((byte)encryptedDataBa.length);
            byte[] byArray = encryptedDataBa;
            int n = encryptedDataBa.length;
            int n2 = 0;
            while (n2 < n) {
                byte b2 = byArray[n2];
                bf.put(b2);
                ++n2;
            }
            int i2 = 2 + encryptedDataBa.length;
            while (i2 < 256) {
                bf.put((byte)0);
                ++i2;
            }
        }
        catch (BufferOverflowException e2) {
            throw new InvalidSWFRUDataException("Max length of SW FRU 255 is 256!");
        }
        catch (InvalidKeyException e3) {
            throw new InvalidSWFRUDataException(e3.getMessage());
        }
        catch (UnsupportedEncodingException e4) {
            throw new InvalidSWFRUDataException(e4.getMessage());
        }
        catch (NoSuchAlgorithmException e5) {
            throw new InvalidSWFRUDataException(e5.getMessage());
        }
        catch (NoSuchPaddingException e6) {
            throw new InvalidSWFRUDataException(e6.getMessage());
        }
        catch (InvalidAlgorithmParameterException e7) {
            throw new InvalidSWFRUDataException(e7.getMessage());
        }
        catch (IllegalBlockSizeException e8) {
            throw new InvalidSWFRUDataException(e8.getMessage());
        }
        catch (BadPaddingException e9) {
            throw new InvalidSWFRUDataException(e9.getMessage());
        }
        catch (InvalidMacAddressFormatException e10) {
            throw new InvalidSWFRUDataException(e10.getMessage());
        }
        catch (InvalidProductKeyFormatException e11) {
            throw new InvalidSWFRUDataException(e11.getMessage());
        }
        return bf.array();
    }

    public static byte[] getEncryptedMacAddressAndTimestamp(byte[] aBoardID, String aMAC) throws InvalidMacAddressFormatException, InvalidProductKeyFormatException, UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        if (aBoardID == null) {
            throw new InvalidProductKeyFormatException("Board ID can not be null!");
        }
        if (aBoardID.length != 2) {
            throw new InvalidProductKeyFormatException("Invalid board ID length:" + aBoardID.length);
        }
        if (aMAC == null) {
            throw new InvalidMacAddressFormatException("Mac address can not be null!");
        }
        aMAC = aMAC.toUpperCase();
        String[] strIVKey = AESSWFru255Data.calculateIVandKey(aBoardID);
        SecretKeySpec secretKey = new SecretKeySpec(strIVKey[1].getBytes("UTF-8"), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)secretKey, new IvParameterSpec(strIVKey[0].getBytes("UTF-8")));
        byte[] macBa = aMAC.getBytes("UTF-8");
        byte[] timestampBa = new byte[4];
        ByteUtility.longTo4Bytes(timestampBa, 0, new Date().getTime() / 1000L);
        byte[] newBa = new byte[1 + macBa.length + timestampBa.length];
        int i2 = 0;
        newBa[0] = formatVersion;
        i2 = 0;
        while (i2 < macBa.length) {
            newBa[i2 + 1] = macBa[i2];
            ++i2;
        }
        int j2 = 0;
        while (j2 < timestampBa.length) {
            newBa[i2 + j2 + 1] = timestampBa[j2];
            ++j2;
        }
        byte[] retBa = cipher.doFinal(newBa);
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            byte[] byArray = retBa;
            int n = retBa.length;
            int n2 = 0;
            while (n2 < n) {
                byte b2 = byArray[n2];
                sb.append(String.format("%02X ", b2));
                ++n2;
            }
            logger.debug("getEncryptedMacAddressAndTimestamp(): " + sb.toString());
        }
        return retBa;
    }

    public static AESSWFru255Data decryptMacAddressAndTimestamp(byte[] aBoardID, byte[] aEncryptedContent) throws InvalidProductKeyFormatException, UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        if (aBoardID == null) {
            throw new InvalidProductKeyFormatException("Board ID can not be null!");
        }
        if (aBoardID.length != 2) {
            throw new InvalidProductKeyFormatException("Invalid board ID length:" + aBoardID.length);
        }
        String[] strIVKey = AESSWFru255Data.calculateIVandKey(aBoardID);
        SecretKeySpec secretKey = new SecretKeySpec(strIVKey[1].getBytes("UTF-8"), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)secretKey, new IvParameterSpec(strIVKey[0].getBytes("UTF-8")));
        byte[] dataBa = cipher.doFinal(aEncryptedContent);
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            byte[] byArray = dataBa;
            int n = dataBa.length;
            int n2 = 0;
            while (n2 < n) {
                byte b2 = byArray[n2];
                sb.append(String.format("%02X ", b2));
                ++n2;
            }
            logger.debug("decryptMacAddressAndTimestamp(): " + sb.toString());
        }
        AESSWFru255Data instance = new AESSWFru255Data();
        assert (dataBa.length == 17);
        formatVersion = dataBa[0];
        StringBuffer macSb = new StringBuffer();
        int i2 = 1;
        while (i2 < 13) {
            macSb.append(String.format("%c", dataBa[i2]));
            ++i2;
        }
        instance.setMac(macSb.toString());
        byte[] tempAry = Arrays.copyOfRange(dataBa, i2, dataBa.length);
        instance.setTimestamp(ProductKey.fourByteToDate(tempAry));
        return instance;
    }
}

