/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.swproductkey;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.supermicro.swproductkey.InvalidMacAddressFormatException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESTool {
    private static Logger logger = LoggerFactory.getLogger(AESTool.class);

    static String[] calculateIVandKey(String aMac) throws InvalidMacAddressFormatException {
        if (aMac.length() != 12) {
            throw new InvalidMacAddressFormatException("Length of Mac address should be 12 bytes!");
        }
        try {
            byte[] byArray = aMac.getBytes("UTF-8");
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte b2 = byArray[n2];
                if (!(b2 >= 48 && b2 <= 57 || b2 >= 65 && b2 <= 90 || b2 >= 97 && b2 <= 122)) {
                    byte[] ba = new byte[]{b2};
                    throw new InvalidMacAddressFormatException("Mac address can not have: '" + new String(ba) + "'" + String.format(":0x%02X", b2));
                }
                ++n2;
            }
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        String keyData = "";
        keyData = DigestUtils.md5Hex(String.valueOf(aMac) + "e" + "j" + "m" + "b");
        String[] retBa = new String[]{keyData.substring(0, 16), keyData.substring(16)};
        return retBa;
    }

    public static byte[] encrypt(String aMAC, byte[] aContent) throws InvalidMacAddressFormatException, UnsupportedEncodingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        if (aMAC == null) {
            throw new InvalidMacAddressFormatException("Mac address can not be null!");
        }
        aMAC = aMAC.toUpperCase();
        String[] strIVKey = AESTool.calculateIVandKey(aMAC);
        SecretKeySpec secretKey = new SecretKeySpec(strIVKey[1].getBytes("UTF-8"), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)secretKey, new IvParameterSpec(strIVKey[0].getBytes("UTF-8")));
        return cipher.doFinal(aContent);
    }

    public static String getEncryptedAndBase64Encode(int aNumOfUnencryptBlock, String aMAC, byte[] aContent) throws InvalidKeyException, UnsupportedEncodingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidMacAddressFormatException {
        int numOfUnencrypt = aNumOfUnencryptBlock * 16;
        assert (numOfUnencrypt < aContent.length);
        String retStr = null;
        if (numOfUnencrypt > 0) {
            byte[] headBa = Arrays.copyOf(aContent, numOfUnencrypt);
            byte[] bodyBa = Arrays.copyOfRange(aContent, numOfUnencrypt, aContent.length);
            retStr = Base64.encode(ArrayUtils.addAll(headBa, AESTool.encrypt(aMAC, bodyBa)));
        } else {
            retStr = Base64.encode(AESTool.encrypt(aMAC, aContent));
        }
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            byte[] byArray = aContent;
            int n = aContent.length;
            int n2 = 0;
            while (n2 < n) {
                byte b2 = byArray[n2];
                sb.append(String.format("%02X ", b2));
                ++n2;
            }
            logger.debug("getEncryptedAndBase64Encode(aNumOfUnencryptedBlock=" + aNumOfUnencryptBlock + "): " + sb.toString() + "\n=>" + retStr);
        }
        return retStr;
    }

    public static byte[] decrypt(String aMAC, byte[] aContent) throws InvalidMacAddressFormatException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException {
        if (aMAC == null) {
            throw new InvalidMacAddressFormatException("Mac address can not be null!");
        }
        aMAC = aMAC.toUpperCase();
        String[] strIVKey = AESTool.calculateIVandKey(aMAC);
        SecretKeySpec secretKey = new SecretKeySpec(strIVKey[1].getBytes("UTF-8"), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)secretKey, new IvParameterSpec(strIVKey[0].getBytes("UTF-8")));
        return cipher.doFinal(aContent);
    }

    public static byte[] getBase64DecodeAndDecrypted(int aNumOfUndecryptBlock, String aMAC, String aBase64String) throws Base64DecodingException, UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidMacAddressFormatException {
        byte[] retBa = null;
        int numOfUndecrypt = aNumOfUndecryptBlock * 16;
        if (numOfUndecrypt > 0) {
            byte[] allBa = Base64.decode(aBase64String.getBytes("UTF-8"));
            assert (numOfUndecrypt < allBa.length);
            byte[] headBa = Arrays.copyOf(allBa, numOfUndecrypt);
            byte[] bodyBa = Arrays.copyOfRange(allBa, numOfUndecrypt, allBa.length);
            retBa = ArrayUtils.addAll(headBa, AESTool.decrypt(aMAC, bodyBa));
        } else {
            retBa = AESTool.decrypt(aMAC, Base64.decode(aBase64String.getBytes("UTF-8")));
        }
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            byte[] byArray = retBa;
            int n = retBa.length;
            int n2 = 0;
            while (n2 < n) {
                byte b2 = byArray[n2];
                sb.append(String.format("%02X ", b2));
                ++n2;
            }
            logger.debug("getBase64DecodeAndDecrypted(): " + aBase64String + "\n=>" + sb.toString());
        }
        return retBa;
    }
}

