/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.swproductkey;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.swproductkey.InvalidProductKeyFormatException;
import com.supermicro.swproductkey.SWIDEnum;
import com.supermicro.swproductkey.SWIDImpl;
import com.supermicro.swproductkey.SWIDInterface;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ProductKey
implements Serializable {
    private static final long serialVersionUID = 6537598594253220547L;
    private static final int unencryptedBlock = 1;
    private static final int maxProductKeyByteArray = 255;
    byte formatVersion = 0;
    SWIDInterface SWID = SWIDEnum.SWID_Reserved;
    String SWVersion = "";
    String invoiceNum = "";
    Date keyCreationDate = ProductKey.fourByteToDate(new byte[4]);
    Date expirationDate = ProductKey.fourByteToDate(new byte[4]);
    byte[] keyProperty = null;
    byte[] secretData = null;
    byte checksum = 0;

    public static int getNumOfUnencryptBlock() {
        return 1;
    }

    public String getRawSecretData() {
        String retStr = String.valueOf(String.format("%02X", this.SWID.getID())) + this.SWVersion + this.expirationDate.getTime();
        if (this.keyProperty != null) {
            byte[] byArray = this.keyProperty;
            int n = this.keyProperty.length;
            int n2 = 0;
            while (n2 < n) {
                byte b2 = byArray[n2];
                retStr = retStr.concat(String.format("%02X", b2));
                ++n2;
            }
        }
        return retStr;
    }

    public static ProductKey createSimpleSSMProductKey() {
        ProductKey aKey = new ProductKey();
        aKey.setSWID(SWIDEnum.SWID_SSMServer);
        aKey.setKeyCreationDate(new Date());
        return aKey;
    }

    public static ProductKey createSimpleSD5ProductKey() {
        ProductKey aKey = new ProductKey();
        aKey.setSWID(SWIDEnum.SWID_SD5);
        aKey.setKeyCreationDate(new Date());
        return aKey;
    }

    public static ProductKey createSimpleSUMProductKey() {
        ProductKey aKey = new ProductKey();
        aKey.setSWID(SWIDEnum.SWID_SUM);
        aKey.setKeyCreationDate(new Date());
        return aKey;
    }

    public static ProductKey createSimpleSPMProductKey() {
        ProductKey aKey = new ProductKey();
        aKey.setSWID(SWIDEnum.SWID_SPM);
        aKey.setKeyCreationDate(new Date());
        return aKey;
    }

    public static ProductKey createSimpleSCMProductKey() {
        ProductKey aKey = new ProductKey();
        aKey.setSWID(SWIDEnum.SWID_SCM);
        aKey.setKeyCreationDate(new Date());
        return aKey;
    }

    public static ProductKey createSimpleALLProductKey() {
        ProductKey aKey = new ProductKey();
        aKey.setSWID(SWIDEnum.SWID_ALL);
        aKey.setKeyCreationDate(new Date());
        return aKey;
    }

    public static ProductKey createSimpleSITEProductKey() {
        ProductKey aKey = new ProductKey();
        aKey.setSWID(SWIDEnum.SWID_SITE);
        aKey.setKeyCreationDate(new Date());
        return aKey;
    }

    public byte getFormatVersion() {
        return this.formatVersion;
    }

    public byte getSWID() {
        return this.SWID.getID();
    }

    public void setSWID(SWIDInterface aSWID) {
        this.SWID = aSWID;
    }

    public String getSWName() {
        return this.SWID.getDisplayName();
    }

    public String getSWVersion() {
        return this.SWVersion;
    }

    public void setSWVersion(String aSWVersion) {
        this.SWVersion = aSWVersion;
    }

    public String getInvoiceNum() {
        return this.invoiceNum;
    }

    public void setInvoiceNum(String aInvoiceNum) {
        this.invoiceNum = aInvoiceNum;
    }

    public Date getKeyCreationDate() {
        return this.keyCreationDate;
    }

    public void setKeyCreationDate(Date aKeyCreationDate) {
        this.keyCreationDate = new Date(aKeyCreationDate.getTime() / 1000L * 1000L);
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date aExpirationDate) {
        this.expirationDate = new Date(aExpirationDate.getTime() / 1000L * 1000L);
    }

    public byte[] getKeyProperty() {
        return this.keyProperty;
    }

    public void setKeyProperty(byte[] aKeyProperty) {
        this.keyProperty = aKeyProperty;
    }

    public byte[] getSecretData() {
        return this.secretData;
    }

    public void setSecretData(byte[] aSecretData) {
        this.secretData = aSecretData;
    }

    public byte getChecksum() {
        return this.checksum;
    }

    public void calculateCheckSum() {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            DataOutputStream dos = new DataOutputStream(bo);
            dos.writeByte(this.formatVersion);
            dos.writeByte(this.SWID.getID());
            int i2 = 0;
            while (i2 < 14) {
                dos.writeByte(0);
                ++i2;
            }
            dos.writeByte(this.formatVersion);
            dos.writeByte(this.SWID.getID());
            dos.writeBytes(this.SWID.getDisplayName());
            dos.writeByte(0);
            dos.writeBytes(this.SWVersion);
            dos.writeByte(0);
            dos.writeBytes(this.invoiceNum);
            dos.writeByte(0);
            byte[] tempAry = new byte[4];
            ByteUtility.longTo4Bytes(tempAry, 0, this.keyCreationDate.getTime() / 1000L);
            dos.write(tempAry);
            ByteUtility.longTo4Bytes(tempAry, 0, this.expirationDate.getTime() / 1000L);
            dos.write(tempAry);
            if (this.keyProperty == null || this.keyProperty.length == 0) {
                dos.writeByte(0);
            } else {
                dos.writeByte((byte)this.keyProperty.length);
                dos.write(this.keyProperty);
            }
            if (this.secretData == null || this.secretData.length == 0) {
                dos.writeByte(0);
            } else {
                dos.writeByte((byte)this.secretData.length);
                dos.write(this.secretData);
            }
            byte[] ba = bo.toByteArray();
            this.checksum = 0;
            int i3 = 0;
            while (i3 < ba.length) {
                this.checksum = (byte)(this.checksum + ba[i3]);
                ++i3;
            }
            dos.writeByte(this.checksum);
            dos.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static Date fourByteToDate(byte[] date) {
        long timeStamp = ByteUtility.fourBytesToLongByLSBFirst(date);
        Date d2 = null;
        if (timeStamp < 0x20000000L) {
            SimpleDateFormat f2 = new SimpleDateFormat("HH:mm:ss");
            f2.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            long k = timeStamp * 1000L;
            d2 = new Date(k);
        } else {
            SimpleDateFormat f3 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            f3.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            long k = timeStamp * 1000L;
            d2 = new Date(k);
        }
        return d2;
    }

    public byte[] getByteArray() throws InvalidProductKeyFormatException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            DataOutputStream dos = new DataOutputStream(bo);
            dos.writeByte(this.formatVersion);
            dos.writeByte(this.SWID.getID());
            int i2 = 0;
            while (i2 < 14) {
                dos.writeByte(0);
                ++i2;
            }
            dos.writeByte(this.formatVersion);
            dos.writeByte(this.SWID.getID());
            dos.writeBytes(this.SWID.getDisplayName());
            dos.writeByte(0);
            dos.writeBytes(this.SWVersion);
            dos.writeByte(0);
            dos.writeBytes(this.invoiceNum);
            dos.writeByte(0);
            byte[] tempAry = new byte[4];
            ByteUtility.longTo4Bytes(tempAry, 0, this.keyCreationDate.getTime() / 1000L);
            dos.write(tempAry);
            ByteUtility.longTo4Bytes(tempAry, 0, this.expirationDate.getTime() / 1000L);
            dos.write(tempAry);
            if (this.keyProperty == null || this.keyProperty.length == 0) {
                dos.writeByte(0);
            } else {
                dos.writeByte((byte)this.keyProperty.length);
                dos.write(this.keyProperty);
            }
            if (this.secretData == null || this.secretData.length == 0) {
                dos.writeByte(0);
            } else {
                dos.writeByte((byte)this.secretData.length);
                dos.write(this.secretData);
            }
            byte[] ba = bo.toByteArray();
            this.checksum = 0;
            int i3 = 0;
            while (i3 < ba.length) {
                this.checksum = (byte)(this.checksum + ba[i3]);
                ++i3;
            }
            dos.writeByte(this.checksum);
            dos.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        ByteBuffer bf = ByteBuffer.allocate(255);
        try {
            bf.put(bo.toByteArray());
            int i4 = 0;
            while (i4 < 255 - bo.size()) {
                bf.put((byte)0);
                ++i4;
            }
        }
        catch (BufferOverflowException e3) {
            throw new InvalidProductKeyFormatException("Max length of product key byte array is 255!");
        }
        return bf.array();
    }

    public static ProductKey parseByteArray(byte[] ba) throws InvalidProductKeyFormatException {
        if (ba == null || ba.length == 0) {
            throw new InvalidProductKeyFormatException("Product key byte array is null or empty!");
        }
        if (ba.length >= 256) {
            throw new InvalidProductKeyFormatException("Max length of product key byte array is 255!");
        }
        ProductKey p1 = new ProductKey();
        ByteArrayInputStream bi = new ByteArrayInputStream(ba);
        DataInputStream dis = new DataInputStream(bi);
        ByteBuffer bf = ByteBuffer.allocate(255);
        try {
            int i2;
            int data;
            p1.formatVersion = dis.readByte();
            if (p1.formatVersion != 0) {
                throw new InvalidProductKeyFormatException("Format version cannot be:" + String.format("0x%02X", p1.formatVersion));
            }
            byte aSWID = dis.readByte();
            int i3 = 0;
            while (i3 < 14) {
                byte b1 = dis.readByte();
                if (b1 != 0) {
                    throw new InvalidProductKeyFormatException("Invalid data in unencrypted block!");
                }
                ++i3;
            }
            byte formatVersion2 = dis.readByte();
            if (p1.formatVersion != formatVersion2) {
                StringBuffer sberr = new StringBuffer();
                sberr.append("Format version do not match! " + String.format("0x%02X", p1.formatVersion) + " != " + String.format("0x%02X", formatVersion2));
                ByteArrayInputStream bierr = new ByteArrayInputStream(ba);
                DataInputStream diserr = new DataInputStream(bierr);
                sberr.append("\n");
                try {
                    while (true) {
                        sberr.append(String.format("0x%02X ", diserr.readByte()));
                    }
                }
                catch (EOFException eOFException) {
                    throw new InvalidProductKeyFormatException(sberr.toString());
                }
            }
            byte SWID2 = dis.readByte();
            if (aSWID != SWID2) {
                throw new InvalidProductKeyFormatException("SW ID do not match! " + String.format("0x%02X", aSWID) + " != " + String.format("0x%02X", SWID2));
            }
            String aSWName = "";
            while ((data = dis.read()) != -1) {
                bf.put((byte)data);
                if (data != 0) continue;
            }
            if (bf.position() > 0) {
                aSWName = new String(bf.array(), 0, bf.position() - 1);
            }
            SWIDEnum[] sWIDEnumArray = SWIDEnum.values();
            int n = sWIDEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                SWIDEnum idEnum = sWIDEnumArray[n2];
                if (idEnum.is(aSWID, aSWName)) {
                    p1.setSWID(idEnum);
                    break;
                }
                ++n2;
            }
            if (aSWID != 0 && p1.getSWID() == 0) {
                SWIDImpl swid = new SWIDImpl(aSWID, aSWName);
                p1.setSWID(swid);
            }
            bf.clear();
            while ((data = dis.read()) != -1) {
                bf.put((byte)data);
                if (data != 0) continue;
            }
            if (bf.position() > 0) {
                p1.SWVersion = new String(bf.array(), 0, bf.position() - 1);
            }
            bf.clear();
            while ((data = dis.read()) != -1) {
                bf.put((byte)data);
                if (data != 0) continue;
            }
            if (bf.position() > 0) {
                p1.invoiceNum = new String(bf.array(), 0, bf.position() - 1);
            }
            byte[] tempAry = new byte[4];
            dis.read(tempAry, 0, 4);
            p1.keyCreationDate = ProductKey.fourByteToDate(tempAry);
            dis.read(tempAry, 0, 4);
            p1.expirationDate = ProductKey.fourByteToDate(tempAry);
            bf.clear();
            int arrayLen = dis.readByte();
            if (arrayLen > 0) {
                p1.keyProperty = new byte[arrayLen];
                i2 = 0;
                while (i2 < arrayLen) {
                    p1.keyProperty[i2] = (byte)dis.read();
                    ++i2;
                }
            }
            bf.clear();
            arrayLen = dis.readByte();
            if (arrayLen > 0) {
                p1.secretData = new byte[arrayLen];
                i2 = 0;
                while (i2 < arrayLen) {
                    p1.secretData[i2] = (byte)dis.read();
                    ++i2;
                }
            }
            byte origCheckSum = dis.readByte();
            p1.calculateCheckSum();
            if (origCheckSum != p1.checksum) {
                throw new InvalidProductKeyFormatException("Checksum error! It should be " + String.format("0x%02X", p1.checksum) + ", instead of " + String.format("0x%02X.", origCheckSum));
            }
            try {
                while (dis.readByte() == 0) {
                }
                throw new InvalidProductKeyFormatException("Padding data is not 0x00!");
            }
            catch (EOFException eOFException) {
            }
        }
        catch (IOException e2) {
            if (e2 instanceof EOFException) {
                throw new InvalidProductKeyFormatException("Length of product key byte array is " + ba.length + " and EOF is reached!");
            }
            e2.printStackTrace();
        }
        return p1;
    }

    public String toString() {
        int i2;
        StringBuffer sb = new StringBuffer();
        sb.append("formatVersion=" + this.formatVersion);
        sb.append("\n");
        sb.append("SWID=" + this.SWID.getID());
        sb.append("\n");
        sb.append("SWName=" + this.SWID.getDisplayName());
        sb.append("\n");
        sb.append("SWVersion=" + this.SWVersion);
        sb.append("\n");
        sb.append("invoiceNum=" + this.invoiceNum);
        sb.append("\n");
        sb.append("keyCreationDate=" + this.keyCreationDate);
        sb.append("\n");
        sb.append("expirationDate=" + this.expirationDate);
        sb.append("\n");
        sb.append("keyProperty={");
        if (this.keyProperty != null) {
            i2 = 0;
            while (i2 < this.keyProperty.length) {
                sb.append(String.format("%02X", this.keyProperty[i2]));
                if (i2 < this.keyProperty.length - 1) {
                    sb.append(",");
                }
                ++i2;
            }
        }
        sb.append("}\n");
        sb.append("secretData={");
        if (this.secretData != null) {
            i2 = 0;
            while (i2 < this.secretData.length) {
                sb.append(String.format("%02X", this.secretData[i2]));
                if (i2 < this.secretData.length - 1) {
                    sb.append(",");
                }
                ++i2;
            }
        }
        sb.append("}\n");
        sb.append("checksum=" + String.format("%02X", this.checksum));
        sb.append("\n");
        return sb.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append(this.formatVersion).append(this.SWID.getID()).append(this.SWID.getDisplayName()).append(this.SWVersion).append(this.invoiceNum).append(this.keyCreationDate).append(this.expirationDate).append(this.keyProperty).append(this.secretData).append(this.checksum).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof ProductKey)) {
            return false;
        }
        ProductKey myPK = (ProductKey)other;
        return new EqualsBuilder().append(this.formatVersion, myPK.formatVersion).append(this.SWID.getID(), myPK.SWID.getID()).append(this.SWID.getDisplayName(), myPK.SWID.getDisplayName()).append(this.SWVersion, myPK.SWVersion).append(this.invoiceNum, myPK.invoiceNum).append(this.keyCreationDate.getTime() / 1000L, myPK.keyCreationDate.getTime() / 1000L).append(this.expirationDate.getTime() / 1000L, myPK.expirationDate.getTime() / 1000L).append(this.keyProperty, myPK.keyProperty).append(this.secretData, myPK.secretData).append(this.checksum, myPK.checksum).isEquals();
    }
}

