/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.swproductkey;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ssm.ipmi.SsmIPMI;
import com.supermicro.swproductkey.AESSWFru255Data;
import com.supermicro.swproductkey.AESTool;
import com.supermicro.swproductkey.IPMICmdErrorCompletionCodeException;
import com.supermicro.swproductkey.InvalidMacAddressFormatException;
import com.supermicro.swproductkey.InvalidProductKeyFormatException;
import com.supermicro.swproductkey.InvalidSWFRUDataException;
import com.supermicro.swproductkey.InvalidSWFRUIndexException;
import com.supermicro.swproductkey.NoSWFRUSupportException;
import com.supermicro.swproductkey.ProductKey;
import com.supermicro.swproductkey.SWIDEnum;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductKeyActivation {
    private static Logger logger = LoggerFactory.getLogger(ProductKeyActivation.class);
    private String strID;
    private String strPW;
    private String strIP;
    private SsmIPMI ipmi;
    private AESSWFru255Data fru255Data = null;
    byte[] productKeyList = new byte[256];

    String getID() {
        return this.strID;
    }

    String getPW() {
        return this.strPW;
    }

    String getIP() {
        return this.strIP;
    }

    public static boolean isIpmiLoginable(String aIP, String aID, String aPW) {
        IPMIInterfaceConfig config = ProductKeyActivation.createIpmiConfig(aIP, aID, aPW);
        boolean bRet = SsmIPMI.isLoginable((IPMIInterfaceConfig)config);
        if (!bRet) {
            logger.debug("Can not log in IPMI at {}.", (Object)aIP);
        }
        return bRet;
    }

    public boolean isIpmiLoginable() {
        IPMIInterfaceConfig config = ProductKeyActivation.createIpmiConfig(this.strIP, this.strID, this.strPW);
        boolean bRet = SsmIPMI.isLoginable((IPMIInterfaceConfig)config);
        if (!bRet) {
            logger.debug("Can not log in IPMI at {}.", (Object)this.strIP);
        }
        return bRet;
    }

    public static boolean isSWFRUSupported(String aIP, String aID, String aPW) throws NoSWFRUSupportException {
        byte[] guid = ProductKeyActivation.createSsmIpmi(aIP, aID, aPW).getGUID();
        StringBuffer sb = new StringBuffer();
        boolean bShouldSupportSwFru = true;
        if (IPMIMessagingCommand.isAMIAddOnGUID(guid) || IPMIMessagingCommand.isAMIAspeedGUID(guid) || IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMIOnBoardGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid) || IPMIMessagingCommand.isAMIX9GUID(guid) || IPMIMessagingCommand.isCMMGUID(guid) || IPMIMessagingCommand.isNormalBladeCMMGUID(guid) || IPMIMessagingCommand.isOfficeBladeCMMGUID(guid) || IPMIMessagingCommand.isOSAGUID(guid) || IPMIMessagingCommand.isPepperconGUID(guid) || IPMIMessagingCommand.isPepperconNoneKVMGUID(guid) || IPMIMessagingCommand.isRenesasAddOnATENGUID(guid) || IPMIMessagingCommand.isRenesasATENGUID(guid) || IPMIMessagingCommand.isSIMBL(guid) || IPMIMessagingCommand.isTwinBladeCMMGUID(guid) || IPMIMessagingCommand.isATENGUID(guid)) {
            byte[] byArray = guid;
            int n = guid.length;
            int n2 = 0;
            while (n2 < n) {
                byte b2 = byArray[n2];
                sb.append(String.format("%02X ", b2));
                ++n2;
            }
            if (IPMIMessagingCommand.isAMIX9GUID(guid)) {
                logger.debug("({}) GUID[{}] should not have SW product key support!", (Object)aIP, (Object)sb.toString());
                throw new NoSWFRUSupportException("This system with AMI X9 IPMI should not support SW prodcut key.");
            }
            logger.debug("({}) GUID[{}] does not have SW product key support!", (Object)aIP, (Object)sb.toString());
            throw new NoSWFRUSupportException("This system does not support SW prodcut key.");
        }
        SsmIPMI aIpmi = ProductKeyActivation.createSsmIpmi(aIP, aID, aPW);
        boolean isSWFRUInitialized = true;
        IPMIMessage msg1 = aIpmi.sendOEMCommandEx("30 68 14 00 00 00 01");
        if (msg1.completionCode != 0) {
            isSWFRUInitialized = false;
        }
        msg1 = aIpmi.sendOEMCommandEx("30 68 15 00 00 00 FF");
        if (msg1.completionCode != 0 || msg1.completionCode == 0 && msg1.data != null && msg1.data.length == 1 && msg1.data[0] != 1) {
            if (msg1.completionCode == 0 && msg1.data != null && msg1.data.length == 1 && msg1.data[0] == 0) {
                logger.debug(String.format("(%s) SW product key is not supported. Completion code=0x%02X, Return value=0x%02X, GUID[%s]", aIP, msg1.completionCode, msg1.data[0], sb.toString()));
            } else {
                logger.debug(String.format("(%s) SW product key is not supported. Completion code=0x%02X, GUID[%s]", aIP, msg1.completionCode, sb.toString()));
            }
            if (!bShouldSupportSwFru) {
                logger.debug("(" + aIP + ") System with IPMI GUID [" + sb.toString() + "] does not support SW prodcut key.");
                throw new NoSWFRUSupportException("This system does not support SW prodcut key.");
            }
            return false;
        }
        if (isSWFRUInitialized) {
            byte b3;
            int nCount = 0;
            msg1 = aIpmi.sendOEMCommandEx("30 68 14 00 01 00 7F");
            byte[] byArray = msg1.data;
            int n = msg1.data.length;
            int n3 = 0;
            while (n3 < n) {
                b3 = byArray[n3];
                if (b3 == 0) {
                    ++nCount;
                }
                ++n3;
            }
            msg1 = aIpmi.sendOEMCommandEx("30 68 14 00 80 00 80");
            byArray = msg1.data;
            n = msg1.data.length;
            n3 = 0;
            while (n3 < n) {
                b3 = byArray[n3];
                if (b3 == 0) {
                    ++nCount;
                }
                ++n3;
            }
            if (nCount == 255) {
                logger.info("({}) Need to reset SW product key.", (Object)aIP);
                isSWFRUInitialized = false;
            }
        }
        if (!isSWFRUInitialized) {
            logger.info("({}) Initialize SW product key.", (Object)aIP);
            msg1 = aIpmi.sendOEMCommandEx("30 68 14 00 00 00 80");
            if (msg1.data[0] != -128 || msg1.data.length != 129) {
                logger.debug("(" + aIP + ") Double check of 1st 128-byte of SW prodcut key fails. data[0]={}, data.length={}", (Object)String.format("0x%02X", msg1.data[0]), (Object)msg1.data.length);
                return false;
            }
            int i2 = 2;
            while (i2 < 129) {
                if (msg1.data[i2] != 0) {
                    logger.debug("(" + aIP + ") Double check of 1st 128-byte of SW prodcut key fails. Data at index[{}]={}", (Object)i2, (Object)msg1.data[i2]);
                    return false;
                }
                ++i2;
            }
            msg1 = aIpmi.sendOEMCommandEx("30 68 14 00 80 00 80");
            if (msg1.data[0] != -128 || msg1.data.length != 129) {
                logger.debug("(" + aIP + ") Double check of 2nd 128-byte of SW prodcut key fails. data[0]={}, data.length={}", (Object)String.format("0x%02X", msg1.data[0]), (Object)msg1.data.length);
                return false;
            }
            i2 = 1;
            while (i2 < 129) {
                if (msg1.data[i2] != 0) {
                    logger.debug("(" + aIP + ") Double check of 2nd 128-byte of SW prodcut key fails. Data at index[{}]={}", (Object)i2, (Object)msg1.data[i2]);
                    return false;
                }
                ++i2;
            }
            msg1 = aIpmi.sendOEMCommandEx("30 68 15 00 00 00 FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF");
            logger.info("(" + aIP + ") Reset 1st 128-byte of SW product key. Completion code={}, len={}", (Object)msg1.completionCode, (Object)(msg1.data[0] & 0xFF));
            msg1 = aIpmi.sendOEMCommandEx("30 68 15 00 80 00 FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF");
            logger.info("(" + aIP + ") Reset 2nd 128-byte of SW product key. Completion code={}, len={}", (Object)msg1.completionCode, (Object)(msg1.data[0] & 0xFF));
        }
        return true;
    }

    public String getOriginalMac() {
        if (this.fru255Data != null) {
            return this.fru255Data.getMac();
        }
        return null;
    }

    private static IPMIInterfaceConfig createIpmiConfig(String aIP, String aID, String aPW) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        if (aIP == null && aID == null && aPW == null) {
            config.setType(2);
        } else {
            config.setIp(aIP);
            config.setUserName(aID);
            config.setPassword(aPW);
        }
        return config;
    }

    private static SsmIPMI createSsmIpmi(String aIP, String aID, String aPW) {
        if (aIP == null && aID == null && aPW == null) {
            return new SsmIPMI();
        }
        return new SsmIPMI(aIP, aID, aPW);
    }

    public ProductKeyActivation(String aIP, String aID, String aPW) throws IPMICmdErrorCompletionCodeException, NoSWFRUSupportException {
        this.ipmi = ProductKeyActivation.createSsmIpmi(aIP, aID, aPW);
        if (!ProductKeyActivation.isSWFRUSupported(aIP, aID, aPW)) {
            byte[] bid = this.getBoardID();
            byte[] guid = this.ipmi.getGUID();
            StringBuffer sb = new StringBuffer();
            byte[] byArray = guid;
            int n = guid.length;
            int n2 = 0;
            while (n2 < n) {
                byte b2 = byArray[n2];
                sb.append(String.format("%02X ", b2));
                ++n2;
            }
            logger.debug("(" + aIP + ") Has problem in accessing SW product key. (Board ID: " + String.format("%02X%02X", bid[1], bid[0]) + ", IPMI GUID:" + sb.toString() + ").");
            throw new NoSWFRUSupportException("Has problem in accessing SW product key.");
        }
        try {
            this.productKeyList = this.readSWFRURawData(0);
        }
        catch (IPMICmdErrorCompletionCodeException e2) {
            logger.debug("(" + aIP + ") There is no data at index 0. Call clearProduckeyListSWFRU0()....");
            this.clearProduckeyListSWFRU0();
        }
        byte[] fru255Ba = null;
        try {
            fru255Ba = this.readSWFRURawData(255);
        }
        catch (IPMICmdErrorCompletionCodeException e3) {
            logger.debug("(" + aIP + ") Can not access SW FRU 255 data in ProductKeyActivation constructor!");
            return;
        }
        byte len = fru255Ba[1];
        byte[] bodyBa = Arrays.copyOfRange(fru255Ba, 2, len + 2);
        if (len > 0) {
            try {
                this.fru255Data = AESSWFru255Data.decryptMacAddressAndTimestamp(this.getBoardID(), bodyBa);
            }
            catch (Exception e4) {
                System.out.println(e4.getMessage());
                logger.debug("(" + aIP + ") Has problem in getting SW FRU 255 data in ProductKeyActivation constructor!");
            }
        }
    }

    public Date getIPMITime() {
        IPMIMessage msg = this.ipmi.sendOEMCommandEx("0a 48");
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            byte[] byArray = msg.data;
            int n = msg.data.length;
            int n2 = 0;
            while (n2 < n) {
                byte b2 = byArray[n2];
                sb.append(String.format("%02X", b2));
                ++n2;
            }
            logger.debug("(" + this.strIP + ") IPMI cmd 0x0a 0x48  returns: ", (Object)sb.toString());
        }
        byte[] tmpBa = Arrays.copyOf(msg.data, msg.data.length);
        assert (tmpBa.length == 4);
        return ProductKey.fourByteToDate(tmpBa);
    }

    public boolean isProductKeyExpired(ProductKey aKey) {
        if (aKey.getExpirationDate().getTime() == 0L) {
            return false;
        }
        return this.getIPMITime().getTime() > aKey.getExpirationDate().getTime();
    }

    public String getMacAddress() throws IPMICmdErrorCompletionCodeException {
        IPMIMessage msg = this.ipmi.sendOEMCommandEx("0c 02 01 05 00 00");
        if (msg.completionCode != 0) {
            throw new IPMICmdErrorCompletionCodeException(msg.completionCode, "Has problem in getting MAC address at IP: " + this.strIP);
        }
        StringBuffer sb = new StringBuffer();
        boolean isFirstByte = true;
        byte[] byArray = msg.data;
        int n = msg.data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b2 = byArray[n2];
            if (isFirstByte) {
                isFirstByte = false;
            } else {
                sb.append(String.format("%02X", b2));
            }
            ++n2;
        }
        logger.debug("(" + this.strIP + ") getMacAddress() returns: " + sb.toString());
        return sb.toString();
    }

    public byte[] getBoardID() throws IPMICmdErrorCompletionCodeException {
        IPMIMessage msg = this.ipmi.sendOEMCommandEx("30 21");
        if (msg.completionCode != 0) {
            throw new IPMICmdErrorCompletionCodeException(msg.completionCode, "Has problem in getting Board ID at IP: " + this.strIP);
        }
        ByteBuffer bf = ByteBuffer.allocate(2);
        bf.put(msg.data[1]);
        bf.put(msg.data[0]);
        logger.debug("(" + this.strIP + ") getBoardID() returns: " + String.format("%02X%02X", msg.data[1], msg.data[0]));
        return bf.array();
    }

    public void clearProduckeyListSWFRU0() throws IPMICmdErrorCompletionCodeException {
        logger.trace("(" + this.strIP + ") Enter clearProduckeyListSWFRU0()");
        int i2 = 0;
        while (i2 < 256) {
            this.productKeyList[i2] = -1;
            ++i2;
        }
        this.writeSWFRURawData(0, this.productKeyList);
    }

    public void clearAllSWFRU() throws IPMICmdErrorCompletionCodeException {
        logger.trace("(" + this.strIP + ") Enter clearAllSWFRU()");
        this.clearProduckeyListSWFRU0();
        int i2 = 1;
        while (i2 <= 254) {
            try {
                this.clearProductKey(i2);
            }
            catch (InvalidSWFRUIndexException e2) {
                if (e2.getMessage().indexOf("There is no product key at index") == 0) {
                    logger.debug("(" + this.strIP + ") There is no product key at index {}.", (Object)i2);
                }
                System.out.println("Error! It should not reach this line in clearAllSWFRU()!");
                System.exit(1);
            }
            ++i2;
        }
    }

    public int getNumOfProductKey() {
        logger.trace("(" + this.strIP + ") Enter getNumOfProductKey()");
        int num = 0;
        try {
            this.productKeyList = this.readSWFRURawData(0);
        }
        catch (IPMICmdErrorCompletionCodeException e2) {
            logger.debug("(" + this.strIP + ") Error in reading data from SW FRU0. Completion code: 0x" + String.format("%02X", e2.getCompletionCode()));
        }
        int i2 = 1;
        while (i2 < this.productKeyList.length) {
            if (this.productKeyList[i2] != -1 && this.productKeyList[i2] != 0) {
                logger.debug("(" + this.strIP + ") SWID:{} at SW FRU{}", (Object)this.productKeyList[i2], (Object)i2);
                ++num;
            }
            ++i2;
        }
        return num;
    }

    public Integer[] getFRUIndexOfProductKey(SWIDEnum aSwIdEnum) {
        byte id = aSwIdEnum.getID();
        logger.trace("(" + this.strIP + ") Enter getFRUIndexOfProductKey({})", (Object)String.format("0x%02X", id));
        try {
            this.productKeyList = this.readSWFRURawData(0);
        }
        catch (IPMICmdErrorCompletionCodeException e2) {
            logger.debug("(" + this.strIP + ") Error in reading data from SW FRU0. Completion code: 0x" + String.format("%02X", e2.getCompletionCode()));
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < this.productKeyList.length) {
            if (this.productKeyList[i2] == id) {
                logger.debug("(" + this.strIP + ") SWID:{} at SW FRU{}", (Object)this.productKeyList[i2], (Object)i2);
                indexList.add(new Integer(i2));
            }
            ++i2;
        }
        return indexList.toArray(new Integer[0]);
    }

    public byte getProductKeySWID(int anIdx) {
        logger.debug("(" + this.strIP + ") getProductKeySWID({}) returns {}.", (Object)anIdx, (Object)this.productKeyList[anIdx]);
        return this.productKeyList[anIdx];
    }

    byte[] readSWFRURawData(int aFRUIdx) throws IPMICmdErrorCompletionCodeException {
        IPMIMessage msg1 = this.ipmi.sendOEMCommandEx("30 68 14 " + String.format("%02X", aFRUIdx) + " 00 00 40");
        if (msg1.completionCode != 0) {
            throw new IPMICmdErrorCompletionCodeException(msg1.completionCode, "Has problem in reading the first 128 bytes from SW FRU" + aFRUIdx + ". IPMI Cmd Completion Code:" + String.format("%02X", msg1.completionCode));
        }
        if (msg1.data[0] != 64 || msg1.data.length != 65) {
            throw new IPMICmdErrorCompletionCodeException(msg1.completionCode, "Can not get 1st 128-byte data from SW FRU" + aFRUIdx);
        }
        IPMIMessage msg2 = this.ipmi.sendOEMCommandEx("30 68 14 " + String.format("%02X", aFRUIdx) + " 40 00 40");
        if (msg2.completionCode != 0) {
            throw new IPMICmdErrorCompletionCodeException(msg2.completionCode, "Has problem in reading the second 128 bytes from SW FRU" + aFRUIdx + ". IPMI Cmd Completion Code:" + String.format("%02X", msg2.completionCode));
        }
        if (msg2.data[0] != 64 || msg2.data.length != 65) {
            throw new IPMICmdErrorCompletionCodeException(msg2.completionCode, "Can not get 2nd 128-byte data from SW FRU" + aFRUIdx);
        }
        IPMIMessage msg3 = this.ipmi.sendOEMCommandEx("30 68 14 " + String.format("%02X", aFRUIdx) + " 80 00 40");
        if (msg3.completionCode != 0) {
            throw new IPMICmdErrorCompletionCodeException(msg3.completionCode, "Has problem in reading the second 128 bytes from SW FRU" + aFRUIdx + ". IPMI Cmd Completion Code:" + String.format("%02X", msg3.completionCode));
        }
        if (msg3.data[0] != 64 || msg3.data.length != 65) {
            throw new IPMICmdErrorCompletionCodeException(msg3.completionCode, "Can not get 2nd 128-byte data from SW FRU" + aFRUIdx);
        }
        IPMIMessage msg4 = this.ipmi.sendOEMCommandEx("30 68 14 " + String.format("%02X", aFRUIdx) + " C0 00 40");
        if (msg4.completionCode != 0) {
            throw new IPMICmdErrorCompletionCodeException(msg4.completionCode, "Has problem in reading the second 128 bytes from SW FRU" + aFRUIdx + ". IPMI Cmd Completion Code:" + String.format("%02X", msg4.completionCode));
        }
        if (msg4.data[0] != 64 || msg4.data.length != 65) {
            throw new IPMICmdErrorCompletionCodeException(msg4.completionCode, "Can not get 2nd 128-byte data from SW FRU" + aFRUIdx);
        }
        byte[] ba = new byte[256];
        int i2 = 0;
        while (i2 < 64) {
            ba[i2] = msg1.data[i2 + 1];
            ba[i2 + 64] = msg2.data[i2 + 1];
            ba[i2 + 128] = msg3.data[i2 + 1];
            ba[i2 + 192] = msg4.data[i2 + 1];
            ++i2;
        }
        if (logger.isDebugEnabled()) {
            StringBuffer logmsg = new StringBuffer();
            logmsg.append("(" + this.strIP + ") readSWFRURawData(" + aFRUIdx + "): ");
            byte[] byArray = ba;
            int n = ba.length;
            int n2 = 0;
            while (n2 < n) {
                byte b2 = byArray[n2];
                logmsg.append(String.format("%02X ", b2));
                ++n2;
            }
            logger.debug(logmsg.toString());
        }
        return ba;
    }

    public byte[] getEncryptedProductKey(int aFRUIdx) throws InvalidSWFRUIndexException, IPMICmdErrorCompletionCodeException {
        if (aFRUIdx <= 0 || aFRUIdx >= 255) {
            throw new InvalidSWFRUIndexException("Invalid index for product key: " + aFRUIdx);
        }
        return this.readSWFRURawData(aFRUIdx);
    }

    void writeSWFRURawData(int aFRUIdx, byte[] aPKAry) throws IPMICmdErrorCompletionCodeException {
        String cmd = "30 68 15 " + String.format("%02X", aFRUIdx) + " 00 00 ";
        String cmd2 = "";
        byte[] byArray = aPKAry;
        int n = aPKAry.length;
        int n2 = 0;
        while (n2 < n) {
            byte b2 = byArray[n2];
            cmd2 = String.valueOf(cmd2) + String.format("%02X ", b2);
            ++n2;
        }
        IPMIMessage msg = this.ipmi.sendOEMCommandEx(String.valueOf(cmd) + cmd2);
        if (logger.isDebugEnabled()) {
            logger.debug("(" + this.strIP + ") writeSWFRURawData(" + aFRUIdx + "): " + cmd2 + ", Completion code:" + msg.completionCode);
        }
        if (msg.completionCode != 0) {
            throw new IPMICmdErrorCompletionCodeException(msg.completionCode, "Has problem in writing at index " + aFRUIdx + ". IPMI Cmd Completion Code:" + String.format("%02X", msg.completionCode));
        }
    }

    void writeSWFRU255Data(byte[] aBoardID, String aMAC) throws InvalidSWFRUDataException, IPMICmdErrorCompletionCodeException {
        byte[] ba = AESSWFru255Data.createSWFRU255Data(aBoardID, aMAC);
        this.writeSWFRURawData(255, ba);
    }

    void writeSWFRU255Data() throws InvalidSWFRUDataException, IPMICmdErrorCompletionCodeException {
        this.writeSWFRU255Data(this.getBoardID(), this.getMacAddress());
    }

    public void setEncryptedProductKey(int aFRUIdx, byte[] aPKAry) throws InvalidSWFRUIndexException, IPMICmdErrorCompletionCodeException, BadPaddingException {
        this.setEncryptedProductKey(aFRUIdx, aPKAry, true);
    }

    public void setEncryptedProductKey(int aFRUIdx, byte[] aPKAry, boolean aCheckSWIDDuplication) throws InvalidSWFRUIndexException, IPMICmdErrorCompletionCodeException, BadPaddingException {
        if (aFRUIdx <= 0 || aFRUIdx >= 255) {
            throw new InvalidSWFRUIndexException("Invalid index for product key: " + aFRUIdx);
        }
        ProductKey aKey = null;
        try {
            String tmpStr = Base64.encode(aPKAry);
            aKey = ProductKey.parseByteArray(AESTool.getBase64DecodeAndDecrypted(ProductKey.getNumOfUnencryptBlock(), this.getMacAddress(), tmpStr));
            if (aCheckSWIDDuplication) {
                int i2 = 0;
                while (i2 < 255) {
                    if (this.productKeyList[i2] == aKey.getSWID()) {
                        throw new InvalidSWFRUIndexException("Duplicate SWID[" + aKey.getSWID() + "] at index " + i2 + "!");
                    }
                    ++i2;
                }
            }
            this.productKeyList[aFRUIdx] = aKey.getSWID();
            String cmd = "30 68 15 00 " + String.format("%02X", aFRUIdx) + " 00 " + String.format("%02X", aKey.getSWID());
            IPMIMessage msg = this.ipmi.sendOEMCommandEx(cmd);
            if (msg.completionCode != 0) {
                throw new IPMICmdErrorCompletionCodeException(msg.completionCode, "Has problem in writing the SWID (" + aKey.getSWID() + ") at index " + aFRUIdx + ". IPMI Cmd Completion Code:" + String.format("%02X", msg.completionCode));
            }
        }
        catch (InvalidProductKeyFormatException e2) {
            e2.printStackTrace();
        }
        catch (InvalidKeyException e3) {
            e3.printStackTrace();
        }
        catch (NoSuchAlgorithmException e4) {
            e4.printStackTrace();
        }
        catch (NoSuchPaddingException e5) {
            e5.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e6) {
            e6.printStackTrace();
        }
        catch (UnsupportedEncodingException e7) {
            e7.printStackTrace();
        }
        catch (IllegalBlockSizeException e8) {
            e8.printStackTrace();
        }
        catch (InvalidMacAddressFormatException e9) {
            e9.printStackTrace();
        }
        catch (Base64DecodingException e10) {
            e10.printStackTrace();
        }
        this.writeSWFRURawData(aFRUIdx, aPKAry);
    }

    public void clearProductKey(int aFRUIdx) throws InvalidSWFRUIndexException, IPMICmdErrorCompletionCodeException {
        if (aFRUIdx <= 0 || aFRUIdx >= 255) {
            throw new InvalidSWFRUIndexException("Invalid index for product key: " + aFRUIdx);
        }
        byte[] aProductKeyList = new byte[256];
        this.writeSWFRURawData(aFRUIdx, aProductKeyList);
        String cmd = "30 68 15 00 " + String.format("%02X", aFRUIdx) + " 00 FF";
        IPMIMessage msg = this.ipmi.sendOEMCommandEx(cmd);
        if (msg.completionCode != 0) {
            throw new IPMICmdErrorCompletionCodeException(msg.completionCode, "Has problem in writing the SWID (FF) at index " + aFRUIdx + ". IPMI Cmd Completion Code:" + String.format("%02X", msg.completionCode));
        }
        this.productKeyList[aFRUIdx] = -1;
    }

    public int findNextSWFRUIndex() throws InvalidSWFRUIndexException {
        int i2 = 1;
        while (i2 < 255) {
            if (this.productKeyList[i2] == -1) {
                logger.debug("(" + this.strIP + ") findNextSWFRUIndex() returns " + i2);
                return i2;
            }
            ++i2;
        }
        throw new InvalidSWFRUIndexException("Can not find an available space to activate a product key!");
    }

    public void activateProductKey(byte[] aPKAry) throws InvalidSWFRUIndexException, IPMICmdErrorCompletionCodeException, BadPaddingException {
        this.setEncryptedProductKey(this.findNextSWFRUIndex(), aPKAry);
    }
}

