/*
 * Decompiled with CFR 0.152.
 */
package dyorgio.runtime.out.process;

import dyorgio.runtime.out.process.CallableSerializable;
import dyorgio.runtime.out.process.DefaultProcessBuilderFactory;
import dyorgio.runtime.out.process.OutProcessDiedException;
import dyorgio.runtime.out.process.OutProcessUtils;
import dyorgio.runtime.out.process.ProcessBuilderFactory;
import dyorgio.runtime.out.process.entrypoint.RemoteMain;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class OutProcessExecutorService
extends AbstractExecutorService {
    private static final String RUNNING_AS_OUT_PROCESS = "$RunnningAsOutProcess";
    private volatile boolean shutdown = false;
    private final ProcessBuilderFactory processBuilderFactory;
    private final PipeServer pipeServer;
    private final BlockingQueue<SerializableFutureTask> toProcessQueue = new LinkedBlockingQueue<SerializableFutureTask>();

    public OutProcessExecutorService(String ... javaOptions) throws Exception {
        this((ProcessBuilderFactory)new DefaultProcessBuilderFactory(), (String)null, javaOptions);
    }

    public OutProcessExecutorService(String classpath, String[] javaOptions) throws Exception {
        this((ProcessBuilderFactory)new DefaultProcessBuilderFactory(), classpath, javaOptions);
    }

    public OutProcessExecutorService(ProcessBuilderFactory processBuilderFactory, String ... javaOptions) throws Exception {
        this(processBuilderFactory, (String)null, javaOptions);
    }

    public OutProcessExecutorService(ProcessBuilderFactory processBuilderFactory, String classpath, String[] javaOptions) throws Exception {
        if (processBuilderFactory == null) {
            throw new NullPointerException("Process Builder Factory cannot be null.");
        }
        this.processBuilderFactory = processBuilderFactory;
        this.pipeServer = new PipeServer(classpath == null ? OutProcessUtils.getCurrentClasspath() : classpath, javaOptions);
        this.pipeServer.start();
        int socketWaitCount = 0;
        RuntimeException startupException = null;
        while (startupException != null && this.pipeServer.socket == null && socketWaitCount < 300) {
            ++socketWaitCount;
            startupException = this.checkStart();
            Thread.sleep(50L);
        }
        if (startupException != null) {
            this.shutdownNow();
            this.awaitTermination(3L, TimeUnit.SECONDS);
            throw startupException;
        }
    }

    private RuntimeException checkStart() throws IOException {
        RuntimeException startupException = null;
        if (!OutProcessUtils.isRunning(this.pipeServer.process)) {
            int readed;
            int exitCode = this.pipeServer.process.exitValue();
            byte[] errorBuffer = new byte[32768];
            int n = readed = this.pipeServer.process.getErrorStream().available() > 0 ? this.pipeServer.process.getErrorStream().read(errorBuffer) : -1;
            if (readed < 1) {
                int n2 = readed = this.pipeServer.process.getInputStream().available() > 0 ? this.pipeServer.process.getInputStream().read(errorBuffer) : -1;
                startupException = readed < 1 ? new RuntimeException("Cannot start an OutProcess: " + exitCode) : new RuntimeException("Cannot start an OutProcess: " + exitCode + "\r\nOUT:\r\n" + new String(errorBuffer, 0, readed));
            } else {
                startupException = new RuntimeException("Cannot start an OutProcess: " + exitCode + "\r\nERROR:\r\n" + new String(errorBuffer, 0, readed));
            }
        }
        return startupException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkProcess(SerializableFutureTask task, Throwable ex) {
        if (!OutProcessUtils.isRunning(this.pipeServer.process) || ex instanceof SocketException) {
            int exitCode = this.pipeServer.process.exitValue();
            ExecutionException executionException = null;
            if (exitCode != 0) {
                try {
                    byte[] errorBuffer = new byte[32768];
                    int readed = this.pipeServer.process.getErrorStream().read(errorBuffer);
                    if (readed < 1) {
                        readed = this.pipeServer.process.getInputStream().read(errorBuffer);
                        if (readed > 0) {
                            executionException = new ExecutionException(new RejectedExecutionException("Error in OutProcess: " + exitCode + "\r\nOUT:\r\n" + new String(errorBuffer, 0, readed), ex));
                        }
                    } else {
                        executionException = new ExecutionException(new RejectedExecutionException("Error in OutProcess: " + exitCode + "\r\nERROR:\r\n" + new String(errorBuffer, 0, readed), ex));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (executionException == null) {
                executionException = new ExecutionException(new RejectedExecutionException("OutProcess Finished: " + exitCode));
            }
            this.shutdown();
            while (task != null) {
                task.executionException = executionException;
                task.done = true;
                SerializableFutureTask serializableFutureTask = task;
                synchronized (serializableFutureTask) {
                    task.notifyAll();
                }
                task = (SerializableFutureTask)this.toProcessQueue.poll();
            }
            this.shutdownNow();
            return false;
        }
        return true;
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        this.pipeServer.close();
        ArrayList<Runnable> notProcessed = new ArrayList<Runnable>();
        this.toProcessQueue.drainTo(notProcessed);
        return notProcessed;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown() && !this.pipeServer.isAlive();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.pipeServer.join(unit.toMillis(timeout));
        return this.pipeServer.isAlive();
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new SerializableFutureTask(this, callable);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new SerializableFutureTask(this, runnable, (Serializable)value);
    }

    @Override
    public void execute(Runnable runnable) {
        if (this.shutdown) {
            throw new RejectedExecutionException("Task " + runnable.toString() + " rejected from " + this.toString());
        }
        if (System.getProperty(RUNNING_AS_OUT_PROCESS) != null) {
            runnable.run();
        } else {
            if (runnable instanceof SerializableFutureTask) {
                try {
                    this.toProcessQueue.put((SerializableFutureTask)runnable);
                }
                catch (InterruptedException ex) {
                    throw new RejectedExecutionException(ex);
                }
            }
            try {
                this.toProcessQueue.put(new SerializableFutureTask(this, runnable, null));
            }
            catch (InterruptedException ex) {
                throw new RejectedExecutionException(ex);
            }
        }
    }

    private class PipeServer
    extends Thread {
        private final ServerSocket server;
        private final String secret;
        private final Process process;
        private Socket socket;

        PipeServer(String classpath, String ... javaOptions) throws Exception {
            super("OutProcess-PipeServer");
            this.server = new ServerSocket(0);
            this.server.setSoTimeout(250);
            Random r = new Random(System.nanoTime());
            this.secret = String.valueOf(r.nextLong()) + ":" + r.nextLong();
            ArrayList<String> commandList = new ArrayList<String>();
            commandList.add(String.valueOf(System.getProperty("java.home")) + File.separatorChar + "bin" + File.separatorChar + "java");
            commandList.addAll(Arrays.asList(javaOptions));
            commandList.add("-cp");
            commandList.add(classpath);
            commandList.add(RemoteMain.class.getName());
            commandList.add(String.valueOf(this.server.getLocalPort()));
            commandList.add(this.secret);
            this.process = OutProcessExecutorService.this.processBuilderFactory.create(commandList).start();
            OutProcessExecutorService.this.processBuilderFactory.consume(this.process);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!OutProcessExecutorService.this.shutdown && !this.isInterrupted()) {
                try {
                    block28: {
                        try {
                            this.socket = this.server.accept();
                        }
                        catch (SocketTimeoutException ste) {
                            RuntimeException startException = OutProcessExecutorService.this.checkStart();
                            if (startException == null) break block28;
                            throw startException;
                        }
                    }
                    if (this.socket == null) continue;
                    DataInputStream input = new DataInputStream(this.socket.getInputStream());
                    String clientSecret = input.readUTF();
                    if (clientSecret.equals(this.secret)) {
                        DataOutputStream output = new DataOutputStream(this.socket.getOutputStream());
                        int[] length = new int[1];
                        while (!OutProcessExecutorService.this.shutdown) {
                            SerializableFutureTask serializableFutureTask;
                            SerializableFutureTask task = (SerializableFutureTask)OutProcessExecutorService.this.toProcessQueue.poll(50L, TimeUnit.MILLISECONDS);
                            if (task == null) continue;
                            try {
                                OutProcessUtils.writeObject(output, task.callable, length);
                                if (input.readBoolean()) {
                                    task.result = OutProcessUtils.readObject(input, Serializable.class);
                                } else {
                                    Throwable throwable = OutProcessUtils.readObject(input, Throwable.class);
                                    task.executionException = new ExecutionException(throwable);
                                    if (throwable instanceof OutProcessDiedException) {
                                        OutProcessExecutorService.this.shutdownNow();
                                    }
                                }
                            }
                            catch (EOFException e2) {
                                task.executionException = new ExecutionException(new RejectedExecutionException("Closed OutProcess socket."));
                                OutProcessExecutorService.this.shutdownNow();
                                task.done = true;
                                serializableFutureTask = task;
                                synchronized (serializableFutureTask) {
                                    task.notifyAll();
                                    continue;
                                }
                            }
                            catch (Throwable e3) {
                                block29: {
                                    try {
                                        if (!OutProcessExecutorService.this.checkProcess(task, e3)) break block29;
                                        task.executionException = new ExecutionException(e3);
                                        OutProcessExecutorService.this.shutdownNow();
                                    }
                                    catch (Throwable throwable) {
                                        task.done = true;
                                        serializableFutureTask = task;
                                        synchronized (serializableFutureTask) {
                                            task.notifyAll();
                                        }
                                        throw throwable;
                                    }
                                }
                                task.done = true;
                                serializableFutureTask = task;
                                synchronized (serializableFutureTask) {
                                    task.notifyAll();
                                    continue;
                                }
                            }
                            task.done = true;
                            serializableFutureTask = task;
                            synchronized (serializableFutureTask) {
                                task.notifyAll();
                            }
                        }
                        continue;
                    }
                    this.socket.close();
                }
                catch (Exception e4) {
                    break;
                }
            }
        }

        public void close() {
            try {
                this.server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.interrupt();
                if (!this.isInterrupted()) {
                    this.interrupt();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.join(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.process.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final class SerializableCall
    implements CallableSerializable {
        private final Runnable runnable;
        private final Serializable value;

        private SerializableCall(Runnable runnable, Serializable value) {
            this.runnable = runnable;
            this.value = value;
        }

        @Override
        public Serializable call() throws Exception {
            this.runnable.run();
            return this.value;
        }
    }

    private static class SerializableFutureTask
    implements RunnableFuture<Serializable> {
        private final OutProcessExecutorService executor;
        private final Callable<Serializable> callable;
        private boolean done = false;
        private Serializable result;
        private ExecutionException executionException;

        public SerializableFutureTask(OutProcessExecutorService executor, Runnable runnable, Serializable value) {
            if (!(runnable instanceof Serializable)) {
                throw new RejectedExecutionException(new NotSerializableException());
            }
            this.executor = executor;
            this.callable = new SerializableCall(runnable, value);
        }

        public SerializableFutureTask(OutProcessExecutorService executor, Callable<Serializable> callable) {
            if (!(callable instanceof Serializable)) {
                throw new RejectedExecutionException(new NotSerializableException());
            }
            this.executor = executor;
            this.callable = callable;
        }

        @Override
        public void run() {
            throw new UnsupportedOperationException("Cannot run a remote task locally.");
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException("Cannot cancel a remote task.");
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public Serializable get() throws InterruptedException, ExecutionException {
            if (!this.done) ** GOTO lbl11
            return this.getResult();
lbl-1000:
            // 1 sources

            {
                if (OutProcessExecutorService.access$4(this.executor, this, null)) continue;
                var1_1 = this;
                synchronized (var1_1) {
                    this.wait(50L);
                    continue;
                }
lbl11:
                // 3 sources

                ** while (!this.done)
            }
lbl12:
            // 1 sources

            return this.getResult();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Serializable get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.done) {
                return this.getResult();
            }
            SerializableFutureTask serializableFutureTask = this;
            synchronized (serializableFutureTask) {
                this.wait(unit.toMillis(timeout));
            }
            if (this.done) {
                return this.getResult();
            }
            throw new TimeoutException();
        }

        private Serializable getResult() throws ExecutionException {
            if (this.executionException != null) {
                throw this.executionException;
            }
            return this.result;
        }
    }
}

